/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree;

import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCriteriumTree;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.CTreeNodeRenderer;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.JCriteriumTreeModel;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.JCriteriumTreeNode;
import com.google.security.zynamics.zylib.gui.jtree.TreeHelpers;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public final class JCriteriumTree
extends JTree {
    private static final long serialVersionUID = 9053115808955523376L;
    private final InternalMouseListener m_mouseListener = new InternalMouseListener();
    private final JCriteriumTreeModel m_model;
    private TreePath m_currentCriteriumPath = null;

    public JCriteriumTree(CCriteriumTree ctree, List<ICriteriumCreator> criteria) {
        this.m_model = new JCriteriumTreeModel(this, ctree, criteria);
        this.setRootVisible(true);
        this.setModel(this.m_model);
        this.setCellRenderer(new CTreeNodeRenderer());
        this.addMouseListener(this.m_mouseListener);
    }

    private void showPopupMenu(MouseEvent event) {
        JPopupMenu menu;
        JCriteriumTreeNode selectedNode = (JCriteriumTreeNode)TreeHelpers.getNodeAt(this, event.getX(), event.getY());
        if (selectedNode != null && (menu = selectedNode.getPopupMenu()) != null) {
            menu.show(this, event.getX(), event.getY());
        }
    }

    public void delete() {
        this.m_model.dispose();
        this.removeMouseListener(this.m_mouseListener);
    }

    public TreePath getCurrentCriteriumPath() {
        return this.m_currentCriteriumPath;
    }

    @Override
    public JCriteriumTreeModel getModel() {
        return this.m_model;
    }

    public void setCurrentCriteriumPath(TreePath path) {
        this.m_currentCriteriumPath = path;
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            JCriteriumTree.this.m_currentCriteriumPath = JCriteriumTree.this.getPathForLocation(event.getX(), event.getY());
            if (event.isPopupTrigger()) {
                JCriteriumTree.this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            JCriteriumTree.this.m_currentCriteriumPath = JCriteriumTree.this.getPathForLocation(event.getX(), event.getY());
            if (event.isPopupTrigger()) {
                JCriteriumTree.this.showPopupMenu(event);
            }
        }
    }
}

