/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree;

import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.And.CAndCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.CConditionCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Not.CNotCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Or.COrCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCriteriumTree;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCriteriumTreeNode;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.Actions.CAddConditionAction;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.Actions.CAppendAndOperatorAction;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.Actions.CAppendNotOperatorAction;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.Actions.CAppendOrOperatorAction;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.Actions.CInsertAndOperatorAction;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.Actions.CInsertNotOperatorAction;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.Actions.CInsertOrOperatorAction;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.Actions.CRemoveAction;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.Actions.CRemoveAllAction;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.JCriteriumTreeNode;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Implementations.CCriteriumFunctions;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public final class CNodeMenuBuilder {
    private final JCriteriumTreeNode m_criteriumNode;
    private final JPopupMenu m_popup = new JPopupMenu();
    private final JMenuItem m_insertAnd;
    private final JMenuItem m_insertOr;
    private final JMenuItem m_insertNot;
    private final JMenuItem m_appendAnd;
    private final JMenuItem m_appendOr;
    private final JMenuItem m_appendNot;
    private final JMenu m_conditionSubmenu;
    private final JMenuItem m_remove;
    private final JMenuItem m_removeAll;

    public CNodeMenuBuilder(JCriteriumTreeNode node, CCriteriumTree ctree, List<ICriteriumCreator> criteria) {
        this.m_criteriumNode = node;
        CCriteriumTreeNode clickedCriterium = CCriteriumFunctions.findNode(ctree.getRoot(), node.getCriterium());
        this.m_appendAnd = new JMenuItem(new CAppendAndOperatorAction(ctree, clickedCriterium));
        this.m_appendOr = new JMenuItem(new CAppendOrOperatorAction(ctree, clickedCriterium));
        this.m_appendNot = new JMenuItem(new CAppendNotOperatorAction(ctree, clickedCriterium));
        this.m_popup.add(this.m_appendAnd);
        this.m_popup.add(this.m_appendOr);
        this.m_popup.add(this.m_appendNot);
        this.m_popup.add(new JSeparator());
        this.m_insertAnd = new JMenuItem(new CInsertAndOperatorAction(ctree, clickedCriterium));
        this.m_insertOr = new JMenuItem(new CInsertOrOperatorAction(ctree, clickedCriterium));
        this.m_insertNot = new JMenuItem(new CInsertNotOperatorAction(ctree, clickedCriterium));
        this.m_popup.add(this.m_insertAnd);
        this.m_popup.add(this.m_insertOr);
        this.m_popup.add(this.m_insertNot);
        this.m_popup.add(new JSeparator());
        this.m_conditionSubmenu = new JMenu("Create Condition");
        for (ICriteriumCreator condition : criteria) {
            this.m_conditionSubmenu.add(new JMenuItem(new CAddConditionAction(ctree, clickedCriterium, condition)));
        }
        this.m_popup.add(this.m_conditionSubmenu);
        this.m_popup.add(new JSeparator());
        this.m_remove = new JMenuItem(new CRemoveAction(ctree, clickedCriterium));
        this.m_popup.add(this.m_remove);
        this.m_popup.add(new JSeparator());
        this.m_removeAll = new JMenuItem(new CRemoveAllAction(ctree));
        this.m_popup.add(this.m_removeAll);
    }

    private void updateMenuState() {
        this.m_appendAnd.setEnabled(this.m_criteriumNode.allowAppend(CAndCriterium.class));
        this.m_appendOr.setEnabled(this.m_criteriumNode.allowAppend(COrCriterium.class));
        this.m_appendNot.setEnabled(this.m_criteriumNode.allowAppend(CNotCriterium.class));
        this.m_insertAnd.setEnabled(this.m_criteriumNode.allowInsert(CAndCriterium.class));
        this.m_insertOr.setEnabled(this.m_criteriumNode.allowInsert(COrCriterium.class));
        this.m_insertNot.setEnabled(this.m_criteriumNode.allowInsert(CNotCriterium.class));
        this.m_conditionSubmenu.setEnabled(this.m_criteriumNode.allowAppend(CConditionCriterium.class));
        this.m_remove.setEnabled(!this.m_criteriumNode.isRoot());
        this.m_removeAll.setEnabled(this.m_criteriumNode.getChildCount() != 0);
    }

    public JPopupMenu getPopup() {
        this.updateMenuState();
        return this.m_popup;
    }
}

