/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel;

import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCachedExpressionTreeNode;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.ICriteriumTreeNode;
import java.util.ArrayList;
import java.util.List;

public final class CCriteriumTreeNode
implements ICriteriumTreeNode {
    private ICriteriumTreeNode m_parent;
    private final List<CCriteriumTreeNode> m_children = new ArrayList<CCriteriumTreeNode>();
    private final ICriterium m_criterium;

    public CCriteriumTreeNode(ICriterium criterium) {
        this.m_criterium = criterium;
    }

    public static void append(CCriteriumTreeNode parent, CCriteriumTreeNode child) {
        parent.getChildren().add(child);
        child.m_parent = parent;
    }

    public static void insert(CCriteriumTreeNode parent, CCriteriumTreeNode child) {
        for (CCriteriumTreeNode grandchild : parent.getChildren()) {
            child.getChildren().add(grandchild);
            grandchild.m_parent = child;
        }
        parent.getChildren().clear();
        parent.getChildren().add(child);
        child.m_parent = parent;
    }

    public static void remove(ICriteriumTreeNode node) {
        for (ICriteriumTreeNode iCriteriumTreeNode : node.getChildren()) {
            CCriteriumTreeNode.remove(iCriteriumTreeNode);
        }
        node.getChildren().clear();
    }

    public CCachedExpressionTreeNode createCachedNode() {
        return new CCachedExpressionTreeNode(this.m_criterium.createCachedCriterium());
    }

    public List<CCriteriumTreeNode> getChildren() {
        return this.m_children;
    }

    @Override
    public ICriterium getCriterium() {
        return this.m_criterium;
    }

    @Override
    public ICriteriumTreeNode getParent() {
        return this.m_parent;
    }
}

