/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.NodeColor;

import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.NodeColor.CColorCriterium;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.ColorPanel.ColorPanel;
import com.google.security.zynamics.zylib.gui.ColorPanel.IColorPanelListener;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public final class CColorCriteriumPanel
extends JPanel {
    private static final long serialVersionUID = 8472785670692105722L;
    private final CColorCriterium m_colorCriterium;
    private final ColorPanel m_selectedColorPanel = new ColorPanel(null, false);
    private final List<ColorPanel> m_colorPanels = new ArrayList<ColorPanel>();
    private final InternalColorPanelListener m_colorPanelListener = new InternalColorPanelListener();

    public CColorCriteriumPanel(CColorCriterium colorCriterium, ZyGraph graph) {
        super(new BorderLayout());
        this.m_colorCriterium = colorCriterium;
        this.m_selectedColorPanel.addListener(this.m_colorPanelListener);
        this.m_selectedColorPanel.addMouseListener(this.m_colorPanelListener);
        this.initPanel(graph);
    }

    private List<Color> getColors(ZyGraph graph) {
        final HashMap colors2 = new HashMap();
        graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode item) {
                Color color = item.getRawNode().getColor();
                if (!colors2.containsKey(color)) {
                    colors2.put(color, 0);
                }
                colors2.put(color, (Integer)colors2.get(color) + 1);
                return IterationMode.CONTINUE;
            }
        });
        ArrayList<Map.Entry<Color, Integer>> colorList = new ArrayList<Map.Entry<Color, Integer>>(colors2.entrySet());
        Collections.sort(colorList, new Comparator<Map.Entry<Color, Integer>>(){

            @Override
            public int compare(Map.Entry<Color, Integer> lhs, Map.Entry<Color, Integer> rhs) {
                return lhs.getValue() - rhs.getValue();
            }
        });
        return this.project(colorList);
    }

    private void initPanel(ZyGraph graph) {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(new TitledBorder("Edit Color Condition"));
        JPanel selectedColorPanel = new JPanel(new BorderLayout());
        selectedColorPanel.setBorder(new EmptyBorder(0, 5, 3, 5));
        selectedColorPanel.add(this.m_selectedColorPanel);
        List<Color> colors2 = this.getColors(graph);
        JPanel colorGrid = new JPanel(new GridLayout(1 + colors2.size() / 4, 4));
        colorGrid.setBorder(new TitledBorder(""));
        for (Color color : colors2) {
            JPanel outerColorPanel = new JPanel(new BorderLayout());
            outerColorPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
            ColorPanel colorPanel = new ColorPanel(color, false);
            outerColorPanel.add((Component)colorPanel, "Center");
            this.m_colorPanels.add(colorPanel);
            colorPanel.addListener(this.m_colorPanelListener);
            colorPanel.addMouseListener(this.m_colorPanelListener);
            colorGrid.add((Component)outerColorPanel, "North");
        }
        this.m_selectedColorPanel.setColor(colors2.isEmpty() ? new Color(255, 255, 255) : colors2.get(0));
        mainPanel.add((Component)selectedColorPanel, "North");
        JPanel gridContainer = new JPanel(new BorderLayout());
        gridContainer.add((Component)colorGrid, "North");
        gridContainer.setBorder(new EmptyBorder(3, 5, 0, 5));
        mainPanel.add((Component)gridContainer, "Center");
        this.add((Component)mainPanel, "Center");
    }

    private List<Color> project(List<Map.Entry<Color, Integer>> colorList) {
        ArrayList<Color> colors2 = new ArrayList<Color>();
        for (Map.Entry<Color, Integer> entry : colorList) {
            colors2.add(entry.getKey());
        }
        return colors2;
    }

    public void delete() {
        this.m_selectedColorPanel.removeListener(this.m_colorPanelListener);
        this.m_selectedColorPanel.removeMouseListener(this.m_colorPanelListener);
        for (ColorPanel cp2 : this.m_colorPanels) {
            cp2.removeListener(this.m_colorPanelListener);
            cp2.removeMouseListener(this.m_colorPanelListener);
        }
    }

    public Color getColor() {
        return this.m_selectedColorPanel.getColor();
    }

    private class InternalColorPanelListener
    extends MouseAdapter
    implements IColorPanelListener {
        private InternalColorPanelListener() {
        }

        @Override
        public void changedColor(ColorPanel panel) {
            CColorCriteriumPanel.this.m_colorCriterium.notifyListeners();
        }

        @Override
        public void mousePressed(MouseEvent event) {
            ColorPanel panel;
            Color color;
            if (event.getButton() == 1 && (color = (panel = (ColorPanel)event.getSource()).getColor()) != null) {
                CColorCriteriumPanel.this.m_selectedColorPanel.setColor(color);
            }
        }
    }
}

