/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions;

import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.And.IAbstractAndCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Not.IAbstractNotCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Or.IAbstractOrCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Root.IAbstractRootCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.IAbstractCriteriumTree;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.IAbstractCriteriumTreeNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.GraphHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.util.List;

public final class CCriteriumExecuter {
    private CCriteriumExecuter() {
    }

    public static void execute(IAbstractCriteriumTree tree, ZyGraph graph) {
        List<NaviNode> nodes = GraphHelpers.filter(graph, new CriteriumFilter(tree));
        List<NaviNode> allNodes = GraphHelpers.getNodes(graph);
        graph.selectNodes(allNodes, false);
        graph.selectNodes(nodes, true);
    }

    private static class CriteriumFilter
    implements ICollectionFilter<NaviNode> {
        private final IAbstractCriteriumTree m_tree;

        public CriteriumFilter(IAbstractCriteriumTree tree) {
            this.m_tree = tree;
        }

        private boolean qualifies(IAbstractCriteriumTreeNode node, NaviNode naviNode) {
            if (node.getCriterium() instanceof IAbstractRootCriterium) {
                return this.qualifiesRootNode(node, naviNode);
            }
            if (node.getCriterium() instanceof IAbstractAndCriterium) {
                return this.qualifiesAndNode(node, naviNode);
            }
            if (node.getCriterium() instanceof IAbstractOrCriterium) {
                return this.qualifiesOrNode(node, naviNode);
            }
            if (node.getCriterium() instanceof IAbstractNotCriterium) {
                return this.qualifiesNotNode(node, naviNode);
            }
            return node.getCriterium().matches(naviNode);
        }

        private boolean qualifiesAndNode(IAbstractCriteriumTreeNode node, NaviNode naviNode) {
            List<? extends IAbstractCriteriumTreeNode> children = node.getChildren();
            if (children.size() < 2) {
                throw new IllegalStateException("IE01120: AND operator has less than two child criteria.");
            }
            for (IAbstractCriteriumTreeNode iAbstractCriteriumTreeNode : node.getChildren()) {
                if (this.qualifies(iAbstractCriteriumTreeNode, naviNode)) continue;
                return false;
            }
            return true;
        }

        private boolean qualifiesNotNode(IAbstractCriteriumTreeNode node, NaviNode naviNode) {
            List<? extends IAbstractCriteriumTreeNode> children = node.getChildren();
            if (children.size() != 1) {
                throw new IllegalStateException("IE01142: NOT operator has more or less than one child criterium.");
            }
            return !this.qualifies(children.get(0), naviNode);
        }

        private boolean qualifiesOrNode(IAbstractCriteriumTreeNode node, NaviNode naviNode) {
            List<? extends IAbstractCriteriumTreeNode> children = node.getChildren();
            if (children.size() < 2) {
                throw new IllegalStateException("IE01141: OR operator has less than two child criteria.");
            }
            for (IAbstractCriteriumTreeNode iAbstractCriteriumTreeNode : node.getChildren()) {
                if (!this.qualifies(iAbstractCriteriumTreeNode, naviNode)) continue;
                return true;
            }
            return false;
        }

        private boolean qualifiesRootNode(IAbstractCriteriumTreeNode node, NaviNode naviNode) {
            List<? extends IAbstractCriteriumTreeNode> children = node.getChildren();
            if (children.isEmpty()) {
                throw new IllegalStateException("IE00469: Root node no child criterion.");
            }
            if (children.size() > 1) {
                throw new IllegalStateException("IE01112: Root node has more than one child criterion.");
            }
            return this.qualifies(children.get(0), naviNode);
        }

        @Override
        public boolean qualifies(NaviNode item) {
            return this.qualifies(this.m_tree.getRoot(), item);
        }
    }
}

