/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog;

import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.CAbstractOperatorPanel;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.CConditionCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Not.CNotCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCriteriumTree;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.ICriteriumTreeListener;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.ICriteriumTreeNode;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.CExpressionTreeValidator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.JCriteriumTree;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.JCriteriumTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class CDialogUpdater {
    private static final Color INVALID_OPERATOR_COLOR = new Color(160, 0, 0);
    private static final Color VALID_OPERATOR_COLOR = new Color(0, 0, 0);
    private final JCriteriumTree m_jtree;
    private final CCriteriumTree m_ctree;
    private final JPanel m_defineConditionPanel;
    private final JButton m_addConditionButton;
    private final JButton m_executeButton;
    private final InternalTreeSelectionListener m_treeSelectionListener = new InternalTreeSelectionListener();
    private final InternalCriteriumTreeListener m_treeCriteriumlListener = new InternalCriteriumTreeListener();

    public CDialogUpdater(JCriteriumTree jtree, CCriteriumTree ctree, JPanel conditionPanel, JButton conditionButton, JButton executeButton) {
        this.m_jtree = jtree;
        this.m_ctree = ctree;
        this.m_defineConditionPanel = conditionPanel;
        this.m_addConditionButton = conditionButton;
        this.m_executeButton = executeButton;
        this.m_jtree.addTreeSelectionListener(this.m_treeSelectionListener);
        this.m_ctree.addListener(this.m_treeCriteriumlListener);
    }

    private void updateDefineConditionPanel(JCriteriumTreeNode node) {
        JPanel component = node.getCriterium().getCriteriumPanel();
        this.m_defineConditionPanel.removeAll();
        this.m_defineConditionPanel.setBorder(null);
        if (component == null) {
            JPanel defaultPanel = new JPanel(new BorderLayout());
            defaultPanel.setBorder(new TitledBorder("Define Condition"));
            this.m_defineConditionPanel.add((Component)defaultPanel, "Center");
        } else {
            this.m_defineConditionPanel.add(component);
        }
        this.m_defineConditionPanel.updateUI();
    }

    public void dispose() {
        this.m_jtree.removeTreeSelectionListener(this.m_treeSelectionListener);
        this.m_ctree.removeListener(this.m_treeCriteriumlListener);
    }

    private class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private InternalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            TreePath path = event.getPath();
            if (path == null) {
                CDialogUpdater.this.m_addConditionButton.setEnabled(false);
                CDialogUpdater.this.updateDefineConditionPanel((JCriteriumTreeNode)CDialogUpdater.this.m_jtree.getModel().getRoot());
            } else {
                JCriteriumTreeNode parentNode;
                JCriteriumTreeNode selectedNode = (JCriteriumTreeNode)path.getLastPathComponent();
                boolean enable = selectedNode.allowAppend(CConditionCriterium.class);
                if (!(enable || selectedNode.getLevel() <= 0 || (parentNode = (JCriteriumTreeNode)selectedNode.getParent()).getLevel() == 0 || parentNode.getCriterium() instanceof CNotCriterium || selectedNode.getCriterium() instanceof CNotCriterium)) {
                    enable = true;
                }
                CDialogUpdater.this.m_addConditionButton.setEnabled(enable);
                CDialogUpdater.this.updateDefineConditionPanel(selectedNode);
            }
        }
    }

    private class InternalCriteriumTreeListener
    implements ICriteriumTreeListener {
        private InternalCriteriumTreeListener() {
        }

        private void update() {
            this.updateInfoField();
            CDialogUpdater.this.m_executeButton.setEnabled(CExpressionTreeValidator.isValid(CDialogUpdater.this.m_jtree));
        }

        private void updateCurrentCriteriumPath() {
            if (CDialogUpdater.this.m_jtree.getSelectionPath() == null) {
                CDialogUpdater.this.m_jtree.setCurrentCriteriumPath(CDialogUpdater.this.m_jtree.getPathForRow(0));
            } else {
                CDialogUpdater.this.m_jtree.setCurrentCriteriumPath(CDialogUpdater.this.m_jtree.getSelectionPath());
            }
            CDialogUpdater.this.updateDefineConditionPanel((JCriteriumTreeNode)CDialogUpdater.this.m_jtree.getCurrentCriteriumPath().getLastPathComponent());
        }

        private void updateInfoField() {
            Enumeration<TreeNode> nodes = ((JCriteriumTreeNode)CDialogUpdater.this.m_jtree.getModel().getRoot()).breadthFirstEnumeration();
            while (nodes.hasMoreElements()) {
                JCriteriumTreeNode node = (JCriteriumTreeNode)nodes.nextElement();
                JPanel panel = node.getCriterium().getCriteriumPanel();
                if (panel instanceof CAbstractOperatorPanel) {
                    int count = node.getChildCount();
                    ICriterium criterium = node.getCriterium();
                    JTextArea infoField = ((CAbstractOperatorPanel)panel).getInfoField();
                    if (count == 1 && (criterium instanceof CNotCriterium || node.getLevel() == 0) || count > 1 && !(criterium instanceof CNotCriterium)) {
                        infoField.setForeground(VALID_OPERATOR_COLOR);
                        infoField.setText(((CAbstractOperatorPanel)panel).getValidInfoString());
                    } else {
                        infoField.setForeground(INVALID_OPERATOR_COLOR);
                        infoField.setText(((CAbstractOperatorPanel)panel).getInvalidInfoString());
                    }
                }
                panel.updateUI();
            }
        }

        @Override
        public void appendedNode(CCriteriumTree criteriumTree, ICriteriumTreeNode parent, ICriteriumTreeNode child) {
            this.update();
        }

        @Override
        public void insertedNode(CCriteriumTree criteriumTree, ICriteriumTreeNode parent, ICriteriumTreeNode child) {
            this.update();
        }

        @Override
        public void removedAll(CCriteriumTree criteriumTree) {
            this.updateCurrentCriteriumPath();
            this.update();
        }

        @Override
        public void removedNode(CCriteriumTree criteriumTree, ICriteriumTreeNode node) {
            this.updateCurrentCriteriumPath();
            this.update();
        }
    }
}

