/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.plugins.ICriteriaSelectionPlugin;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.CConditionCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICachedCriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriterium;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.InDegrees.CIndegreeCriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.NodeColor.CColorCriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.OutDegree.COutdegreeCriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Selection.CSelectionCriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Tag.CTagCriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Text.CTextCriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.Visibillity.CVisibilityCriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCachedExpressionTreeNode;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.api2.IPluginInterface;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.binnavi.yfileswrap.API.disassembly.View2D;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;

public final class CCriteriaFactory {
    private final ZyGraph m_graph;
    private final View2D m_view2D;
    private final ITagManager m_tagManager;

    public CCriteriaFactory(ZyGraph graph, View2D view2D, ITagManager tagManager) {
        this.m_graph = Preconditions.checkNotNull(graph, "IE01316: Graph argument can not be null");
        this.m_view2D = view2D;
        this.m_tagManager = tagManager;
    }

    public List<ICriteriumCreator> getConditions() {
        ArrayList<ICriteriumCreator> conditions = new ArrayList<ICriteriumCreator>();
        conditions.add(new CTextCriteriumCreator());
        conditions.add(new CTagCriteriumCreator(this.m_tagManager));
        conditions.add(new CColorCriteriumCreator(this.m_graph));
        conditions.add(new CIndegreeCriteriumCreator());
        conditions.add(new COutdegreeCriteriumCreator());
        conditions.add(new CVisibilityCriteriumCreator());
        conditions.add(new CSelectionCriteriumCreator());
        for (IPlugin<IPluginInterface> plugin : PluginInterface.instance().getPluginRegistry()) {
            if (!(plugin instanceof ICriteriaSelectionPlugin)) continue;
            ICriteriaSelectionPlugin cplugin = (ICriteriaSelectionPlugin)plugin;
            conditions.add(new CPluginCriteriumCreator(this.m_view2D, cplugin));
        }
        return conditions;
    }

    private static class CPluginCriteriumCreator
    implements ICriteriumCreator {
        private final View2D m_view2D;
        private final ICriteriaSelectionPlugin m_plugin;

        public CPluginCriteriumCreator(View2D view2D, ICriteriaSelectionPlugin plugin) {
            this.m_view2D = view2D;
            this.m_plugin = plugin;
        }

        @Override
        public ICriterium createCriterium() {
            try {
                return new CPluginCriterium(this.m_view2D, this.m_plugin.getCriterium(this.m_view2D));
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
                return null;
            }
        }

        @Override
        public String getCriteriumDescription() {
            return this.m_plugin.getCriteriumDescription();
        }
    }

    private static class CPluginCriterium
    extends CConditionCriterium {
        private final View2D m_view2D;
        private final ICriteriaSelectionPlugin.ICriterium m_plugin;

        public CPluginCriterium(View2D view2D, ICriteriaSelectionPlugin.ICriterium plugin) {
            this.m_view2D = view2D;
            this.m_plugin = plugin;
        }

        @Override
        public ICachedCriterium createCachedCriterium() {
            return new CPluginCachedCriterium(this.m_view2D, this.m_plugin);
        }

        @Override
        public String getCriteriumDescription() {
            try {
                return this.m_plugin.getCriteriumDescription();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
                return "???";
            }
        }

        @Override
        public JPanel getCriteriumPanel() {
            try {
                return this.m_plugin.getCriteriumPanel();
            }
            catch (Exception exception) {
                return new JPanel();
            }
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public boolean matches(NaviNode node) {
            return this.m_plugin.matches(this.m_view2D.getNode(node.getRawNode()));
        }
    }

    private static class CPluginCachedCriterium
    implements ICachedCriterium {
        private final View2D m_view2D;
        private final ICriteriaSelectionPlugin.ICriterium m_plugin;
        private final ICriteriaSelectionPlugin.IFixedCriterium m_value;

        public CPluginCachedCriterium(View2D view2D, ICriteriaSelectionPlugin.ICriterium plugin) {
            this.m_view2D = view2D;
            this.m_plugin = plugin;
            this.m_value = plugin.getFixedCriterium();
        }

        @Override
        public String getFormulaString(List<CCachedExpressionTreeNode> children) {
            try {
                return this.m_plugin.getFormulaString();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
                return "???";
            }
        }

        @Override
        public boolean matches(NaviNode node) {
            try {
                return this.m_value.matches(this.m_view2D.getNode(node.getRawNode()));
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
                return false;
            }
        }
    }
}

