/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CriteriaDialog;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.CAddConditionButtonListener;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.CConditionBox;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.CCriteriaFactory;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.CDialogUpdater;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.Conditions.ICriteriumCreator;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionModel.CCriteriumTree;
import com.google.security.zynamics.binnavi.Gui.CriteriaDialog.ExpressionTree.JCriteriumTree;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public final class CCriteriaDialog
extends JDialog {
    private static final long serialVersionUID = 3407098516337379404L;
    private final CCriteriumTree m_ctree = new CCriteriumTree();
    private final CDialogUpdater m_updater;
    private boolean m_closedByOk;
    private final JCriteriumTree m_jtree;

    public CCriteriaDialog(JFrame owner, CCriteriaFactory conditionFactory) {
        super(owner, "Select by Criteria", true);
        Preconditions.checkNotNull(conditionFactory, "IE01315: Condition factory argument can not be null");
        List<ICriteriumCreator> criteria = conditionFactory.getConditions();
        this.m_jtree = new JCriteriumTree(this.m_ctree, criteria);
        CConditionBox selectionBox = new CConditionBox(criteria);
        CAddConditionButtonListener addConditionButtonListner = new CAddConditionButtonListener(this.m_jtree, this.m_ctree, selectionBox);
        JButton addConditionButton = new JButton(addConditionButtonListner);
        CPanelTwoButtons okCancelPanel = new CPanelTwoButtons(new InternalOkCancelButttonListener(), "Execute", "Cancel");
        JPanel defineConditionPanel = new JPanel(new BorderLayout());
        this.initDialog(this.m_jtree, selectionBox, defineConditionPanel, okCancelPanel, addConditionButton);
        GuiHelper.centerChildToParent(owner, this, true);
        this.m_updater = new CDialogUpdater(this.m_jtree, this.m_ctree, defineConditionPanel, addConditionButton, okCancelPanel.getFirstButton());
    }

    private void initDialog(JCriteriumTree jtree, CConditionBox selectionBox, JPanel defineConditionPanel, CPanelTwoButtons okCancelPanel, JButton addConditionButton) {
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel deviderBorderPanel = new JPanel(new BorderLayout());
        deviderBorderPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        JPanel deviderPanel = new JPanel(new GridLayout(1, 2));
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setBorder(new TitledBorder("Expression Tree"));
        JPanel rightPanel = new JPanel(new BorderLayout());
        JPanel rightTopPanel = new JPanel(new BorderLayout());
        rightTopPanel.setBorder(new TitledBorder("Create Condition"));
        JPanel rightTopComboPanel = new JPanel(new BorderLayout());
        rightTopComboPanel.setBorder(new EmptyBorder(1, 5, 5, 5));
        JPanel rightTopAddPanel = new JPanel(new BorderLayout());
        rightTopAddPanel.setBorder(new EmptyBorder(1, 0, 5, 5));
        mainPanel.add((Component)deviderBorderPanel, "Center");
        mainPanel.add((Component)okCancelPanel, "South");
        okCancelPanel.getFirstButton().setEnabled(jtree.getSelectionPath() != null);
        deviderBorderPanel.add((Component)deviderPanel, "Center");
        deviderPanel.add(leftPanel);
        deviderPanel.add(rightPanel);
        JScrollPane pane = new JScrollPane(jtree);
        pane.setVerticalScrollBarPolicy(20);
        pane.setHorizontalScrollBarPolicy(30);
        leftPanel.add((Component)pane, "Center");
        defineConditionPanel.setBorder(new TitledBorder("Define Condition"));
        rightPanel.add((Component)rightTopPanel, "North");
        rightPanel.add((Component)defineConditionPanel, "Center");
        rightTopPanel.add((Component)rightTopComboPanel, "Center");
        rightTopPanel.add((Component)rightTopAddPanel, "East");
        rightTopComboPanel.add((Component)selectionBox, "Center");
        addConditionButton.setText("Add");
        addConditionButton.setEnabled(false);
        rightTopAddPanel.add((Component)addConditionButton, "Center");
        this.add(mainPanel);
        this.setIconImage(null);
        this.pack();
    }

    public void delete() {
        this.m_jtree.delete();
        this.m_updater.dispose();
    }

    public CCriteriumTree getCriteriumTree() {
        return this.m_ctree;
    }

    public boolean isClosedOk() {
        return this.m_closedByOk;
    }

    private class InternalOkCancelButttonListener
    implements ActionListener {
        private InternalOkCancelButttonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CCriteriaDialog.this.m_closedByOk = event.getActionCommand().equals("Execute");
            CCriteriaDialog.this.dispose();
        }
    }
}

