/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CodeBookmarks;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.CodeBookmarks.Actions.CDeleteBookmarkAction;
import com.google.security.zynamics.binnavi.Gui.CodeBookmarks.CCodeBookmarkTableModel;
import com.google.security.zynamics.binnavi.models.Bookmarks.code.CCodeBookmarkManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

public final class CCodeBookmarkTable
extends JTable {
    private static final long serialVersionUID = -3705762683090007816L;
    private final CCodeBookmarkTableModel m_model;
    private final CCodeBookmarkManager m_bookmarkManager;

    public CCodeBookmarkTable(CCodeBookmarkManager bookmarkManager) {
        this.m_bookmarkManager = Preconditions.checkNotNull(bookmarkManager, "IE01310: Bookmark Manager can't be null");
        this.m_model = new CCodeBookmarkTableModel(bookmarkManager);
        this.setModel(this.m_model);
        this.getSelectionModel().setSelectionMode(2);
        this.addMouseListener(new InternalMouseListener());
    }

    private void showPopup(MouseEvent event) {
        int[] rows = this.getSelectedRows();
        if (rows.length == 0 || rows.length == 1) {
            int row = this.rowAtPoint(event.getPoint());
            int column = this.columnAtPoint(event.getPoint());
            if (row == -1 || column == -1) {
                return;
            }
            this.changeSelection(row, column, false, false);
            rows = this.getSelectedRows();
        }
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(CActionProxy.proxy(new CDeleteBookmarkAction(this.m_bookmarkManager, rows))));
        menu.show(event.getComponent(), event.getX(), event.getY());
    }

    public void dispose() {
        this.m_model.dispose();
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CCodeBookmarkTable.this.showPopup(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CCodeBookmarkTable.this.showPopup(event);
            }
        }
    }
}

