/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.CodeBookmarks;

import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.CodeBookmarks.Actions.CAddBookmarkAction;
import com.google.security.zynamics.binnavi.Gui.CodeBookmarks.CCodeBookmarkTable;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.CAbstractResultsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Extensions.CCodeNodeExtensionAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Extensions.IGraphPanelExtension;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanelExtender;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.ZyZoomHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.models.Bookmarks.code.CCodeBookmarkManager;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class CCodeBookmarkPanel
extends CAbstractResultsPanel
implements IGraphPanelExtension {
    private final CCodeBookmarkManager m_bookmarkManager = new CCodeBookmarkManager();
    private final CCodeBookmarkTable m_bookmarkTable = new CCodeBookmarkTable(this.m_bookmarkManager);

    public CCodeBookmarkPanel() {
        super(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_bookmarkTable), "Center");
    }

    @Override
    public void dispose() {
        this.m_bookmarkTable.dispose();
    }

    @Override
    public String getTitle() {
        return "Code Bookmarks";
    }

    @Override
    public void visit(CGraphModel model, IGraphPanelExtender extender) {
        extender.registerCodeNodeExtension(new CodeNodeExtension());
        extender.addTab("Code Bookmarks", this);
        this.m_bookmarkTable.getSelectionModel().addListSelectionListener(new InternalSelectionListener(this.m_bookmarkTable, model.getGraph()));
    }

    private class InternalSelectionListener
    implements ListSelectionListener {
        private final ZyGraph m_graph;
        private final JTable m_table;

        private InternalSelectionListener(JTable table, ZyGraph graph) {
            this.m_table = table;
            this.m_graph = graph;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (!event.getValueIsAdjusting() && this.m_table.getSelectedRow() != -1) {
                ZyZoomHelpers.zoomToAddress(this.m_graph, CCodeBookmarkPanel.this.m_bookmarkManager.get(this.m_table.getSelectedRow()).getAddress(), CCodeBookmarkPanel.this.m_bookmarkManager.get(this.m_table.getSelectedRow()).getModule(), true);
            }
        }
    }

    private class CodeNodeExtension
    extends CCodeNodeExtensionAdapter {
        private CodeNodeExtension() {
        }

        @Override
        public void extendInstruction(JMenu menu, INaviCodeNode node, INaviInstruction instruction) {
            if (!CCodeBookmarkPanel.this.m_bookmarkManager.hasBookmark(instruction.getModule(), instruction.getAddress())) {
                menu.add(CActionProxy.proxy(new CAddBookmarkAction(CCodeBookmarkPanel.this.m_bookmarkManager, instruction.getModule(), instruction.getAddress())));
            }
        }
    }
}

