/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Actions;

import com.google.security.zynamics.binnavi.Gui.Tutorials.CTutorialDialog;
import com.google.security.zynamics.binnavi.Tutorials.CTutorial;
import com.google.security.zynamics.zylib.reflection.ReflectionHelpers;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.Action;

public final class CActionProxy
implements InvocationHandler {
    private final Action m_action;

    private CActionProxy(Action action) {
        this.m_action = action;
    }

    private static boolean isExecuteMethod(Method method) {
        return method.getName().contains("actionPerformed");
    }

    public static Action proxy(Action action) {
        return (Action)Proxy.newProxyInstance(action.getClass().getClassLoader(), new Class[]{Action.class}, (InvocationHandler)new CActionProxy(action));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (GraphicsEnvironment.isHeadless() || !CActionProxy.isExecuteMethod(method)) {
            return method.invoke((Object)this.m_action, args);
        }
        CTutorial currentTutorial = CTutorialDialog.instance().getCurrentTutorial();
        if (currentTutorial == null) {
            return method.invoke((Object)this.m_action, args);
        }
        long actionId = (Long)ReflectionHelpers.getStaticField(this.m_action.getClass(), "serialVersionUID");
        if (currentTutorial.getCurrentStep().handles(actionId)) {
            Object result = method.invoke((Object)this.m_action, args);
            if (currentTutorial.getCurrentStep().mandates(actionId)) {
                currentTutorial.next();
            }
            return result;
        }
        CTutorialDialog.instance().wrongAction(actionId);
        return null;
    }
}

