/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.CGenericSQLUserFunctions;
import com.google.security.zynamics.binnavi.Database.DatabaseVersion;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntInitializeDatabaseException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntUpdateDatabaseException;
import com.google.security.zynamics.binnavi.Database.Exceptions.InvalidDatabaseException;
import com.google.security.zynamics.binnavi.Database.Interfaces.ModuleConverter;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProviderListener;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Creators.PostgreSQLProjectCreator;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Creators.PostgreSQLViewCreator;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLDataFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLDatabaseFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLEdgeFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLFunctionFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLInstructionFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLModuleFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLNodeFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLProjectFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLRawModuleFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLSectionFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLTagFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLTagManagerFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLTraceFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLTypeFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLFunctionsLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLModuleConverter;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Savers.PostgreSQLViewSaver;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.Interfaces.IUser;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.TagType;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleInitializeReporter;
import com.google.security.zynamics.binnavi.disassembly.types.RawBaseType;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeInstanceReference;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeMember;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeSubstitution;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class PostgreSQLProvider
extends AbstractSQLProvider {
    protected final PostgreSQLModuleConverter moduleConverter;
    private final ListenerProvider<SQLProviderListener> listeners = new ListenerProvider();

    public PostgreSQLProvider(CConnection connection) {
        super(connection);
        Preconditions.checkNotNull(connection, "IE01210: Database connection can't be null");
        this.moduleConverter = new PostgreSQLModuleConverter(this);
    }

    private boolean hasColumn(String tableName, String columnname) throws CouldntLoadDataException {
        return PostgreSQLHelpers.hasColumn(this.getConnection(), tableName, columnname);
    }

    @Override
    protected ModuleConverter getModuleConverter() {
        return this.moduleConverter;
    }

    @Override
    protected String getTablesFile() {
        return "postgresql_tables.sql";
    }

    protected int hasAllTables(List<String> tableNames) throws CouldntLoadDataException {
        return PostgreSQLHelpers.getTableCount(this.getConnection(), tableNames);
    }

    @Override
    protected boolean hasTable(String tableName) throws CouldntLoadDataException {
        return PostgreSQLHelpers.hasTable(this.getConnection(), tableName);
    }

    @Override
    public IUser addUser(String userName) throws CouldntSaveDataException {
        return CGenericSQLUserFunctions.addUser(this, userName);
    }

    @Override
    public Integer appendFunctionComment(INaviFunction function, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLFunctionFunctions.appendGlobalFunctionComment(this, function, commentText, userId);
    }

    @Override
    public Integer appendGroupNodeComment(INaviGroupNode groupNode, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLNodeFunctions.appendGroupNodeComment(this, groupNode, commentText, userId);
    }

    @Override
    public Integer appendTextNodeComment(INaviTextNode textNode, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLNodeFunctions.appendTextNodeComment(this, textNode, commentText, userId);
    }

    @Override
    public Integer appendTypeInstanceComment(int moduleId, int instanceId, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLTypeFunctions.appendTypeInstanceComment(this, moduleId, instanceId, commentText, userId);
    }

    @Override
    public Integer appendSectionComment(int moduleId, int sectionId, String commentText, Integer userId) throws CouldntSaveDataException {
        return PostgreSQLSectionFunctions.appendSectionComment(this, moduleId, sectionId, commentText, userId);
    }

    @Override
    public CAddressSpace createAddressSpace(INaviProject project, String name) throws CouldntSaveDataException {
        return PostgreSQLProjectFunctions.createAddressSpace(this, project, name);
    }

    @Override
    public CModule createModule(INaviRawModule rawModule) throws CouldntLoadDataException, CouldntSaveDataException {
        CModule newModule = this.getModuleConverter().createModule(this, rawModule);
        this.getModules().add(newModule);
        return newModule;
    }

    @Override
    public void createModulesTable() throws SQLException {
        this.executeUpdate("CREATE TABLE modules ( id serial,  name text NOT NULL,  architecture varchar( 32 ) NOT NULL,  base_address bigint NOT NULL,  exporter varchar( 256 ) NOT NULL,  version int NOT NULL,  md5 char( 32 ) NOT NULL,  sha1 char( 40 ) NOT NULL,  comment TEXT,  import_time timestamp NOT NULL DEFAULT current_timestamp,  PRIMARY KEY (id));");
    }

    @Override
    public CProject createProject(String name) throws CouldntSaveDataException {
        CProject project = PostgreSQLProjectCreator.createProject(this, name);
        this.projects.add(project);
        return project;
    }

    @Override
    public CTag createTag(CTag parent, String name, String description, TagType type) throws CouldntSaveDataException {
        return PostgreSQLTagFunctions.createTag(this, parent, name, description, type);
    }

    @Override
    public TraceList createTrace(INaviModule module, String name, String description) throws CouldntSaveDataException {
        return PostgreSQLTraceFunctions.createTrace((AbstractSQLProvider)this, module, name, description);
    }

    @Override
    public TraceList createTrace(INaviProject project, String name, String description) throws CouldntSaveDataException {
        return PostgreSQLTraceFunctions.createTrace((AbstractSQLProvider)this, project, name, description);
    }

    @Override
    public CView createView(INaviModule module, INaviView view, String name, String description) throws CouldntSaveDataException {
        return PostgreSQLViewCreator.createView((AbstractSQLProvider)this, module, view, name, description);
    }

    @Override
    public CView createView(INaviProject project, INaviView view, String name, String description) throws CouldntSaveDataException {
        return PostgreSQLViewCreator.createView((AbstractSQLProvider)this, project, view, name, description);
    }

    @Override
    public void deleteFunctionComment(INaviFunction function, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLFunctionFunctions.deleteGlobalFunctionComment(this, function, commentId, userId);
    }

    @Override
    public void deleteFunctionNodeComment(INaviFunctionNode functionNode, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLNodeFunctions.deleteLocalFunctionNodeComment(this, functionNode, commentId, userId);
    }

    @Override
    public void deleteGlobalCodeNodeComment(INaviCodeNode codeNode, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLNodeFunctions.deleteGlobalCodeNodeComment(this, codeNode, commentId, userId);
    }

    @Override
    public void deleteGlobalEdgeComment(INaviEdge edge, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLEdgeFunctions.deleteGlobalEdgeComment(this, edge, commentId, userId);
    }

    @Override
    public void deleteGlobalInstructionComment(INaviInstruction instruction, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLInstructionFunctions.deleteGlobalInstructionComment(this, instruction, commentId, userId);
    }

    @Override
    public void deleteGroupNodeComment(INaviGroupNode groupNode, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLNodeFunctions.deleteGroupNodeComment(this, groupNode, commentId, userId);
    }

    @Override
    public void deleteLocalCodeNodeComment(INaviCodeNode codeNode, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLNodeFunctions.deleteLocalCodeNodeComment(this, codeNode, commentId, userId);
    }

    @Override
    public void deleteLocalEdgeComment(INaviEdge edge, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLEdgeFunctions.deleteLocalEdgeComment(this, edge, commentId, userId);
    }

    @Override
    public void deleteLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLInstructionFunctions.deleteLocalInstructionComment(this, codeNode, instruction, commentId, userId);
    }

    @Override
    public void deleteTypeInstanceComment(int moduleId, int instanceId, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLTypeFunctions.deleteTypeInstanceComment(this, moduleId, instanceId, commentId, userId);
    }

    @Override
    public void deleteSectionComment(int moduleId, int sectionId, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLSectionFunctions.deleteSectionComment(this, moduleId, sectionId, commentId, userId);
    }

    @Override
    public void deleteModule(INaviModule module) throws CouldntDeleteException {
        PostgreSQLModuleFunctions.deleteModule(this, module);
        PostgreSQLRawModuleFunctions.deleteRawModule(this, module.getConfiguration().getRawModule());
    }

    @Override
    public void deleteTextNodeComment(INaviTextNode textNode, Integer commentId, Integer userId) throws CouldntDeleteException {
        PostgreSQLNodeFunctions.deleteTextNodeComment(this, textNode, commentId, userId);
    }

    @Override
    public void deleteUser(IUser user2) throws CouldntDeleteException {
        CGenericSQLUserFunctions.deleteUser(this, user2);
    }

    @Override
    public void editTypeInstanceComment(int moduleId, Integer commentId, Integer userId, String commentText) throws CouldntSaveDataException {
        PostgreSQLTypeFunctions.editTypeInstanceComment(this, moduleId, commentId, userId, commentText);
    }

    @Override
    public void editSectionComment(int moduleId, int sectionId, Integer commentId, Integer userId, String commentText) throws CouldntSaveDataException {
        PostgreSQLSectionFunctions.editSectionComment(this, moduleId, commentId, userId, commentText);
    }

    @Override
    public void editFunctionComment(INaviFunction function, Integer commentId, Integer userId, String newCommentText) throws CouldntSaveDataException {
        PostgreSQLFunctionFunctions.editGlobalFunctionComment(this, function, commentId, userId, newCommentText);
    }

    @Override
    public void editFunctionNodeComment(INaviFunctionNode functionNode, Integer commentId, Integer userId, String newCommentText) throws CouldntSaveDataException {
        PostgreSQLNodeFunctions.editLocalFunctionNodeComment(this, functionNode, commentId, userId, newCommentText);
    }

    @Override
    public void editGlobalCodeNodeComment(INaviCodeNode codeNode, Integer commentId, Integer userId, String newCommentText) throws CouldntSaveDataException {
        PostgreSQLNodeFunctions.editGlobalCodeNodeComment(this, codeNode, commentId, userId, newCommentText);
    }

    @Override
    public void editGlobalEdgeComment(INaviEdge edge, Integer commentId, Integer userId, String newCommentText) throws CouldntSaveDataException {
        PostgreSQLEdgeFunctions.editGlobalEdgeComment(this, edge, commentId, userId, newCommentText);
    }

    @Override
    public void editGlobalInstructionComment(INaviInstruction instruction, Integer commentId, Integer userId, String newCommentText) throws CouldntSaveDataException {
        PostgreSQLInstructionFunctions.editGlobalInstructionComment(this, commentId, userId, newCommentText);
    }

    @Override
    public void editGroupNodeComment(INaviGroupNode groupNode, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        PostgreSQLNodeFunctions.editGroupNodeComment(this, groupNode, commentId, userId, newComment);
    }

    @Override
    public void editLocalCodeNodeComment(INaviCodeNode codeNode, Integer commentId, Integer userId, String newCommentText) throws CouldntSaveDataException {
        PostgreSQLNodeFunctions.editLocalCodeNodeComment(this, codeNode, commentId, userId, newCommentText);
    }

    @Override
    public void editLocalEdgeComment(INaviEdge edge, Integer commentId, Integer userId, String newCommentText) throws CouldntSaveDataException {
        PostgreSQLEdgeFunctions.editLocalEdgeComment(this, edge, commentId, userId, newCommentText);
    }

    @Override
    public void editLocalInstructionComment(INaviCodeNode codeNode, INaviInstruction instruction, Integer commentId, Integer userId, String newCommentText) throws CouldntSaveDataException {
        PostgreSQLInstructionFunctions.editLocalInstructionComment(this, commentId, userId, newCommentText);
    }

    @Override
    public void editTextNodeComment(INaviTextNode textNode, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        PostgreSQLNodeFunctions.editTextNodeComment(this, textNode, commentId, userId, newComment);
    }

    @Override
    public IUser editUserName(IUser user2, String userName) throws CouldntSaveDataException {
        return CGenericSQLUserFunctions.editUserName(this, user2, userName);
    }

    @Override
    public DatabaseVersion getDatabaseVersion() throws CouldntLoadDataException {
        try {
            return PostgreSQLDatabaseFunctions.getDatabaseVersion(this.connection);
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    @Override
    public void initializeDatabase() throws CouldntInitializeDatabaseException, CouldntLoadDataException {
        try {
            this.createEmptyTables();
        }
        catch (IOException exception) {
            throw new CouldntInitializeDatabaseException(exception);
        }
    }

    @Override
    public void initializeModule(CModule module, CModuleInitializeReporter reporter) throws CouldntSaveDataException {
        this.getModuleConverter().initializeModule(this, module, reporter);
    }

    @Override
    public CTag insertTag(ITreeNode<CTag> parent, String name, String description, TagType type) throws CouldntSaveDataException {
        return PostgreSQLTagFunctions.insertTag(this, parent, name, description, type);
    }

    @Override
    public boolean isExporterDatabaseFormatValid() throws CouldntLoadDataException {
        return !this.hasTable("modules") || this.hasColumn("modules", "version");
    }

    @Override
    public boolean isInitialized() throws CouldntLoadDataException, InvalidDatabaseException {
        return this.hasAllTables();
    }

    @Override
    public ArrayList<IComment> loadCommentById(Integer commentId) throws CouldntLoadDataException {
        return PostgreSQLCommentFunctions.loadCommentByCommentId(this, commentId);
    }

    @Override
    public INaviFunction loadFunction(INaviModule module, IAddress functionAddress) throws CouldntLoadDataException {
        return PostgreSQLFunctionsLoader.loadFunction(this, module, functionAddress);
    }

    @Override
    public List<INaviModule> loadModules() throws CouldntLoadDataException {
        if (this.getDebuggerManager() == null) {
            throw new CouldntLoadDataException("Error: Debugger manager must be loaded first");
        }
        this.setModules(PostgreSQLDatabaseFunctions.loadModules(this, this.getRawModules(), this.getDebuggerManager()));
        return new ArrayList<INaviModule>(this.getModules());
    }

    @Override
    public HashMap<Integer, ArrayList<IComment>> loadMultipleCommentsById(Collection<Integer> commentIds) throws CouldntLoadDataException {
        return PostgreSQLCommentFunctions.loadMultipleCommentsById(this, commentIds);
    }

    @Override
    public List<INaviProject> loadProjects() throws CouldntLoadDataException {
        this.projects = PostgreSQLDatabaseFunctions.loadProjects(this, this.getDebuggerManager());
        return new ArrayList<INaviProject>(this.projects);
    }

    @Override
    public List<INaviRawModule> loadRawModules() throws CouldntLoadDataException {
        this.setRawModules(PostgreSQLDatabaseFunctions.loadRawModules(this));
        return this.getRawModules();
    }

    @Override
    public CTagManager loadTagManager(TagType type) throws CouldntLoadDataException {
        CTagManager manager = PostgreSQLTagManagerFunctions.loadTagManager(this, type);
        if (type == TagType.NODE_TAG) {
            this.nodeTagManager = manager;
        } else {
            this.setViewTagManager(manager);
        }
        return manager;
    }

    @Override
    public List<IUser> loadUsers() throws CouldntLoadDataException {
        return CGenericSQLUserFunctions.loadUsers(this);
    }

    @Override
    public void save(TraceList traces) throws CouldntSaveDataException {
        PostgreSQLTraceFunctions.save(this, traces);
    }

    @Override
    public void save(CView view) throws CouldntSaveDataException {
        PostgreSQLViewSaver.save(this, view);
    }

    @Override
    public void saveData(INaviModule module, byte[] data) throws CouldntSaveDataException {
        PostgreSQLDataFunctions.saveData(this, module, data);
    }

    @Override
    public void updateDatabase() throws CouldntUpdateDatabaseException {
        PostgreSQLDatabaseFunctions.updateDatabase(this);
    }

    @Override
    public void deleteSection(Section section) throws CouldntLoadDataException {
        PostgreSQLSectionFunctions.deleteSection(this, section);
    }

    @Override
    public void deleteTypeInstance(int moduleId, int typeInstanceId) throws CouldntDeleteException {
        PostgreSQLTypeFunctions.deleteTypeInstance(this, moduleId, typeInstanceId);
    }

    @Override
    public void deleteTypeInstanceReference(int moduleId, BigInteger address, int position, int expressionId) throws CouldntDeleteException {
        PostgreSQLTypeFunctions.deleteTypeInstanceReference(this, moduleId, address, position, expressionId);
    }

    @Override
    public void setTypeInstanceName(int moduleId, int id, String name) throws CouldntSaveDataException {
        PostgreSQLTypeFunctions.setTypeInstanceName(this, moduleId, id, name);
    }

    @Override
    public List<RawTypeInstanceReference> loadTypeInstanceReferences(INaviModule module) throws CouldntLoadDataException {
        return PostgreSQLTypeFunctions.loadRawTypeInstanceReferences(this.getConnection().getConnection(), module);
    }

    @Override
    public RawTypeInstance loadTypeInstance(INaviModule module, Integer typeInstanceId) throws CouldntLoadDataException {
        return PostgreSQLTypeFunctions.loadRawTypeInstance(this, module, typeInstanceId);
    }

    @Override
    public RawTypeInstanceReference loadTypeInstanceReference(INaviModule module, Integer typeInstanceId, BigInteger address, Integer position, Integer expressionId) throws CouldntLoadDataException {
        return PostgreSQLTypeFunctions.loadRawTypeInstanceReference(this, module, typeInstanceId, address, position, expressionId);
    }

    @Override
    public RawTypeMember loadTypeMember(INaviModule module, int typeMemberId) throws CouldntLoadDataException {
        return PostgreSQLTypeFunctions.loadRawTypeMember(this, module, typeMemberId);
    }

    @Override
    public RawBaseType loadType(INaviModule module, int baseTypeId) throws CouldntLoadDataException {
        return PostgreSQLTypeFunctions.loadRawBaseType(this, module, baseTypeId);
    }

    @Override
    public RawTypeSubstitution loadTypeSubstitution(INaviModule module, BigInteger address, int position, int expressionId) throws CouldntLoadDataException {
        return PostgreSQLTypeFunctions.loadRawTypeSubstitution(this, module, address, position, expressionId);
    }

    @Override
    public void close() {
        for (SQLProviderListener listener : this.listeners) {
            listener.providerClosing(this);
        }
        this.connection.closeConnection();
    }

    @Override
    public void addListener(SQLProviderListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeListener(SQLProviderListener listener) {
        this.listeners.removeListener(listener);
    }
}

