/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Savers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Savers.PostgreSQLEdgeSaver;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Savers.PostgreSQLNodeSaver;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.zylib.types.graphs.MutableDirectedGraph;
import java.sql.SQLException;
import java.util.List;

public final class PostgreSQLViewSaver {
    private PostgreSQLViewSaver() {
    }

    protected static void checkArguments(AbstractSQLProvider provider, CView view) {
        Preconditions.checkNotNull(provider, "IE01888: Provider argument can not be null");
        Preconditions.checkNotNull(view, "IE01940: View argument can not be null");
        Preconditions.checkArgument(view.inSameDatabase(provider), "IE02028: View is not part of this database");
    }

    protected static void deleteNodes(CConnection connection, int viewId) throws SQLException {
        String string2 = String.valueOf("DELETE FROM bn_nodes WHERE view_id = ");
        String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(viewId).toString();
        connection.executeUpdate(query, true);
    }

    public static void save(AbstractSQLProvider provider, CView view) throws CouldntSaveDataException {
        PostgreSQLViewSaver.checkArguments(provider, view);
        CConnection connection = provider.getConnection();
        try {
            PostgreSQLHelpers.beginTransaction(connection);
            int viewId = view.getConfiguration().getId();
            List<INaviViewNode> nodes = ((MutableDirectedGraph)view.getGraph()).getNodes();
            List<INaviEdge> edges = ((MutableDirectedGraph)view.getGraph()).getEdges();
            PostgreSQLViewSaver.deleteNodes(connection, viewId);
            PostgreSQLNodeSaver.writeNodes(provider, viewId, nodes);
            PostgreSQLEdgeSaver.writeEdges(provider, edges);
            PostgreSQLHelpers.endTransaction(connection);
        }
        catch (SQLException exception) {
            try {
                PostgreSQLHelpers.rollback(connection);
            }
            catch (SQLException e2) {
                CUtilityFunctions.logException(e2);
            }
            throw new CouldntSaveDataException(exception);
        }
    }
}

