/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Savers;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLInstructionFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLNodeFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.CComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CCodeNode;
import com.google.security.zynamics.binnavi.disassembly.CFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.CTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class PostgreSQLNodeSaver {
    private static String CODE = "code";
    private static String FUNCTION = "function";
    private static String GROUP = "group";
    private static String TEXT = "text";

    private PostgreSQLNodeSaver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int saveNodes(AbstractSQLProvider provider, int newViewId, List<INaviViewNode> nodes, List<Integer> functionNodeIndices, List<Integer> codeNodeIndices, List<Integer> textNodeIndices, List<Integer> groupNodeIndices, BiMap<Integer, INaviGroupNode> groupNodeMap) throws SQLException {
        String query = "INSERT INTO bn_nodes( view_id, parent_id, type, x, y, width, height, color, bordercolor,  selected, visible) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = provider.getConnection().getConnection().prepareStatement("INSERT INTO bn_nodes( view_id, parent_id, type, x, y, width, height, color, bordercolor,  selected, visible) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
        int counter = 0;
        for (INaviViewNode node : nodes) {
            String nodeType = null;
            if (node instanceof CCodeNode) {
                nodeType = CODE;
                codeNodeIndices.add(counter);
            } else if (node instanceof CFunctionNode) {
                nodeType = FUNCTION;
                functionNodeIndices.add(counter);
            } else if (node instanceof INaviGroupNode) {
                nodeType = GROUP;
                groupNodeIndices.add(counter);
                groupNodeMap.put(counter, (INaviGroupNode)node);
            } else if (node instanceof CTextNode) {
                nodeType = TEXT;
                textNodeIndices.add(counter);
            }
            ++counter;
            preparedStatement.setInt(1, newViewId);
            preparedStatement.setNull(2, 4);
            preparedStatement.setObject(3, (Object)nodeType, 1111);
            preparedStatement.setDouble(4, node.getX());
            preparedStatement.setDouble(5, node.getY());
            preparedStatement.setDouble(6, node.getWidth());
            preparedStatement.setDouble(7, node.getHeight());
            preparedStatement.setInt(8, node.getColor().getRGB());
            preparedStatement.setInt(9, node.getBorderColor().getRGB());
            preparedStatement.setBoolean(10, node.isSelected());
            preparedStatement.setBoolean(11, node.isVisible());
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        int lastId = 0;
        try {
            while (resultSet.next()) {
                if (!resultSet.isFirst()) continue;
                lastId = resultSet.getInt(1);
                break;
            }
        }
        finally {
            preparedStatement.close();
            resultSet.close();
        }
        return lastId;
    }

    protected static void checkArguments(AbstractSQLProvider provider, int newViewId, List<INaviViewNode> nodes) {
        Preconditions.checkNotNull(provider, "IE01992: Provider argument can not be null");
        Preconditions.checkArgument(newViewId > 0, "IE01993: New View ID argument must be greater then zero");
        Preconditions.checkNotNull(nodes, "IE01994: Nodes argument can not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ArrayList<Pair<INaviCodeNode, INaviInstruction>> saveCodeNodeInstructions(SQLProvider provider, List<INaviViewNode> nodes, int firstNode, List<Integer> codeNodeIndices) throws SQLException {
        if (!nodes.isEmpty()) {
            HashSet<INaviInstruction> unsavedInstructions = new HashSet<INaviInstruction>();
            for (int index : codeNodeIndices) {
                CCodeNode node = (CCodeNode)nodes.get(index);
                Iterable<INaviInstruction> instructions = node.getInstructions();
                for (INaviInstruction instruction : instructions) {
                    if (instruction.isStored()) continue;
                    unsavedInstructions.add(instruction);
                }
            }
            PostgreSQLInstructionFunctions.createInstructions(provider, unsavedInstructions);
            String query = "INSERT INTO bn_codenode_instructions (module_id, node_id, position, address, comment_id) VALUES (?, ?, ?, ?, ?)";
            ArrayList<Pair<INaviCodeNode, INaviInstruction>> instructionsWithUnsavedLocalComments = new ArrayList<Pair<INaviCodeNode, INaviInstruction>>();
            try (PreparedStatement preparedStatement = provider.getConnection().getConnection().prepareStatement("INSERT INTO bn_codenode_instructions (module_id, node_id, position, address, comment_id) VALUES (?, ?, ?, ?, ?)");){
                for (Integer index : codeNodeIndices) {
                    INaviCodeNode codeNode = (INaviCodeNode)nodes.get(index);
                    int position = 0;
                    for (INaviInstruction instruction : codeNode.getInstructions()) {
                        Integer commentId;
                        List<IComment> comments = codeNode.getComments().getLocalInstructionComment(instruction);
                        Integer n2 = comments == null ? null : (commentId = comments.size() == 0 ? null : Iterables.getLast(comments).getId());
                        if (comments != null && comments.size() != 0 && commentId == null) {
                            instructionsWithUnsavedLocalComments.add(new Pair<INaviCodeNode, INaviInstruction>(codeNode, instruction));
                        }
                        int moduleId = instruction.getModule().getConfiguration().getId();
                        preparedStatement.setInt(1, moduleId);
                        preparedStatement.setInt(2, firstNode + index);
                        preparedStatement.setInt(3, position);
                        preparedStatement.setObject(4, (Object)instruction.getAddress().toBigInteger(), -5);
                        if (commentId == null) {
                            preparedStatement.setNull(5, 4);
                        } else {
                            preparedStatement.setInt(5, commentId);
                        }
                        ++position;
                        preparedStatement.addBatch();
                    }
                }
                preparedStatement.executeBatch();
            }
            return instructionsWithUnsavedLocalComments;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveCodeNodes(SQLProvider provider, List<INaviViewNode> nodes, int firstNode, List<Integer> codeNodeIndices) throws SQLException {
        if (!codeNodeIndices.isEmpty()) {
            CComment newComment;
            ArrayList<Pair<INaviCodeNode, INaviInstruction>> instructionsWithUnsavedLocalComments = PostgreSQLNodeSaver.saveCodeNodeInstructions(provider, nodes, firstNode, codeNodeIndices);
            String query = "INSERT INTO bn_code_nodes(module_id, node_id, parent_function, comment_id) VALUES (?, ?, ?, ?)";
            ArrayList<INaviCodeNode> codeNodesWithUnsavedComments = new ArrayList<INaviCodeNode>();
            try (PreparedStatement preparedStatement = provider.getConnection().getConnection().prepareStatement("INSERT INTO bn_code_nodes(module_id, node_id, parent_function, comment_id) VALUES (?, ?, ?, ?)");){
                for (int n2 : codeNodeIndices) {
                    Integer commentId;
                    INaviCodeNode codeNode = (INaviCodeNode)nodes.get(n2);
                    codeNode.setId(firstNode + n2);
                    INaviFunction function = null;
                    try {
                        function = codeNode.getParentFunction();
                    }
                    catch (MaybeNullException maybeNullException) {
                        // empty catch block
                    }
                    int moduleId = ((INaviInstruction)Iterables.getLast(codeNode.getInstructions())).getModule().getConfiguration().getId();
                    List<IComment> comment = codeNode.getComments().getLocalCodeNodeComment();
                    Integer n3 = comment == null ? null : (commentId = comment.size() == 0 ? null : Iterables.getLast(comment).getId());
                    if (comment != null && comment.size() != 0 && commentId == null) {
                        codeNodesWithUnsavedComments.add(codeNode);
                    }
                    preparedStatement.setInt(1, moduleId);
                    preparedStatement.setInt(2, firstNode + n2);
                    if (function == null) {
                        preparedStatement.setNull(3, -5);
                    } else {
                        preparedStatement.setObject(3, (Object)function.getAddress().toBigInteger(), -5);
                    }
                    if (commentId == null) {
                        preparedStatement.setNull(4, 4);
                    } else {
                        preparedStatement.setInt(4, commentId);
                    }
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
            }
            for (INaviCodeNode iNaviCodeNode : codeNodesWithUnsavedComments) {
                ArrayList<IComment> codeNodecomments = new ArrayList<IComment>();
                for (IComment comment : iNaviCodeNode.getComments().getLocalCodeNodeComment()) {
                    try {
                        Integer commentId = PostgreSQLNodeFunctions.appendLocalCodeNodeComment(provider, iNaviCodeNode, comment.getComment(), comment.getUser().getUserId());
                        newComment = new CComment(commentId, comment.getUser(), comment.getParent(), comment.getComment());
                        codeNodecomments.add(newComment);
                    }
                    catch (CouldntSaveDataException exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
                iNaviCodeNode.getComments().initializeLocalCodeNodeComment(codeNodecomments);
            }
            for (Pair pair : instructionsWithUnsavedLocalComments) {
                ArrayList<IComment> localInstructionComments = new ArrayList<IComment>();
                for (IComment comment : ((INaviCodeNode)pair.first()).getComments().getLocalInstructionComment((INaviInstruction)pair.second())) {
                    try {
                        int commentId = PostgreSQLInstructionFunctions.appendLocalInstructionComment(provider, (INaviCodeNode)pair.first(), (INaviInstruction)pair.second(), comment.getComment(), comment.getUser().getUserId());
                        newComment = new CComment(commentId, comment.getUser(), comment.getParent(), comment.getComment());
                        localInstructionComments.add(newComment);
                    }
                    catch (CouldntSaveDataException exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
                ((INaviCodeNode)pair.first()).getComments().initializeLocalInstructionComment((INaviInstruction)pair.second(), localInstructionComments);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveFunctionNodes(SQLProvider provider, List<INaviViewNode> nodes, int firstNode, List<Integer> functionNodeIndices) throws SQLException {
        Integer commentId;
        if (functionNodeIndices.isEmpty()) {
            return;
        }
        String query = "INSERT INTO bn_function_nodes(module_id, node_id, function, comment_id) VALUES (?, ?, ?, ?)";
        ArrayList<CFunctionNode> functionNodesWithUnsavedComments = new ArrayList<CFunctionNode>();
        try (PreparedStatement preparedStatement = provider.getConnection().getConnection().prepareStatement("INSERT INTO bn_function_nodes(module_id, node_id, function, comment_id) VALUES (?, ?, ?, ?)");){
            for (int n2 : functionNodeIndices) {
                CFunctionNode node = (CFunctionNode)nodes.get(n2);
                INaviFunction function = node.getFunction();
                List<IComment> comments = node.getLocalFunctionComment();
                Integer n3 = comments == null ? null : (commentId = comments.size() == 0 ? null : Iterables.getLast(comments).getId());
                if (comments != null && comments.size() != 0 && commentId == null) {
                    functionNodesWithUnsavedComments.add(node);
                }
                preparedStatement.setInt(1, function.getModule().getConfiguration().getId());
                preparedStatement.setInt(2, firstNode + n2);
                preparedStatement.setObject(3, (Object)function.getAddress().toBigInteger(), -5);
                if (commentId == null) {
                    preparedStatement.setNull(4, 4);
                } else {
                    preparedStatement.setInt(4, commentId);
                }
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        for (INaviFunctionNode iNaviFunctionNode : functionNodesWithUnsavedComments) {
            ArrayList<IComment> functionNodeComments = new ArrayList<IComment>();
            for (IComment comment : iNaviFunctionNode.getLocalFunctionComment()) {
                try {
                    commentId = provider.appendFunctionNodeComment(iNaviFunctionNode, comment.getComment(), comment.getUser().getUserId());
                    CComment newComment = new CComment(commentId, comment.getUser(), comment.getParent(), comment.getComment());
                    functionNodeComments.add(newComment);
                }
                catch (CouldntSaveDataException exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
            iNaviFunctionNode.initializeLocalFunctionComment(functionNodeComments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveGroupNodes(SQLProvider provider, List<INaviViewNode> nodes, int firstNode, List<Integer> groupNodeIndices) throws SQLException {
        Preconditions.checkNotNull(provider, "IE02525: connection argument can not be null");
        Preconditions.checkNotNull(nodes, "IE02526: nodes argument can not be null");
        Preconditions.checkNotNull(groupNodeIndices, "Error: groupNodeIndices argument can not be null");
        if (!groupNodeIndices.isEmpty()) {
            String query = "INSERT INTO bn_group_nodes(node_id, collapsed, comment_id) VALUES (?, ?, ?)";
            ArrayList<INaviGroupNode> groupNodesWithUnsavedComments = new ArrayList<INaviGroupNode>();
            try (PreparedStatement preparedStatement = provider.getConnection().getConnection().prepareStatement("INSERT INTO bn_group_nodes(node_id, collapsed, comment_id) VALUES (?, ?, ?)");){
                for (Integer index : groupNodeIndices) {
                    Integer commentId;
                    INaviGroupNode node = (INaviGroupNode)nodes.get(index);
                    preparedStatement.setInt(1, firstNode + index);
                    preparedStatement.setBoolean(2, node.isCollapsed());
                    List<IComment> comment = node.getComments();
                    Integer n2 = comment == null ? null : (commentId = comment.size() == 0 ? null : Iterables.getLast(comment).getId());
                    if (comment != null && comment.size() != 0 && commentId == null) {
                        groupNodesWithUnsavedComments.add(node);
                    }
                    if (commentId == null) {
                        preparedStatement.setNull(3, 4);
                    } else {
                        preparedStatement.setInt(3, commentId);
                    }
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
            }
            for (INaviGroupNode groupNode : groupNodesWithUnsavedComments) {
                ArrayList<IComment> groupNodeComments = new ArrayList<IComment>();
                for (IComment comment : groupNode.getComments()) {
                    try {
                        Integer commentId = provider.appendGroupNodeComment(groupNode, comment.getComment(), comment.getUser().getUserId());
                        CComment newComment = new CComment(commentId, comment.getUser(), comment.getParent(), comment.getComment());
                        groupNodeComments.add(newComment);
                    }
                    catch (CouldntSaveDataException exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
                groupNode.initializeComment(groupNodeComments);
            }
        }
    }

    protected static void saveParentGroups(CConnection connection, List<INaviViewNode> nodes, int firstNode, BiMap<Integer, INaviGroupNode> groupNodeMap) throws SQLException {
        int counter = 0;
        for (INaviViewNode node : nodes) {
            if (node.getParentGroup() != null) {
                int parentId = firstNode + (Integer)groupNodeMap.inverse().get(node.getParentGroup());
                int childId = firstNode + counter;
                connection.executeUpdate(String.format("UPDATE bn_nodes set parent_id = %d WHERE id = %d", parentId, childId), true);
            }
            ++counter;
        }
    }

    protected static void saveTags(CConnection connection, List<INaviViewNode> nodes, int firstNode) throws SQLException {
        int counter = firstNode;
        String deleteStatement = "DELETE FROM bn_tagged_nodes WHERE node_id IN (%s)";
        String insertStatement = "INSERT INTO bn_tagged_nodes VALUES %s ";
        boolean isFirst = true;
        StringBuilder range = new StringBuilder();
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            if (isFirst) {
                range.append(counter);
                isFirst = false;
                continue;
            }
            range.append(", ");
            range.append(counter);
            ++counter;
        }
        if (range.length() != 0) {
            connection.executeUpdate(String.format("DELETE FROM bn_tagged_nodes WHERE node_id IN (%s)", range.toString()), true);
        }
        counter = firstNode;
        StringBuilder insert = new StringBuilder();
        isFirst = true;
        for (INaviViewNode node : nodes) {
            Iterator<CTag> it = node.getTagsIterator();
            while (it.hasNext()) {
                CTag tag = it.next();
                insert.append(isFirst ? "" : ",");
                insert.append('(');
                insert.append(counter);
                insert.append(", ");
                insert.append(tag.getId());
                insert.append(')');
                isFirst = false;
            }
            ++counter;
        }
        if (insert.length() != 0) {
            connection.executeUpdate(String.format("INSERT INTO bn_tagged_nodes VALUES %s ", insert.toString()), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void saveTextNodes(SQLProvider provider, List<INaviViewNode> nodes, int firstNode, List<Integer> textNodeIndices) throws SQLException {
        Preconditions.checkNotNull(provider, "IE02527: provider argument can not be null");
        Preconditions.checkNotNull(nodes, "IE02528: nodes argument can not be null");
        Preconditions.checkNotNull(textNodeIndices, "IE02529: textNodeIndices argument can not be null");
        if (!textNodeIndices.isEmpty()) {
            String query = "INSERT INTO bn_text_nodes(node_id, comment_id) VALUES (?, ?)";
            ArrayList<INaviTextNode> textNodesWithUnsavedComments = new ArrayList<INaviTextNode>();
            try (PreparedStatement preparedStatement = provider.getConnection().getConnection().prepareStatement("INSERT INTO bn_text_nodes(node_id, comment_id) VALUES (?, ?)");){
                for (Integer index : textNodeIndices) {
                    Integer commentId;
                    INaviTextNode node = (INaviTextNode)nodes.get(index);
                    List<IComment> comment = node.getComments();
                    Integer n2 = comment == null ? null : (commentId = comment.size() == 0 ? null : Iterables.getLast(comment).getId());
                    if (comment != null && comment.size() != 0 && commentId == null) {
                        textNodesWithUnsavedComments.add(node);
                    }
                    preparedStatement.setInt(1, firstNode + index);
                    if (commentId == null) {
                        preparedStatement.setNull(2, 4);
                    } else {
                        preparedStatement.setInt(2, commentId);
                    }
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
            }
            for (INaviTextNode textNode : textNodesWithUnsavedComments) {
                ArrayList<IComment> textNodeComments = new ArrayList<IComment>();
                for (IComment comment : textNode.getComments()) {
                    try {
                        Integer commentId = provider.appendTextNodeComment(textNode, comment.getComment(), comment.getUser().getUserId());
                        CComment newComment = new CComment(commentId, comment.getUser(), comment.getParent(), comment.getComment());
                        textNodeComments.add(newComment);
                    }
                    catch (CouldntSaveDataException exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
                textNode.initializeComment(textNodeComments);
            }
        }
    }

    protected static List<Integer> sortGroupNodes(List<Integer> groupNodeIndices, BiMap<Integer, INaviGroupNode> groupNodeMap) {
        ArrayList<Integer> sortedList = new ArrayList<Integer>();
        ArrayList<Integer> clonedList = new ArrayList<Integer>(groupNodeIndices);
        HashSet<INaviGroupNode> addedNodes = new HashSet<INaviGroupNode>();
        block0: while (!clonedList.isEmpty()) {
            for (Integer id : clonedList) {
                INaviGroupNode node = (INaviGroupNode)groupNodeMap.get(id);
                if (node.getParentGroup() != null && !addedNodes.contains(node.getParentGroup())) continue;
                addedNodes.add(node);
                sortedList.add(id);
                clonedList.remove(id);
                continue block0;
            }
        }
        return sortedList;
    }

    protected static void updateNodeIds(List<INaviViewNode> nodes, int firstNode) {
        int newIdCounter = firstNode;
        for (INaviViewNode node : nodes) {
            node.setId(newIdCounter);
            ++newIdCounter;
        }
    }

    public static void writeNodes(AbstractSQLProvider provider, int newViewId, List<INaviViewNode> nodes) throws SQLException {
        Preconditions.checkNotNull(provider, "IE01992: Provider argument can not be null");
        Preconditions.checkArgument(newViewId > 0, "IE01993: New View ID argument must be greater then zero");
        Preconditions.checkNotNull(nodes, "IE01994: Nodes argument can not be null");
        if (nodes.isEmpty()) {
            return;
        }
        ArrayList<Integer> functionNodeIndices = new ArrayList<Integer>();
        ArrayList<Integer> codeNodeIndices = new ArrayList<Integer>();
        ArrayList<Integer> textNodeIndices = new ArrayList<Integer>();
        ArrayList<Integer> groupNodeIndices = new ArrayList<Integer>();
        HashBiMap<Integer, INaviGroupNode> groupNodeMap = HashBiMap.create();
        int firstNode = PostgreSQLNodeSaver.saveNodes(provider, newViewId, nodes, functionNodeIndices, codeNodeIndices, textNodeIndices, groupNodeIndices, groupNodeMap);
        PostgreSQLNodeSaver.updateNodeIds(nodes, firstNode);
        PostgreSQLNodeSaver.saveGroupNodes(provider, nodes, firstNode, PostgreSQLNodeSaver.sortGroupNodes(groupNodeIndices, groupNodeMap));
        PostgreSQLNodeSaver.saveFunctionNodes(provider, nodes, firstNode, functionNodeIndices);
        PostgreSQLNodeSaver.saveCodeNodes(provider, nodes, firstNode, codeNodeIndices);
        PostgreSQLNodeSaver.saveTextNodes(provider, nodes, firstNode, textNodeIndices);
        CConnection connection = provider.getConnection();
        PostgreSQLNodeSaver.saveParentGroups(connection, nodes, firstNode, groupNodeMap);
        PostgreSQLNodeSaver.saveTags(connection, nodes, firstNode);
    }
}

