/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Savers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.zylib.gui.zygraph.edges.CBend;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public final class PostgreSQLEdgeSaver {
    private PostgreSQLEdgeSaver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillEdgesTable(CConnection connection, List<INaviEdge> edges) throws SQLException {
        String query = "INSERT INTO bn_edges(source_node_id, target_node_id, x1, y1, x2, y2, type, color, visible, selected, comment_id) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        try (PreparedStatement preparedStatement = connection.getConnection().prepareStatement("INSERT INTO bn_edges(source_node_id, target_node_id, x1, y1, x2, y2, type, color, visible, selected, comment_id) VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ", 1);){
            for (INaviEdge edge : edges) {
                preparedStatement.setInt(1, ((INaviViewNode)edge.getSource()).getId());
                preparedStatement.setInt(2, ((INaviViewNode)edge.getTarget()).getId());
                preparedStatement.setDouble(3, edge.getX1());
                preparedStatement.setDouble(4, edge.getY1());
                preparedStatement.setDouble(5, edge.getX2());
                preparedStatement.setDouble(6, edge.getY2());
                preparedStatement.setObject(7, (Object)edge.getType().toString().toLowerCase(), 1111);
                preparedStatement.setInt(8, edge.getColor().getRGB());
                preparedStatement.setBoolean(9, edge.isVisible());
                preparedStatement.setBoolean(10, edge.isSelected());
                if (edge.getLocalComment() == null) {
                    preparedStatement.setNull(11, 4);
                } else {
                    preparedStatement.setInt(11, Iterables.getLast(edge.getLocalComment()).getId());
                }
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            ResultSet resultSet = preparedStatement.getGeneratedKeys();
            for (INaviEdge edge : edges) {
                if (resultSet.next()) {
                    edge.setId(resultSet.getInt(1));
                    continue;
                }
                throw new IllegalStateException("Error: The number of keys generated does not match the number of edges");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fillEdgepathsTable(CConnection connection, List<INaviEdge> edges) throws SQLException {
        String query = "INSERT INTO bn_edge_paths(edge_id, position, x, y) VALUES (?, ?, ?, ?)";
        try (PreparedStatement preparedStatement = connection.getConnection().prepareStatement("INSERT INTO bn_edge_paths(edge_id, position, x, y) VALUES (?, ?, ?, ?)");){
            for (INaviEdge edge : edges) {
                for (CBend bend : edge.getBends()) {
                    preparedStatement.setInt(1, edge.getId());
                    preparedStatement.setInt(2, edge.getBends().indexOf(bend));
                    preparedStatement.setDouble(3, bend.getX());
                    preparedStatement.setDouble(4, bend.getY());
                    preparedStatement.addBatch();
                }
            }
            preparedStatement.executeBatch();
        }
    }

    public static void writeEdges(SQLProvider provider, List<INaviEdge> edges) throws SQLException {
        Preconditions.checkNotNull(provider, "IE02253: Provider argument can not be null");
        Preconditions.checkNotNull(edges, "IE02254: Edges argument can not be null");
        for (INaviEdge edge : edges) {
            Preconditions.checkArgument(edge.inSameDatabase(provider), "IE02255: Edge list contains an edge that is not part of this database");
        }
        if (edges.isEmpty()) {
            return;
        }
        CConnection connection = provider.getConnection();
        PostgreSQLEdgeSaver.fillEdgesTable(connection, edges);
        PostgreSQLEdgeSaver.fillEdgepathsTable(connection, edges);
    }
}

