/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.parsers;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Database.CModuleViewGenerator;
import com.google.security.zynamics.binnavi.Database.CProjectViewGenerator;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.ViewNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.interfaces.PostgreSQLNotificationParser;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.ImmutableNaviViewConfiguration;
import com.google.security.zynamics.binnavi.disassembly.views.ViewManager;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.PGNotification;

public class PostgreSQLViewNotificationParser
implements PostgreSQLNotificationParser<ViewNotificationContainer> {
    private static final String VIEW_NOTIFICATION_REGULAR_EXPRESSION = "^(bn_views)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)$";
    private static final Pattern viewNotificationPattern = Pattern.compile("^(bn_views)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)$");
    private static final String MODULE_VIEW_NOTIFICATION_REGULAR_EXPRESSION = "^(bn_module_views)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)$";
    private static Pattern moduleViewNotificationPattern = Pattern.compile("^(bn_module_views)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)$");
    private static final String PROJECT_VIEW_NOTIFICATION_REGULAR_EXPRESSION = "^(bn_project_views)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)$";
    private static Pattern projectViewNotificationPattern = Pattern.compile("^(bn_project_views)\\s(INSERT|UPDATE|DELETE)\\s(\\d*)\\s(\\d*)$");

    private ViewNotificationContainer parseViewNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = viewNotificationPattern.matcher(notification.getParameter());
        if (!matcher.find()) {
            String string2 = String.valueOf(viewNotificationPattern.toString());
            String string3 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(new StringBuilder(56 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("IE02742: compiled pattern: ").append(string2).append(" did not match notification: ").append(string3).toString());
        }
        Integer viewId = Integer.parseInt(matcher.group(3));
        Optional<INaviView> view = Optional.fromNullable(ViewManager.get(provider).getView(viewId));
        String databaseOperation = matcher.group(2);
        return new ViewNotificationContainer(viewId, view, Optional.absent(), Optional.absent(), Optional.absent(), databaseOperation);
    }

    private ViewNotificationContainer parseModuleViewNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = moduleViewNotificationPattern.matcher(notification.getParameter());
        if (!matcher.find()) {
            String string2 = String.valueOf(moduleViewNotificationPattern.toString());
            String string3 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(new StringBuilder(56 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("IE02743: compiled pattern: ").append(string2).append(" did not match notification: ").append(string3).toString());
        }
        Integer viewId = Integer.parseInt(matcher.group(3));
        Optional<INaviView> view = Optional.fromNullable(ViewManager.get(provider).getView(viewId));
        Optional<Integer> moduleId = Optional.fromNullable(Integer.parseInt(matcher.group(4)));
        Optional<INaviModule> module = Optional.fromNullable(provider.findModule(moduleId.get()));
        String databaseOperation = matcher.group(2);
        return new ViewNotificationContainer(viewId, view, moduleId, module, Optional.absent(), databaseOperation);
    }

    private ViewNotificationContainer parseProjectViewNotification(PGNotification notification, SQLProvider provider) {
        Matcher matcher = projectViewNotificationPattern.matcher(notification.getParameter());
        if (!matcher.find()) {
            String string2 = String.valueOf(projectViewNotificationPattern.toString());
            String string3 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(new StringBuilder(56 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("IE02744: compiled pattern: ").append(string2).append(" did not match notification: ").append(string3).toString());
        }
        Integer viewId = Integer.parseInt(matcher.group(3));
        Optional<INaviView> view = Optional.fromNullable(ViewManager.get(provider).getView(viewId));
        Optional<Integer> projectId = Optional.fromNullable(Integer.parseInt(matcher.group(4)));
        Optional<INaviProject> project = Optional.fromNullable(provider.findProject(projectId.get()));
        String databaseOperation = matcher.group(2);
        return new ViewNotificationContainer(viewId, view, projectId, Optional.absent(), project, databaseOperation);
    }

    @Override
    public Collection<ViewNotificationContainer> parse(Collection<PGNotification> notifications, SQLProvider provider) {
        Preconditions.checkNotNull(notifications, "IE02745: notifications argument can not be null");
        Preconditions.checkNotNull(provider, "IE02746: provider argument can not be null");
        ArrayList<ViewNotificationContainer> containers = Lists.newArrayList();
        for (PGNotification notification : notifications) {
            if (notification.getParameter().startsWith("bn_views")) {
                containers.add(this.parseViewNotification(notification, provider));
                continue;
            }
            if (notification.getParameter().startsWith("bn_module_views")) {
                containers.add(this.parseModuleViewNotification(notification, provider));
                continue;
            }
            if (notification.getParameter().startsWith("bn_project_views")) {
                containers.add(this.parseProjectViewNotification(notification, provider));
                continue;
            }
            String string2 = String.valueOf(notification.getParameter());
            throw new IllegalStateException(new StringBuilder(110 + String.valueOf(string2).length()).append("IE02747: Table name supplied in notification: ").append(string2).append(" does not match tables where view notifications are accepted on.").toString());
        }
        return containers;
    }

    @Override
    public void inform(Collection<ViewNotificationContainer> parsedViewNotifications, SQLProvider provider) throws CouldntLoadDataException {
        Preconditions.checkNotNull(parsedViewNotifications, "Error: parsedViewNotifications argument can not be null");
        Preconditions.checkNotNull(provider, "IE02748: provider argument can not be null");
        for (ViewNotificationContainer container : parsedViewNotifications) {
            if (container.getNotificationModule().isPresent()) {
                this.informModuleNotification(container, provider);
                continue;
            }
            if (container.getNotificationProject().isPresent()) {
                this.informProjectNotification(container, provider);
                continue;
            }
            if (!container.getNotificationObjectId().isPresent()) {
                this.informViewNotification(container, provider);
                continue;
            }
            if (container.getNotificationObjectId().isPresent() || container.getNotificationModule().isPresent() || container.getNotificationProject().isPresent()) continue;
            throw new IllegalStateException("IE02749: Not enough information available.");
        }
    }

    private void informModuleNotification(ViewNotificationContainer moduleViewNotificationContainer, SQLProvider provider) throws CouldntLoadDataException {
        Integer viewId;
        INaviModule module;
        if (moduleViewNotificationContainer.getDatabaseOperation().equals("INSERT")) {
            module = moduleViewNotificationContainer.getNotificationModule().get();
            if (!module.isLoaded()) {
                return;
            }
            viewId = moduleViewNotificationContainer.getViewId();
            ImmutableNaviViewConfiguration databaseViewConfiguration = provider.loadFlowGraphInformation(module, viewId);
            CModuleViewGenerator generator2 = new CModuleViewGenerator(provider, module);
            INaviView view = generator2.generate(databaseViewConfiguration, GraphType.FLOWGRAPH);
            module.getContent().getViewContainer().addView(view);
        }
        if (moduleViewNotificationContainer.getDatabaseOperation().equals("UPDATE")) {
            return;
        }
        if (moduleViewNotificationContainer.getDatabaseOperation().equals("DELETE")) {
            module = moduleViewNotificationContainer.getNotificationModule().get();
            if (!module.isLoaded()) {
                return;
            }
            viewId = moduleViewNotificationContainer.getViewId();
            INaviView view = ViewManager.get(provider).getView(viewId);
            module.getContent().getViewContainer().deleteViewInternal(view);
        }
    }

    private void informProjectNotification(ViewNotificationContainer projectNotificationContainer, SQLProvider provider) throws CouldntLoadDataException {
        Integer viewId;
        INaviProject project;
        if (projectNotificationContainer.getDatabaseOperation().equals("INSERT")) {
            project = projectNotificationContainer.getNotificationProject().get();
            if (!project.isLoaded()) {
                return;
            }
            viewId = projectNotificationContainer.getViewId();
            ImmutableNaviViewConfiguration databaseViewConfiguration = provider.loadFlowGraphInformation(project, viewId);
            CProjectViewGenerator generator2 = new CProjectViewGenerator(provider, project);
            INaviView view = generator2.generate(databaseViewConfiguration);
            project.getContent().addView(view);
        }
        if (projectNotificationContainer.getDatabaseOperation().equals("UPDATE")) {
            return;
        }
        if (projectNotificationContainer.getDatabaseOperation().equals("DELETE")) {
            project = projectNotificationContainer.getNotificationProject().get();
            if (!project.isLoaded()) {
                return;
            }
            viewId = projectNotificationContainer.getViewId();
            INaviView view = ViewManager.get(provider).getView(viewId);
            project.getContent().deleteViewInternal(view);
        }
    }

    private void informViewNotification(ViewNotificationContainer viewNotificationContainer, SQLProvider provider) throws CouldntLoadDataException {
        if (viewNotificationContainer.getDatabaseOperation().equals("INSERT")) {
            return;
        }
        if (viewNotificationContainer.getDatabaseOperation().equals("UPDATE")) {
            ImmutableNaviViewConfiguration databaseViewConfiguration;
            Integer viewId = viewNotificationContainer.getViewId();
            INaviView view = viewNotificationContainer.getView().get();
            ImmutableNaviViewConfiguration immutableNaviViewConfiguration = databaseViewConfiguration = view.getConfiguration().getModule() == null ? provider.loadFlowGraphInformation(view.getConfiguration().getProject(), viewId) : provider.loadFlowGraphInformation(view.getConfiguration().getModule(), viewId);
            if (databaseViewConfiguration == null) {
                return;
            }
            if (!databaseViewConfiguration.getName().equals(view.getConfiguration().getName())) {
                view.getConfiguration().setNameInternal(databaseViewConfiguration.getName());
            }
            if (databaseViewConfiguration.getDescription() != view.getConfiguration().getDescription() && !databaseViewConfiguration.getDescription().equals(view.getConfiguration().getDescription())) {
                view.getConfiguration().setDescriptionInternal(databaseViewConfiguration.getDescription());
            }
            if (databaseViewConfiguration.getStarState() != view.getConfiguration().isStared()) {
                view.getConfiguration().setStaredInternal(databaseViewConfiguration.getStarState());
            }
            view.getConfiguration().setModificationDateInternal(databaseViewConfiguration.getModificationDate());
        }
        if (viewNotificationContainer.getDatabaseOperation().equals("DELETE")) {
            return;
        }
    }
}

