/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.interfaces.CommentNotification;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;

public class CommentNotificationContainer
implements CommentNotification {
    private final IComment currentComment;
    private final IComment newComment;
    private final CommentManager.CommentOperation operation;

    public CommentNotificationContainer(IComment currentComment, IComment newComment, CommentManager.CommentOperation operation) {
        this.currentComment = Preconditions.checkNotNull(currentComment, "Error: Current comment argument can not be null.");
        this.newComment = newComment;
        this.operation = Preconditions.checkNotNull(operation, "Error: Operation argument can not be null.");
    }

    @Override
    public void inform(CommentManager manager) throws CouldntLoadDataException {
        if (this.operation == CommentManager.CommentOperation.EDIT) {
            this.informEdit(manager);
        } else if (this.operation == CommentManager.CommentOperation.DELETE) {
            this.informDelete(manager);
        }
    }

    private void informEdit(CommentManager manager) {
        if (manager.getCommentedFunction(this.getCurrentComment()) != null) {
            manager.editFunctionComment(manager.getCommentedFunction(this.getCurrentComment()), this.getCurrentComment(), this.newComment, CommentManager.CommentScope.GLOBAL);
        }
        if (manager.getCommentedFunctionNode(this.getCurrentComment()) != null) {
            manager.editFunctionNodeComment(manager.getCommentedFunctionNode(this.getCurrentComment()), this.getCurrentComment(), this.newComment, CommentManager.CommentScope.GLOBAL);
        }
        if (manager.getCommentedGlobalCodeNode(this.getCurrentComment()) != null) {
            manager.editCodeNodeComment(manager.getCommentedGlobalCodeNode(this.getCurrentComment()), this.getCurrentComment(), this.newComment, CommentManager.CommentScope.GLOBAL);
        }
        if (manager.getCommentedLocalCodeNode(this.getCurrentComment()) != null) {
            manager.editCodeNodeComment(manager.getCommentedLocalCodeNode(this.getCurrentComment()), this.getCurrentComment(), this.newComment, CommentManager.CommentScope.LOCAL);
        }
        if (manager.getCommentedLocalEdge(this.getCurrentComment()) != null) {
            manager.editEdgeComment(manager.getCommentedLocalEdge(this.getCurrentComment()), this.getCurrentComment(), this.newComment, CommentManager.CommentScope.LOCAL);
        }
        if (manager.getCommentedGlobalEdge(this.getCurrentComment()) != null) {
            manager.editEdgeComment(manager.getCommentedGlobalEdge(this.getCurrentComment()), this.getCurrentComment(), this.newComment, CommentManager.CommentScope.GLOBAL);
        }
        if (manager.getCommentedGlobalInstruction(this.getCurrentComment()) != null) {
            manager.editInstructionComment(manager.getCommentedGlobalInstruction(this.getCurrentComment()), null, this.getCurrentComment(), this.newComment, CommentManager.CommentScope.GLOBAL);
        }
        if (manager.getCommentedLocalInstruction(this.getCurrentComment()) != null) {
            manager.editInstructionComment(manager.getCommentedLocalInstruction(this.getCurrentComment()).second(), manager.getCommentedLocalInstruction(this.getCurrentComment()).first(), this.getCurrentComment(), this.newComment, CommentManager.CommentScope.LOCAL);
        }
        if (manager.getCommentedGroupNode(this.getCurrentComment()) != null) {
            manager.editGroupNodeComment(manager.getCommentedGroupNode(this.getCurrentComment()), this.getCurrentComment(), this.newComment, CommentManager.CommentScope.LOCAL);
        }
        if (manager.getCommentedTextNode(this.getCurrentComment()) != null) {
            manager.editTextNodeComment(manager.getCommentedTextNode(this.getCurrentComment()), this.getCurrentComment(), this.newComment, CommentManager.CommentScope.LOCAL);
        }
        if (manager.getCommentedTypeInstance(this.getCurrentComment()) != null) {
            manager.editTypeInstanceComment(manager.getCommentedTypeInstance(this.getCurrentComment()), this.getCurrentComment(), this.newComment);
        }
    }

    private void informDelete(CommentManager manager) {
        if (manager.getCommentedFunction(this.getCurrentComment()) != null) {
            manager.deleteFunctionCommentInternal(manager.getCommentedFunction(this.getCurrentComment()), this.getCurrentComment());
        }
        if (manager.getCommentedFunctionNode(this.getCurrentComment()) != null) {
            manager.deleteFunctionNodeCommentInternal(manager.getCommentedFunctionNode(this.getCurrentComment()), this.getCurrentComment());
        }
        if (manager.getCommentedGlobalCodeNode(this.getCurrentComment()) != null) {
            manager.deleteCodeNodeComment(manager.getCommentedGlobalCodeNode(this.getCurrentComment()), this.getCurrentComment(), CommentManager.CommentScope.GLOBAL);
        }
        if (manager.getCommentedLocalCodeNode(this.getCurrentComment()) != null) {
            manager.deleteCodeNodeComment(manager.getCommentedLocalCodeNode(this.getCurrentComment()), this.getCurrentComment(), CommentManager.CommentScope.LOCAL);
        }
        if (manager.getCommentedLocalEdge(this.getCurrentComment()) != null) {
            manager.deleteEdgeComment(manager.getCommentedLocalEdge(this.getCurrentComment()), this.getCurrentComment(), CommentManager.CommentScope.LOCAL);
        }
        if (manager.getCommentedGlobalEdge(this.getCurrentComment()) != null) {
            manager.deleteEdgeComment(manager.getCommentedGlobalEdge(this.getCurrentComment()), this.getCurrentComment(), CommentManager.CommentScope.GLOBAL);
        }
        if (manager.getCommentedGlobalInstruction(this.getCurrentComment()) != null) {
            manager.deleteInstructionComment(manager.getCommentedGlobalInstruction(this.getCurrentComment()), null, CommentManager.CommentScope.GLOBAL, this.getCurrentComment());
        }
        if (manager.getCommentedLocalInstruction(this.getCurrentComment()) != null) {
            manager.deleteInstructionComment(manager.getCommentedLocalInstruction(this.getCurrentComment()).second(), manager.getCommentedLocalInstruction(this.getCurrentComment()).first(), CommentManager.CommentScope.LOCAL, this.getCurrentComment());
        }
        if (manager.getCommentedGroupNode(this.getCurrentComment()) != null) {
            manager.deleteGroupNodeCommentInternal(manager.getCommentedGroupNode(this.getCurrentComment()), this.getCurrentComment());
        }
        if (manager.getCommentedTextNode(this.getCurrentComment()) != null) {
            manager.deleteTextNodeCommentInternal(manager.getCommentedTextNode(this.getCurrentComment()), this.getCurrentComment());
        }
        if (manager.getCommentedTypeInstance(this.getCurrentComment()) != null) {
            manager.deleteTypeInstanceCommentInternal(manager.getCommentedTypeInstance(this.getCurrentComment()), this.getCurrentComment());
        }
    }

    public IComment getCurrentComment() {
        return this.currentComment;
    }

    public IComment getNewComment() {
        return this.newComment;
    }

    @Override
    public CommentManager.CommentOperation getOperation() {
        return this.operation;
    }

    @Override
    public Integer getCommentId() {
        return this.currentComment.getId();
    }
}

