/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.CDatabaseConfiguration;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDriverException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.NotificationChannel;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.FunctionNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.TypeInstancesNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.TypesNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.containers.ViewNotificationContainer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.interfaces.PostgreSQLNotificationListener;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.parsers.PostgreSQLCommentNotificationParser;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.parsers.PostgreSQLFunctionNotificationParser;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.parsers.PostgreSQLTypeInstancesNotificationParser;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.parsers.PostgreSQLTypesNotificationParser;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Notifications.parsers.PostgreSQLViewNotificationParser;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Database.PostgreSQLProvider;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.postgresql.PGConnection;
import org.postgresql.PGNotification;

public class PostgreSQLNotificationProvider {
    private final Set<NotificationChannel> m_channels = new HashSet<NotificationChannel>();
    private final ScheduledExecutorService m_scheduler = Executors.newSingleThreadScheduledExecutor();
    private final CNotificationQueuePoller m_notificationPoller;
    private final CDatabaseConfiguration m_configuration;
    private CConnection m_connection;
    private final ListenerProvider<PostgreSQLNotificationListener> m_listeners = new ListenerProvider();
    private static Map<SQLProvider, PostgreSQLNotificationProvider> m_notificationProviders = new HashMap<SQLProvider, PostgreSQLNotificationProvider>();
    private final SQLProvider m_provider;
    private final int m_backendPID;

    private PostgreSQLNotificationProvider(CDatabaseConfiguration configuration, SQLProvider provider) throws CouldntLoadDriverException, SQLException {
        this.m_configuration = configuration;
        this.m_provider = provider;
        this.m_backendPID = PostgreSQLHelpers.getBackendPID(((PostgreSQLProvider)this.m_provider).getConnection());
        this.m_connection = new CConnection(this.m_configuration);
        this.m_notificationPoller = new CNotificationQueuePoller();
    }

    public static synchronized boolean contains(SQLProvider provider) {
        Preconditions.checkNotNull(provider, "IE02415: provider argument can not be null");
        return m_notificationProviders.containsKey(provider);
    }

    public static synchronized PostgreSQLNotificationProvider get(SQLProvider provider) {
        Preconditions.checkNotNull(provider, "IE02416: provider argument can not be null");
        return m_notificationProviders.containsKey(provider) ? m_notificationProviders.get(provider) : null;
    }

    public static synchronized PostgreSQLNotificationProvider initialize(SQLProvider provider, CDatabaseConfiguration databaseConfiguration) throws CouldntLoadDriverException, SQLException {
        Preconditions.checkNotNull(provider, "IE02417: provider argument can not be null");
        Preconditions.checkNotNull(databaseConfiguration, "IE02418: databaseConfiguration argument can not be null");
        m_notificationProviders.put(provider, new PostgreSQLNotificationProvider(databaseConfiguration, provider));
        return PostgreSQLNotificationProvider.get(provider);
    }

    private synchronized void sendListens(Set<NotificationChannel> channelNames) {
        for (NotificationChannel channel : channelNames) {
            try {
                String string2 = String.valueOf(channel.name());
                this.m_connection.executeUpdate(string2.length() != 0 ? "LISTEN ".concat(string2) : new String("LISTEN "), true);
            }
            catch (SQLException exception) {
                NaviLogger.severe("Error: Could not send LISTEN command to database server: %s", exception);
            }
        }
        for (PostgreSQLNotificationListener listener : this.m_listeners) {
            try {
                listener.listenedChannelsAdded(this.m_provider, channelNames);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    private synchronized void sendUnlistens(Set<NotificationChannel> channelNames) {
        for (NotificationChannel channel : channelNames) {
            try {
                String string2 = String.valueOf(channel.name());
                this.m_connection.executeUpdate(string2.length() != 0 ? "UNLISTEN ".concat(string2) : new String("UNLISTEN "), true);
            }
            catch (SQLException exception) {
                NaviLogger.severe("Error: Could not send UNLISTEN command to database server: %s", exception);
            }
        }
        for (PostgreSQLNotificationListener listener : this.m_listeners) {
            try {
                listener.listenedChannelsRemoved(this.m_provider, channelNames);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public synchronized void addListener(PostgreSQLNotificationListener listener) {
        this.m_listeners.addListener(listener);
    }

    public synchronized Set<NotificationChannel> getCurrentlyListenedChannels() {
        return ImmutableSet.copyOf(this.m_channels);
    }

    public synchronized void listen(Set<NotificationChannel> channelNames) {
        this.m_channels.addAll(channelNames);
    }

    public synchronized void removeListener(PostgreSQLNotificationListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public synchronized void startPolling() {
        this.m_scheduler.scheduleAtFixedRate(this.m_notificationPoller, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    public synchronized void stopPolling() {
        this.m_scheduler.shutdown();
    }

    public synchronized boolean unInitialize() {
        this.sendUnlistens(this.m_channels);
        this.unlisten(this.m_channels);
        this.stopPolling();
        m_notificationProviders.remove(this.m_provider);
        this.m_connection.closeConnection();
        this.m_connection = null;
        return true;
    }

    public synchronized void unlisten(Set<NotificationChannel> channelNames) {
        this.m_channels.removeAll(channelNames);
    }

    private class CNotificationQueuePoller
    implements Runnable {
        private final Set<NotificationChannel> m_currentListenedChannels = new HashSet<NotificationChannel>();

        private void poll() throws SQLException, CouldntLoadDataException {
            PGNotification[] notifications = ((PGConnection)((Object)PostgreSQLNotificationProvider.this.m_connection.getConnection())).getNotifications();
            if (notifications == null) {
                return;
            }
            ArrayList<PGNotification> commentNotifications = Lists.newArrayList();
            ArrayList<PGNotification> viewNotifications = Lists.newArrayList();
            ArrayList<PGNotification> functionNotifications = Lists.newArrayList();
            ArrayList<PGNotification> typeNotifications = Lists.newArrayList();
            ArrayList<PGNotification> typeInstanceNotifications = Lists.newArrayList();
            for (PGNotification notification : notifications) {
                if (notification.getPID() == PostgreSQLNotificationProvider.this.m_backendPID) continue;
                if (notification.getName().equalsIgnoreCase(NotificationChannel.comment_changes.name())) {
                    commentNotifications.add(notification);
                    continue;
                }
                if (notification.getName().equalsIgnoreCase(NotificationChannel.view_changes.name())) {
                    viewNotifications.add(notification);
                    continue;
                }
                if (notification.getName().equalsIgnoreCase(NotificationChannel.function_changes.name())) {
                    functionNotifications.add(notification);
                    continue;
                }
                if (notification.getName().equalsIgnoreCase(NotificationChannel.types_changes.name())) {
                    typeNotifications.add(notification);
                    continue;
                }
                if (!notification.getName().equalsIgnoreCase(NotificationChannel.type_instances_changes.name())) continue;
                typeInstanceNotifications.add(notification);
            }
            PostgreSQLViewNotificationParser viewParser = new PostgreSQLViewNotificationParser();
            Collection<ViewNotificationContainer> parsedViewNotifications = viewParser.parse(viewNotifications, PostgreSQLNotificationProvider.this.m_provider);
            viewParser.inform(parsedViewNotifications, PostgreSQLNotificationProvider.this.m_provider);
            PostgreSQLFunctionNotificationParser functionParser = new PostgreSQLFunctionNotificationParser();
            Collection<FunctionNotificationContainer> parsedFunctionNotifications = functionParser.parse(functionNotifications, PostgreSQLNotificationProvider.this.m_provider);
            functionParser.inform(parsedFunctionNotifications, PostgreSQLNotificationProvider.this.m_provider);
            PostgreSQLCommentNotificationParser commentParser = new PostgreSQLCommentNotificationParser();
            commentParser.parse(commentNotifications, PostgreSQLNotificationProvider.this.m_provider);
            PostgreSQLTypesNotificationParser typesParser = new PostgreSQLTypesNotificationParser();
            Collection<TypesNotificationContainer> parsedTypesNotifications = typesParser.parse(typeNotifications, PostgreSQLNotificationProvider.this.m_provider);
            typesParser.inform(parsedTypesNotifications, PostgreSQLNotificationProvider.this.m_provider);
            PostgreSQLTypeInstancesNotificationParser typeInstancesParser = new PostgreSQLTypeInstancesNotificationParser();
            Collection<TypeInstancesNotificationContainer> parsedTypeInstanceNotifications = typeInstancesParser.parse(typeInstanceNotifications, PostgreSQLNotificationProvider.this.m_provider);
            typeInstancesParser.inform(parsedTypeInstanceNotifications, PostgreSQLNotificationProvider.this.m_provider);
        }

        private void syncListenedChannels() {
            if (PostgreSQLNotificationProvider.this.m_channels.equals(this.m_currentListenedChannels)) {
                return;
            }
            HashSet channels = Sets.newHashSet(PostgreSQLNotificationProvider.this.m_channels);
            Sets.SetView<NotificationChannel> toUnlisten = Sets.difference(this.m_currentListenedChannels, channels);
            Sets.SetView toListen = Sets.difference(channels, this.m_currentListenedChannels);
            if (!toUnlisten.isEmpty()) {
                PostgreSQLNotificationProvider.this.sendUnlistens(toUnlisten);
            }
            if (!toListen.isEmpty()) {
                PostgreSQLNotificationProvider.this.sendListens(toListen);
            }
            if (!toUnlisten.isEmpty() || !toListen.isEmpty()) {
                this.m_currentListenedChannels.clear();
                this.m_currentListenedChannels.addAll(channels);
            }
        }

        @Override
        public void run() {
            if (!PostgreSQLNotificationProvider.this.m_connection.isConnectionValid()) {
                try {
                    PostgreSQLNotificationProvider.this.m_connection = new CConnection(PostgreSQLNotificationProvider.this.m_configuration);
                }
                catch (CouldntLoadDriverException | SQLException exception) {
                    NaviLogger.severe("Error: Could not reestablish the connection with the database backend %s", exception);
                }
            }
            this.syncListenedChannels();
            try {
                this.poll();
            }
            catch (Exception exception) {
                NaviLogger.severe("Error: Could not get notifications from the PostgreSQL backend with exception %s", exception);
                exception.printStackTrace();
            }
        }
    }
}

