/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.CModuleViewGenerator;
import com.google.security.zynamics.binnavi.Database.CProjectViewGenerator;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagHelpers;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PostgreSQLViewsLoader {
    private static void checkArguments(AbstractSQLProvider provider, CModule module, List<IFlowgraphView> flowgraphs, List<INaviFunction> functions) {
        Preconditions.checkNotNull(provider, "IE00630: Provider argument can not be null");
        Preconditions.checkNotNull(module, "IE00631: Module argument can not be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE00632: Module is not part of this database");
        Preconditions.checkNotNull(flowgraphs, "IE00633: Flowgraphs argument can not be null");
        for (IFlowgraphView view : flowgraphs) {
            Preconditions.checkNotNull(view, "IE00634: View list contains a null-element");
            Preconditions.checkArgument(view.inSameDatabase(provider), "IE00635: View is not part of this database");
        }
        Preconditions.checkNotNull(functions, "IE00636: Functions argument can not be null");
        for (INaviFunction function : functions) {
            Preconditions.checkNotNull(function, "IE00637: Function list contains a null-element");
            Preconditions.checkArgument(function.inSameDatabase(provider), "IE00638: Function is not part of this database");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, Set<CTag>> getNodeTags(CConnection connection, INaviModule module, ITagManager nodeTagManager) throws SQLException {
        HashMap<Integer, Set<CTag>> tagMap = new HashMap<Integer, Set<CTag>>();
        String query = "SELECT * FROM load_module_node_tags(?)";
        PreparedStatement statement = connection.getConnection().prepareStatement("SELECT * FROM load_module_node_tags(?)");
        statement.setInt(1, module.getConfiguration().getId());
        try (ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                CTag tag;
                int viewId = resultSet.getInt(1);
                int tagId = resultSet.getInt(2);
                if (!tagMap.containsKey(viewId)) {
                    tagMap.put(viewId, new HashSet());
                }
                if ((tag = CTagHelpers.findTag(nodeTagManager.getRootTag(), tagId)) == null) continue;
                ((Set)tagMap.get(viewId)).add(tag);
            }
        }
        return tagMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, Set<CTag>> getNodeTags(CConnection connection, INaviProject project, ITagManager nodeTagManager) throws SQLException {
        HashMap<Integer, Set<CTag>> tagMap = new HashMap<Integer, Set<CTag>>();
        String query = " SELECT * FROM load_project_node_tags(?) ";
        PreparedStatement statement = connection.getConnection().prepareStatement(" SELECT * FROM load_project_node_tags(?) ");
        statement.setInt(1, project.getConfiguration().getId());
        try (ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                CTag tag;
                int viewId = resultSet.getInt("view_id");
                int tagId = resultSet.getInt("tag_id");
                if (!tagMap.containsKey(viewId)) {
                    tagMap.put(viewId, new HashSet());
                }
                if ((tag = CTagHelpers.findTag(nodeTagManager.getRootTag(), tagId)) == null) continue;
                ((Set)tagMap.get(viewId)).add(tag);
            }
        }
        return tagMap;
    }

    protected static final void checkArguments(SQLProvider provider, CModule module, CTagManager viewTagManager) {
        PostgreSQLViewsLoader.checkArguments(provider, viewTagManager);
        Preconditions.checkNotNull(module, "IE00497: Module argument can't be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE00498: Module is not part of this database");
    }

    protected static final void checkArguments(SQLProvider provider, CTagManager viewTagManager) {
        Preconditions.checkNotNull(provider, "IE00639: Provider argument can not be null");
        Preconditions.checkNotNull(viewTagManager, "IE00640: Tag manager argument can not be null");
        Preconditions.checkArgument(viewTagManager.inSameDatabase(provider), "IE00641: Tag manager is not part of this database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final List<CView> processQueryResults(ResultSet resultSet, INaviModule module, Map<Integer, Set<CTag>> tags, ITagManager nodeTagManager, SQLProvider provider, List<CView> views, ViewType viewType, GraphType graphType) throws SQLException {
        Map<Integer, Set<CTag>> nodeTagMap = PostgreSQLViewsLoader.getNodeTags(provider.getConnection(), module, nodeTagManager);
        try {
            while (resultSet.next()) {
                int viewId = resultSet.getInt("view_id");
                String name = PostgreSQLHelpers.readString(resultSet, "name");
                String description = PostgreSQLHelpers.readString(resultSet, "description");
                Timestamp creationDate = resultSet.getTimestamp("creation_date");
                Timestamp modificationDate = resultSet.getTimestamp("modification_date");
                boolean starState = resultSet.getBoolean("stared");
                int nodeCount = resultSet.getInt("bbcount");
                int edgeCount = resultSet.getInt("edgecount");
                HashSet<CTag> viewTags = tags.containsKey(viewId) ? tags.get(viewId) : new HashSet<CTag>();
                HashSet<CTag> nodeTags = nodeTagMap.containsKey(viewId) ? nodeTagMap.get(viewId) : new HashSet<CTag>();
                CModuleViewGenerator generator2 = new CModuleViewGenerator(provider, module);
                views.add(generator2.generate(viewId, name, description, viewType, graphType, creationDate, modificationDate, nodeCount, edgeCount, viewTags, nodeTags, starState));
            }
            List<CView> list = views;
            return list;
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final List<CView> processQueryResults(ResultSet resultSet, INaviProject project, Map<Integer, Set<CTag>> tags, ITagManager nodeTagManager, SQLProvider provider, List<CView> views, ViewType viewType, GraphType graphType) throws SQLException {
        Map<Integer, Set<CTag>> nodeTagMap = PostgreSQLViewsLoader.getNodeTags(provider.getConnection(), project, nodeTagManager);
        try {
            while (resultSet.next()) {
                int viewId = resultSet.getInt("view_id");
                String name = PostgreSQLHelpers.readString(resultSet, "name");
                String description = PostgreSQLHelpers.readString(resultSet, "description");
                Timestamp creationDate = resultSet.getTimestamp("creation_date");
                Timestamp modificationDate = resultSet.getTimestamp("modification_date");
                boolean starState = resultSet.getBoolean("stared");
                int nodeCount = resultSet.getInt("bbcount");
                int edgeCount = resultSet.getInt("edgecount");
                HashSet<CTag> viewTags = tags.containsKey(viewId) ? tags.get(viewId) : new HashSet<CTag>();
                HashSet<CTag> nodeTags = nodeTagMap.containsKey(viewId) ? nodeTagMap.get(viewId) : new HashSet<CTag>();
                CProjectViewGenerator generator2 = new CProjectViewGenerator(provider, project);
                views.add(generator2.generate(viewId, name, description, viewType, graphType, creationDate, modificationDate, nodeCount, edgeCount, viewTags, nodeTags, starState));
            }
            List<CView> list = views;
            return list;
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ImmutableBiMap<INaviView, INaviFunction> loadViewFunctionMapping(AbstractSQLProvider provider, List<IFlowgraphView> flowgraphs, List<INaviFunction> functions, CModule module) throws CouldntLoadDataException {
        PostgreSQLViewsLoader.checkArguments(provider, module, flowgraphs, functions);
        HashMap<Integer, IFlowgraphView> viewmap = new HashMap<Integer, IFlowgraphView>();
        for (IFlowgraphView iFlowgraphView : flowgraphs) {
            viewmap.put(iFlowgraphView.getConfiguration().getId(), iFlowgraphView);
        }
        HashMap<IAddress, INaviFunction> functionMap = new HashMap<IAddress, INaviFunction>();
        for (INaviFunction function : functions) {
            functionMap.put(function.getAddress(), function);
        }
        CConnection cConnection = provider.getConnection();
        String string2 = String.valueOf("SELECT view_id, function FROM bn_function_views WHERE module_id = ");
        int n2 = module.getConfiguration().getId();
        String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n2).toString();
        HashMap<INaviView, INaviFunction> viewFunctionMap = new HashMap<INaviView, INaviFunction>();
        try {
            try (ResultSet resultSet = cConnection.executeQuery(query, true);){
                while (resultSet.next()) {
                    INaviView view = (INaviView)viewmap.get(resultSet.getInt("view_id"));
                    INaviFunction function = (INaviFunction)functionMap.get(PostgreSQLHelpers.loadAddress(resultSet, "function"));
                    if (view == null || function == null) continue;
                    viewFunctionMap.put(view, function);
                }
            }
            return ((ImmutableBiMap.Builder)new ImmutableBiMap.Builder().putAll(viewFunctionMap)).build();
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }
}

