/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLEdgeLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLNodeLoader;
import com.google.security.zynamics.binnavi.Database.cache.EdgeCache;
import com.google.security.zynamics.binnavi.Database.cache.NodeCache;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.types.graphs.MutableDirectedGraph;
import java.sql.SQLException;
import java.util.List;

public final class PostgreSQLViewLoader {
    private PostgreSQLViewLoader() {
    }

    private static void checkArguments(AbstractSQLProvider provider, INaviView view, List<INaviModule> modules, CTagManager nodeTagManager) {
        Preconditions.checkNotNull(provider, "IE00619: Provider argument can not be null");
        Preconditions.checkNotNull(view, "IE00620: View argument can not be null");
        Preconditions.checkArgument(view.inSameDatabase(provider), "IE00621: View is not part of this database");
        Preconditions.checkNotNull(modules, "IE00622: Modules argument can not be null");
        for (INaviModule module : modules) {
            Preconditions.checkNotNull(module, "IE00623: Modules list contains a null element");
            Preconditions.checkArgument(module.inSameDatabase(provider), "IE00624: Module is not part of this database");
        }
        Preconditions.checkNotNull(nodeTagManager, "IE00625: Node tag manager argument can not be null");
        Preconditions.checkArgument(nodeTagManager.inSameDatabase(provider), "IE00626: Node tag manager is not part of this database");
    }

    public static MutableDirectedGraph<INaviViewNode, INaviEdge> loadView(AbstractSQLProvider provider, INaviView view, List<INaviModule> list, CTagManager nodeTagManager) throws CouldntLoadDataException, CPartialLoadException {
        PostgreSQLViewLoader.checkArguments(provider, view, list, nodeTagManager);
        try {
            List<INaviViewNode> nodes = PostgreSQLNodeLoader.loadNodes(provider, view, list, nodeTagManager);
            NodeCache.get(provider).addNodes(nodes);
            List<INaviEdge> edges = PostgreSQLEdgeLoader.loadEdges(provider, view, nodes);
            EdgeCache.get(provider).addEdges(edges);
            return new MutableDirectedGraph<INaviViewNode, INaviEdge>(nodes, edges);
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }
}

