/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLProjectViewsLoader;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PostgreSQLProjectMixedGraphsLoader
extends PostgreSQLProjectViewsLoader {
    private PostgreSQLProjectMixedGraphsLoader() {
    }

    public static List<INaviView> loadMixedgraphs(AbstractSQLProvider provider, CProject project, CTagManager viewTagManager, CTagManager nodeTagManager) throws CouldntLoadDataException {
        PostgreSQLProjectMixedGraphsLoader.checkArguments((SQLProvider)provider, project, viewTagManager);
        String query = "SELECT * FROM load_module_mixed_graph(?)";
        try {
            CConnection connection = provider.getConnection();
            PreparedStatement statement = connection.getConnection().prepareStatement("SELECT * FROM load_module_mixed_graph(?)");
            statement.setInt(1, project.getConfiguration().getId());
            ResultSet resultSet = statement.executeQuery();
            Map<Integer, Set<CTag>> tags = PostgreSQLProjectMixedGraphsLoader.loadTags(connection, project, viewTagManager);
            return new ArrayList<INaviView>(PostgreSQLProjectMixedGraphsLoader.processQueryResults(resultSet, project, tags, (ITagManager)nodeTagManager, (SQLProvider)provider, new ArrayList<CView>(), ViewType.NonNative, GraphType.MIXED_GRAPH));
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }
}

