/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders.PostgreSQLModuleViewsLoader;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.Tagging.ITagManager;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.ImmutableNaviViewConfiguration;
import com.google.security.zynamics.zylib.disassembly.GraphType;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public final class PostgreSQLModuleFlowgraphsLoader
extends PostgreSQLModuleViewsLoader {
    private PostgreSQLModuleFlowgraphsLoader() {
    }

    private static ImmutableList<IFlowgraphView> loadModuleFlowgraphs(AbstractSQLProvider provider, CModule module, CTagManager viewTagManager, CTagManager nodeTagManager, ViewType viewType) throws CouldntLoadDataException {
        PostgreSQLModuleFlowgraphsLoader.checkArguments(provider, module, viewTagManager);
        String query = " SELECT * FROM load_module_flow_graphs(?, ?) ";
        CConnection connection = provider.getConnection();
        try {
            PreparedStatement statement = connection.getConnection().prepareStatement(" SELECT * FROM load_module_flow_graphs(?, ?) ");
            statement.setInt(1, module.getConfiguration().getId());
            statement.setObject(2, (Object)(viewType == ViewType.Native ? "native" : "non-native"), 1111);
            ResultSet resultSet = statement.executeQuery();
            Map<Integer, Set<CTag>> tags = PostgreSQLModuleFlowgraphsLoader.loadTags(connection, module, viewTagManager);
            return ((ImmutableList.Builder)new ImmutableList.Builder().addAll(PostgreSQLModuleFlowgraphsLoader.processQueryResults(resultSet, module, tags, (ITagManager)nodeTagManager, (SQLProvider)provider, new ArrayList<CView>(), viewType, GraphType.FLOWGRAPH))).build();
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public static ImmutableList<IFlowgraphView> loadFlowgraphs(AbstractSQLProvider provider, CModule module, CTagManager viewTagManager, CTagManager nodeTagManager) throws CouldntLoadDataException {
        return PostgreSQLModuleFlowgraphsLoader.loadModuleFlowgraphs(provider, module, viewTagManager, nodeTagManager, ViewType.NonNative);
    }

    public static ImmutableList<IFlowgraphView> loadNativeFlowgraphs(AbstractSQLProvider provider, CModule module, CTagManager viewTagManager, CTagManager nodeTagManager) throws CouldntLoadDataException {
        return PostgreSQLModuleFlowgraphsLoader.loadModuleFlowgraphs(provider, module, viewTagManager, nodeTagManager, ViewType.Native);
    }

    public static ImmutableNaviViewConfiguration loadFlowGraphInformation(SQLProvider provider, INaviModule module, Integer viewId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "IE02275: provider argument can not be null");
        Preconditions.checkNotNull(module, "IE02394: module argument can not be null");
        Preconditions.checkNotNull(viewId, "IE02419: viewId argument can not be null");
        CConnection connection = provider.getConnection();
        String query = " SELECT * FROM load_module_flowgraph_information(?,?) ";
        try {
            PreparedStatement statement = connection.getConnection().prepareStatement(" SELECT * FROM load_module_flowgraph_information(?,?) ");
            statement.setInt(1, module.getConfiguration().getId());
            statement.setInt(2, viewId);
            ResultSet resultSet = statement.executeQuery();
            if (resultSet.next()) {
                int databaseViewId = resultSet.getInt("view_id");
                String name = PostgreSQLHelpers.readString(resultSet, "name");
                String description = PostgreSQLHelpers.readString(resultSet, "description");
                ViewType viewType = resultSet.getString("type").equalsIgnoreCase("native") ? ViewType.Native : ViewType.NonNative;
                Timestamp creationDate = resultSet.getTimestamp("creation_date");
                Timestamp modificationDate = resultSet.getTimestamp("modification_date");
                boolean isStared = resultSet.getBoolean("stared");
                int nodeCount = resultSet.getInt("bbcount");
                int edgeCount = resultSet.getInt("edgecount");
                ImmutableNaviViewConfiguration viewConfiguration = new ImmutableNaviViewConfiguration(databaseViewId, name, description, viewType, creationDate, modificationDate, isStared, nodeCount, edgeCount);
                return viewConfiguration;
            }
            return null;
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }
}

