/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import java.awt.Color;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class PostgreSQLGroupNodeLoader {
    private PostgreSQLGroupNodeLoader() {
    }

    public static void load(AbstractSQLProvider provider, INaviView view, List<INaviViewNode> nodes) throws SQLException, CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "IE02513: provider argument can not be null");
        Preconditions.checkNotNull(view, "IE02514: view argument can not be null");
        Preconditions.checkNotNull(nodes, "IE02515: nodes argument can not be null");
        HashMap<Integer, CGroupNode> commentIdToGroupNode = new HashMap<Integer, CGroupNode>();
        String string2 = String.valueOf("SELECT id, comment_id , collapsed, x, y, width, height, color, selected, visible  FROM bn_nodes JOIN bn_group_nodes ON id = node_id WHERE view_id = ");
        int n2 = view.getConfiguration().getId();
        String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n2).toString();
        try (ResultSet resultSet = provider.getConnection().executeQuery(query, true);){
            while (resultSet.next()) {
                int nodeId = resultSet.getInt("id");
                Integer commentId = resultSet.getInt("comment_id");
                if (resultSet.wasNull()) {
                    commentId = null;
                }
                boolean collapsed = resultSet.getBoolean("collapsed");
                double posX = resultSet.getDouble("x");
                double posY = resultSet.getDouble("y");
                double width = resultSet.getDouble("width");
                double height = resultSet.getDouble("height");
                Color color = new Color(resultSet.getInt("color"));
                boolean selected = resultSet.getBoolean("selected");
                boolean visible = resultSet.getBoolean("visible");
                CGroupNode groupNode = new CGroupNode(nodeId, posX, posY, width, height, color, selected, visible, new HashSet<CTag>(), null, collapsed, provider);
                if (commentId != null) {
                    commentIdToGroupNode.put(commentId, groupNode);
                }
                nodes.add(groupNode);
            }
            if (!commentIdToGroupNode.isEmpty()) {
                HashMap<Integer, ArrayList<IComment>> commentIdsToComments = PostgreSQLCommentFunctions.loadMultipleCommentsById(provider, commentIdToGroupNode.keySet());
                for (Map.Entry<Integer, ArrayList<IComment>> commentIdToComment : commentIdsToComments.entrySet()) {
                    ((INaviGroupNode)commentIdToGroupNode.get(commentIdToComment.getKey())).initializeComment((List<IComment>)commentIdToComment.getValue());
                }
            }
        }
    }

    public static void setupGroupNodes(CConnection connection, INaviView view, List<INaviViewNode> nodes) throws SQLException {
        String string2 = String.valueOf("SELECT id, parent_id FROM bn_nodes WHERE view_id = ");
        int n2 = view.getConfiguration().getId();
        String query = new StringBuilder(23 + String.valueOf(string2).length()).append(string2).append(n2).append(" ORDER BY id").toString();
        int counter = 0;
        int firstId = -1;
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            while (resultSet.next()) {
                if (firstId == -1) {
                    firstId = resultSet.getInt("id");
                }
                int parentId = resultSet.getInt("parent_id");
                if (!resultSet.wasNull()) {
                    INaviViewNode node = nodes.get(counter);
                    INaviViewNode parent = nodes.get(parentId - firstId);
                    ((CGroupNode)parent).addElement(node);
                }
                ++counter;
            }
        }
    }
}

