/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.CFunction;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.IFlowgraphView;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.ViewManager;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PostgreSQLFunctionsLoader {
    private PostgreSQLFunctionsLoader() {
    }

    private static void checkArguments(SQLProvider provider, INaviModule module) {
        Preconditions.checkNotNull(provider, "IE00466: Provider argument can not be null");
        Preconditions.checkNotNull(module, "IE00467: Module can not be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE00468: Module is not part of this database");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<INaviFunction> parseFunctionInformation(ResultSet resultSet, SQLProvider provider, INaviModule module) throws SQLException, CouldntLoadDataException {
        ArrayList<INaviFunction> functions = Lists.newArrayList();
        HashMap<Integer, CFunction> commentIdToFunction = new HashMap<Integer, CFunction>();
        try {
            while (resultSet.next()) {
                BaseType stackFrame;
                IAddress address = PostgreSQLHelpers.loadAddress(resultSet, "address");
                String name = resultSet.getString("name");
                String originalName = resultSet.getString("original_name");
                Integer globalCommentId = resultSet.getInt("global_comment");
                if (resultSet.wasNull()) {
                    globalCommentId = null;
                }
                String description = resultSet.getString("description");
                FunctionType type = FunctionType.valueOf(resultSet.getString("type").toUpperCase());
                String parentModuleName = resultSet.getString("parent_module_name");
                int parentModuleId = resultSet.getInt("parent_module_id");
                IAddress parentModuleFunction = resultSet.wasNull() ? null : PostgreSQLHelpers.loadAddress(resultSet, "parent_module_function");
                Integer nodeCount = resultSet.getInt("bbcount");
                Integer edgeCount = resultSet.getInt("edgeCount");
                Integer indegree = resultSet.getInt("incount");
                Integer outdegree = resultSet.getInt("outcount");
                Integer stackFrameId = resultSet.getInt("stack_frame");
                if (resultSet.wasNull()) {
                    stackFrameId = null;
                }
                Integer prototypeId = resultSet.getInt("prototype");
                if (resultSet.wasNull()) {
                    prototypeId = null;
                }
                INaviView view = ViewManager.get(provider).getView(resultSet.getInt("view_id"));
                BaseType baseType = stackFrame = stackFrameId == null ? null : module.getTypeManager().getBaseType(stackFrameId);
                if (stackFrameId != null) {
                    module.getTypeManager().setStackFrame(stackFrame);
                }
                BaseType prototype = prototypeId == null ? null : module.getTypeManager().getBaseType(prototypeId);
                CFunction function = new CFunction(module, view, address, name, originalName, description, indegree, outdegree, nodeCount, edgeCount, type, parentModuleName, parentModuleId, parentModuleFunction, stackFrame, prototype, provider);
                if (globalCommentId != null) {
                    commentIdToFunction.put(globalCommentId, function);
                }
                functions.add(function);
            }
        }
        finally {
            resultSet.close();
        }
        if (!commentIdToFunction.isEmpty()) {
            HashMap<Integer, ArrayList<IComment>> commentIdToComments = PostgreSQLCommentFunctions.loadMultipleCommentsById(provider, commentIdToFunction.keySet());
            for (Map.Entry<Integer, ArrayList<IComment>> commentIdToComment : commentIdToComments.entrySet()) {
                CommentManager.get(provider).initializeGlobalFunctionComment((INaviFunction)commentIdToFunction.get(commentIdToComment.getKey()), (List<IComment>)commentIdToComment.getValue());
            }
        }
        return functions;
    }

    public static INaviFunction loadFunction(SQLProvider provider, INaviModule module, IAddress address) throws CouldntLoadDataException {
        PostgreSQLFunctionsLoader.checkArguments(provider, module);
        String query = " SELECT * FROM load_function_information(?,?) ";
        try {
            PreparedStatement statement = provider.getConnection().getConnection().prepareStatement(" SELECT * FROM load_function_information(?,?) ");
            statement.setInt(1, module.getConfiguration().getId());
            statement.setObject(2, (Object)address.toBigInteger(), -5);
            ResultSet resultSet = statement.executeQuery();
            return Iterables.getFirst(PostgreSQLFunctionsLoader.parseFunctionInformation(resultSet, provider, module), null);
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public static List<INaviFunction> loadFunctions(SQLProvider provider, INaviModule module, List<IFlowgraphView> views) throws CouldntLoadDataException {
        PostgreSQLFunctionsLoader.checkArguments(provider, module);
        String query = " SELECT * FROM load_function_information(?) ";
        try {
            PreparedStatement statement = provider.getConnection().getConnection().prepareStatement(" SELECT * FROM load_function_information(?) ");
            statement.setInt(1, module.getConfiguration().getId());
            ResultSet resultSet = statement.executeQuery();
            return PostgreSQLFunctionsLoader.parseFunctionInformation(resultSet, provider, module);
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }
}

