/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.Exceptions.CPartialLoadException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.CFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.awt.Color;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class PostgreSQLFunctionNodeLoader {
    private PostgreSQLFunctionNodeLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(AbstractSQLProvider provider, INaviView view, List<INaviViewNode> nodes) throws CPartialLoadException, CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "IE02510: provider argument can not be null");
        Preconditions.checkNotNull(view, "IE02511: view argument can not be null");
        Preconditions.checkNotNull(nodes, "IE02512: nodes argument can not be null");
        String query = "SELECT nodes.view_id, nodes.id, functions.module_id,  function, fnodes.comment_id as local_comment, x, y, width, height,  color, selected, visible FROM bn_nodes AS nodes JOIN bn_function_nodes AS fnodes  ON nodes.id = fnodes.node_id JOIN bn_functions AS functions ON functions.address = fnodes.function  AND functions.module_id = fnodes.module_id  WHERE view_id = ?";
        HashMap<Integer, CFunctionNode> commentIdToFunctionNode = new HashMap<Integer, CFunctionNode>();
        try {
            PreparedStatement statement = provider.getConnection().getConnection().prepareStatement("SELECT nodes.view_id, nodes.id, functions.module_id,  function, fnodes.comment_id as local_comment, x, y, width, height,  color, selected, visible FROM bn_nodes AS nodes JOIN bn_function_nodes AS fnodes  ON nodes.id = fnodes.node_id JOIN bn_functions AS functions ON functions.address = fnodes.function  AND functions.module_id = fnodes.module_id  WHERE view_id = ?");
            statement.setInt(1, view.getConfiguration().getId());
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    int moduleId = resultSet.getInt("module_id");
                    INaviModule module = provider.findModule(moduleId);
                    if (!module.isLoaded()) {
                        try {
                            module.load();
                        }
                        catch (CouldntLoadDataException e2) {
                            throw new CPartialLoadException("E00064: The view could not be loaded because not all modules that form the view are loaded", module);
                        }
                        catch (LoadCancelledException e3) {
                            throw new CPartialLoadException("E00065: The view could not be loaded because not all modules that form the view are loaded", module);
                        }
                    }
                    IAddress address = PostgreSQLHelpers.loadAddress(resultSet, "function");
                    INaviFunction function = module.getContent().getFunctionContainer().getFunction(address);
                    int nodeId = resultSet.getInt("id");
                    Integer commentId = resultSet.getInt("local_comment");
                    if (resultSet.wasNull()) {
                        commentId = null;
                    }
                    double posX = resultSet.getDouble("x");
                    double posY = resultSet.getDouble("y");
                    double width = resultSet.getDouble("width");
                    double height = resultSet.getDouble("height");
                    Color color = new Color(resultSet.getInt("color"));
                    boolean selected = resultSet.getBoolean("selected");
                    boolean visible = resultSet.getBoolean("visible");
                    CFunctionNode functionNode = new CFunctionNode(nodeId, function, posX, posY, width, height, color, selected, visible, null, new HashSet<CTag>(), provider);
                    nodes.add(functionNode);
                    if (commentId == null) continue;
                    commentIdToFunctionNode.put(commentId, functionNode);
                }
            }
            if (!commentIdToFunctionNode.isEmpty()) {
                HashMap<Integer, ArrayList<IComment>> commentIdsToComments = PostgreSQLCommentFunctions.loadMultipleCommentsById(provider, commentIdToFunctionNode.keySet());
                for (Map.Entry<Integer, ArrayList<IComment>> commentIdToComment : commentIdsToComments.entrySet()) {
                    ((INaviFunctionNode)commentIdToFunctionNode.get(commentIdToComment.getKey())).initializeLocalFunctionComment((List<IComment>)commentIdToComment.getValue());
                }
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }
}

