/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.disassembly.CCallgraph;
import com.google.security.zynamics.binnavi.disassembly.CCallgraphEdge;
import com.google.security.zynamics.binnavi.disassembly.CCallgraphNode;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphEdge;
import com.google.security.zynamics.binnavi.disassembly.ICallgraphNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PostgreSQLCallgraphLoader {
    private PostgreSQLCallgraphLoader() {
    }

    private static void checkArguments(AbstractSQLProvider provider, CModule module, List<INaviFunction> functions) {
        Preconditions.checkNotNull(provider, "IE00404: Provider argument can not be null");
        Preconditions.checkNotNull(module, "IE00405: Module argument can not be null");
        Preconditions.checkArgument(module.inSameDatabase(module), "IE00406: Module is not part of this database");
        Preconditions.checkNotNull(functions, "IE00407: Functions argument can not be null");
        for (INaviFunction function : functions) {
            Preconditions.checkNotNull(function, "IE00408: Function list contains a null-element");
            Preconditions.checkArgument(function.inSameDatabase(module), "IE00409: Function list contains an element that is not part of this database");
        }
    }

    private static Map<IAddress, INaviFunction> getFunctionMap(Iterable<INaviFunction> functions) {
        HashMap<IAddress, INaviFunction> functionMap = new HashMap<IAddress, INaviFunction>();
        for (INaviFunction function : functions) {
            functionMap.put(function.getAddress(), function);
        }
        return functionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ICallgraphEdge> loadEdges(CConnection connection, int callgraphId, Map<Integer, CCallgraphNode> nodeMap) throws SQLException {
        ArrayList<ICallgraphEdge> edges = new ArrayList<ICallgraphEdge>();
        String string2 = String.valueOf("SELECT source_node_id, target_node_id FROM bn_nodes JOIN bn_edges ON bn_nodes.id = bn_edges.source_node_id WHERE view_id = ");
        String edgeQuery = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(callgraphId).toString();
        try (ResultSet edgeResult = connection.executeQuery(edgeQuery, true);){
            while (edgeResult.next()) {
                CCallgraphNode source = nodeMap.get(edgeResult.getInt("source_node_id"));
                CCallgraphNode target = nodeMap.get(edgeResult.getInt("target_node_id"));
                CCallgraphNode.link(source, target);
                edges.add(new CCallgraphEdge(source, target));
            }
        }
        return edges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<List<ICallgraphNode>, Map<Integer, CCallgraphNode>> loadNodes(CConnection connection, int callgraphId, Collection<INaviFunction> functions) throws SQLException {
        Map<IAddress, INaviFunction> functionMap = PostgreSQLCallgraphLoader.getFunctionMap(functions);
        ArrayList<CCallgraphNode> nodes = new ArrayList<CCallgraphNode>();
        String string2 = String.valueOf("SELECT nodes.id, function FROM bn_nodes AS nodes JOIN bn_function_nodes AS function_nodes ON nodes.id = function_nodes.node_id WHERE nodes.view_id = ");
        String nodeQuery = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(callgraphId).toString();
        HashMap<Integer, CCallgraphNode> nodeMap = new HashMap<Integer, CCallgraphNode>();
        try (ResultSet nodeResult = connection.executeQuery(nodeQuery, true);){
            while (nodeResult.next()) {
                int nodeId = nodeResult.getInt("id");
                IAddress functionAddress = PostgreSQLHelpers.loadAddress(nodeResult, "function");
                INaviFunction function = functionMap.get(functionAddress);
                CCallgraphNode cgnode = new CCallgraphNode(function);
                nodeMap.put(nodeId, cgnode);
                nodes.add(cgnode);
            }
        }
        return new Pair<List<ICallgraphNode>, Map<Integer, CCallgraphNode>>(nodes, nodeMap);
    }

    public static CCallgraph loadCallgraph(AbstractSQLProvider provider, CModule module, int callgraphId, List<INaviFunction> functions) throws CouldntLoadDataException {
        PostgreSQLCallgraphLoader.checkArguments(provider, module, functions);
        CConnection connection = provider.getConnection();
        try {
            Pair<List<ICallgraphNode>, Map<Integer, CCallgraphNode>> nodeResult = PostgreSQLCallgraphLoader.loadNodes(connection, callgraphId, functions);
            List<ICallgraphEdge> edges = PostgreSQLCallgraphLoader.loadEdges(connection, callgraphId, nodeResult.second());
            return new CCallgraph(nodeResult.first(), edges);
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }
}

