/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Loaders;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PostgreSQLAddressSpaceLoader {
    private PostgreSQLAddressSpaceLoader() {
    }

    private static void checkArguments(AbstractSQLProvider provider, INaviProject project) {
        Preconditions.checkNotNull(provider, "IE00400: Provider argument can not be null");
        Preconditions.checkNotNull(project, "IE00401: Project argument can not be null");
        Preconditions.checkArgument(project.inSameDatabase(provider), "IE00402: Project is not part of this database");
    }

    private static INaviModule findModule(List<INaviModule> list, int moduleId) throws MaybeNullException {
        for (INaviModule module : list) {
            if (module.getConfiguration().getId() != moduleId) continue;
            return module;
        }
        throw new MaybeNullException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<INaviModule, IAddress> loadImageBases(CConnection connection, int addressSpaceId, List<INaviModule> list) throws CouldntLoadDataException {
        HashMap<INaviModule, IAddress> imageBases = new HashMap<INaviModule, IAddress>();
        String string2 = String.valueOf("SELECT module_id, image_base FROM bn_space_modules WHERE address_space_id = ");
        String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(addressSpaceId).toString();
        try {
            try (ResultSet resultSet = connection.executeQuery(query, true);){
                while (resultSet.next()) {
                    try {
                        INaviModule module = PostgreSQLAddressSpaceLoader.findModule(list, resultSet.getInt("module_id"));
                        imageBases.put(module, PostgreSQLHelpers.loadAddress(resultSet, "image_base"));
                    }
                    catch (MaybeNullException exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
            return imageBases;
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CAddressSpace> loadAddressSpaces(AbstractSQLProvider provider, INaviProject project, DebuggerTemplateManager debuggerManager, List<INaviModule> list) throws CouldntLoadDataException {
        ArrayList<CAddressSpace> arrayList;
        PostgreSQLAddressSpaceLoader.checkArguments(provider, project);
        Preconditions.checkNotNull(debuggerManager, "IE01543: Debugger provider argument can not be null");
        Preconditions.checkNotNull(list, "IE01545: Modules argument can not be null");
        NaviLogger.info("Loading address spaces of project %s", project.getConfiguration().getName());
        CConnection connection = provider.getConnection();
        ArrayList<CAddressSpace> addressSpaces = new ArrayList<CAddressSpace>();
        String string2 = String.valueOf("SELECT id, name, description, creation_date, modification_date, debugger_id  FROM bn_address_spaces WHERE project_id = ");
        int n2 = project.getConfiguration().getId();
        String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n2).toString();
        ResultSet resultSet = connection.executeQuery(query, true);
        try {
            while (resultSet.next()) {
                int addressSpaceId = resultSet.getInt("id");
                Map<INaviModule, IAddress> imageBases = PostgreSQLAddressSpaceLoader.loadImageBases(connection, addressSpaceId, list);
                String name = PostgreSQLHelpers.readString(resultSet, "name");
                String description = PostgreSQLHelpers.readString(resultSet, "description");
                Timestamp creationDate = resultSet.getTimestamp("creation_date");
                Timestamp modificationDate = resultSet.getTimestamp("modification_date");
                DebuggerTemplate debuggerDescription = debuggerManager.findDebugger(resultSet.getInt("debugger_id"));
                addressSpaces.add(new CAddressSpace(addressSpaceId, name, description, creationDate, modificationDate, imageBases, debuggerDescription, provider, project));
            }
            arrayList = addressSpaces;
        }
        catch (Throwable throwable) {
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException e2) {
                throw new CouldntLoadDataException(e2);
            }
        }
        resultSet.close();
        return arrayList;
    }
}

