/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.ViewType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PostgreSQLViewFunctions {
    private PostgreSQLViewFunctions() {
    }

    private static void checkArguments(AbstractSQLProvider provider, INaviView view) {
        Preconditions.checkNotNull(provider, "IE00611: Provider argument can not be null");
        Preconditions.checkNotNull(view, "IE00612: View argument can not be null");
        Preconditions.checkArgument(view.inSameDatabase(provider), "IE00613: View is not part of this database");
    }

    public static void deleteView(AbstractSQLProvider provider, INaviView view) throws CouldntDeleteException {
        PostgreSQLViewFunctions.checkArguments(provider, view);
        Preconditions.checkArgument(view.getType() != ViewType.Native, "IE00614: Native views can not be deleted");
        CConnection connection = provider.getConnection();
        NaviLogger.info("Deleting view %s", view.getName());
        int viewId = view.getConfiguration().getId();
        if (viewId != -1) {
            try {
                PostgreSQLHelpers.beginTransaction(connection);
                PostgreSQLHelpers.deleteById(connection, "bn_views", viewId);
                PostgreSQLHelpers.deleteByColumnValue(connection, "bn_nodes", "view_id", viewId);
                PostgreSQLHelpers.deleteByColumnValue(connection, "bn_traces", "view_id", viewId);
                PostgreSQLHelpers.endTransaction(connection);
            }
            catch (SQLException exception) {
                throw new CouldntDeleteException(exception);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<INaviView> getDerivedViews(AbstractSQLProvider provider, INaviView view) throws CouldntLoadDataException {
        PostgreSQLViewFunctions.checkArguments(provider, view);
        ArrayList<INaviView> views = new ArrayList<INaviView>();
        if (view.getConfiguration().getModule() == null) {
            return views;
        }
        String query = "SELECT * FROM get_derived_views(?)";
        try (PreparedStatement statement = provider.getConnection().getConnection().prepareStatement("SELECT * FROM get_derived_views(?)");){
            List<INaviView> moduleViews = view.getConfiguration().getModule().getContent().getViewContainer().getViews();
            statement.setInt(1, view.getConfiguration().getId());
            ResultSet resultSet = statement.executeQuery();
            if (resultSet == null) {
                ArrayList<INaviView> arrayList = views;
                return arrayList;
            }
            block14: while (resultSet.next()) {
                int viewId = resultSet.getInt(1);
                if (viewId == view.getConfiguration().getId()) continue;
                for (INaviView moduleView : moduleViews) {
                    if (moduleView.getConfiguration().getId() != viewId) continue;
                    views.add(moduleView);
                    continue block14;
                }
            }
            ArrayList<INaviView> arrayList = views;
            return arrayList;
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    public static Date getModificationDate(AbstractSQLProvider provider, INaviView view) throws CouldntLoadDataException {
        PostgreSQLViewFunctions.checkArguments(provider, view);
        CConnection connection = provider.getConnection();
        return PostgreSQLHelpers.getModificationDate(connection, "bn_views", view.getConfiguration().getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> loadSettings(AbstractSQLProvider provider, CView view) throws CouldntLoadDataException {
        PostgreSQLViewFunctions.checkArguments(provider, view);
        CConnection connection = provider.getConnection();
        String string2 = String.valueOf("SELECT name, value FROM bn_view_settings WHERE view_id = ");
        int n2 = view.getConfiguration().getId();
        String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n2).toString();
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            HashMap<String, String> settings = new HashMap<String, String>();
            while (resultSet.next()) {
                settings.put(PostgreSQLHelpers.readString(resultSet, "name"), PostgreSQLHelpers.readString(resultSet, "value"));
            }
            HashMap<String, String> hashMap = settings;
            return hashMap;
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public static void saveSettings(AbstractSQLProvider provider, CView view, Map<String, String> settings) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.checkArguments(provider, view);
        Preconditions.checkNotNull(settings, "IE02414: settings argument can not be null");
        if (settings.isEmpty()) {
            return;
        }
        CConnection connection = provider.getConnection();
        StringBuilder deleteQuery = new StringBuilder("DELETE FROM bn_view_settings WHERE ");
        StringBuilder insertQuery = new StringBuilder("INSERT INTO bn_view_settings VALUES");
        boolean first = true;
        for (Map.Entry<String, String> pair : settings.entrySet()) {
            String value = pair.getValue();
            String key = pair.getKey();
            if (value == null || key == null) continue;
            if (!first) {
                deleteQuery.append("OR");
                insertQuery.append(',');
            }
            int n2 = view.getConfiguration().getId();
            deleteQuery.append(new StringBuilder(39 + String.valueOf(key).length()).append(" (view_id = ").append(n2).append(" AND name = '").append(key).append("') ").toString());
            n2 = view.getConfiguration().getId();
            insertQuery.append(new StringBuilder(24 + String.valueOf(key).length() + String.valueOf(value).length()).append(" (").append(n2).append(", '").append(key).append("', '").append(value).append("' ) ").toString());
            first = false;
        }
        try {
            connection.executeUpdate(deleteQuery.toString(), true);
            connection.executeUpdate(insertQuery.toString(), true);
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException("E00115: Could not update settings in bn_view_settings");
        }
    }

    public static void setDescription(AbstractSQLProvider provider, INaviView view, String description) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.checkArguments(provider, view);
        Preconditions.checkNotNull(description, "IE00714: Description argument can not be null");
        PostgreSQLHelpers.setDescription(provider.getConnection(), view.getConfiguration().getId(), description, "bn_views");
    }

    public static void setName(AbstractSQLProvider provider, INaviView view, String name) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.checkArguments(provider, view);
        Preconditions.checkNotNull(name, "IE00716: Name argument can not be null");
        PostgreSQLHelpers.setName(provider.getConnection(), view.getConfiguration().getId(), name, "bn_views");
    }

    public static void starView(AbstractSQLProvider provider, INaviView view, boolean isStared) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.checkArguments(provider, view);
        try {
            String string2 = String.valueOf("UPDATE bn_views SET stared = ");
            int n2 = view.getConfiguration().getId();
            provider.getConnection().executeUpdate(new StringBuilder(28 + String.valueOf(string2).length()).append(string2).append(isStared).append(" WHERE id = ").append(n2).toString(), true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void tagView(AbstractSQLProvider provider, INaviView view, CTag tag) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.checkArguments(provider, view);
        Preconditions.checkNotNull(tag, "IE00615: Tag argument can not be null");
        Preconditions.checkArgument(tag.inSameDatabase(provider), "IE00616: Tag is not part of this database");
        String query = String.format("insert into %s(view_id, tag_id) values(%d, %d)", "bn_tagged_views", view.getConfiguration().getId(), tag.getId());
        CConnection connection = provider.getConnection();
        try {
            connection.executeUpdate(query, true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void untagView(AbstractSQLProvider provider, INaviView view, CTag tag) throws CouldntSaveDataException {
        PostgreSQLViewFunctions.checkArguments(provider, view);
        Preconditions.checkNotNull(tag, "IE00617: Tag argument can not be null");
        Preconditions.checkArgument(tag.inSameDatabase(provider), "IE00618: Tag is not part of this database");
        String query = String.format("delete from %s where view_id = %d and tag_id = %d", "bn_tagged_views", view.getConfiguration().getId(), tag.getId());
        try {
            provider.getConnection().executeUpdate(query, true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }
}

