/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.Tagging.TagType;
import com.google.security.zynamics.zylib.strings.Commafier;
import com.google.security.zynamics.zylib.types.trees.DepthFirstSorter;
import com.google.security.zynamics.zylib.types.trees.ITreeNode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public final class PostgreSQLTagFunctions {
    private PostgreSQLTagFunctions() {
    }

    private static void checkArguments(AbstractSQLProvider provider, CTag tag, TagType type) {
        PostgreSQLTagFunctions.checkArguments(provider, tag);
        Preconditions.checkNotNull(type, "IE00549: Type argument can not be null");
        Preconditions.checkArgument(tag.getType() == type, "IE00550: Type of the node is different from the type of the given node");
    }

    private static void checkArguments(AbstractSQLProvider provider, ITreeNode<CTag> tag) {
        Preconditions.checkNotNull(provider, "IE00551: Provider argument can not be null");
        Preconditions.checkNotNull(tag, "IE00552: Tag argument can not be null");
        Preconditions.checkArgument(tag.getObject().inSameDatabase(provider), "IE00553: Tag is not part of this database");
    }

    static void checkArguments(AbstractSQLProvider provider, CTag tag) {
        Preconditions.checkNotNull(provider, "IE00546: Provider argument can not be null");
        Preconditions.checkNotNull(tag, "IE00547: Tag argument can not be null");
        Preconditions.checkArgument(tag.inSameDatabase(provider), "IE00548: Tag is not part of this database");
    }

    static void checkArguments(AbstractSQLProvider provider, ITreeNode<CTag> tag, TagType type) {
        PostgreSQLTagFunctions.checkArguments(provider, tag);
        Preconditions.checkNotNull(type, "IE00554: Type argument can not be null");
        Preconditions.checkArgument(tag.getObject().getType() == type, "IE00555: Type of the node is different from the type of the given node");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CTag createTag(AbstractSQLProvider provider, CTag parent, String name, String description, TagType type) throws CouldntSaveDataException {
        PostgreSQLTagFunctions.checkArguments(provider, parent, type);
        Preconditions.checkNotNull(name, "IE00556: Name argument can not be null");
        Preconditions.checkNotNull(description, "IE00557: Description argument can not be null");
        CConnection connection = provider.getConnection();
        String query = "insert into bn_tags(parent_id, name, description, type) values(?, ?, ?, ?::tag_type) returning id";
        try (PreparedStatement statement = connection.getConnection().prepareStatement("insert into bn_tags(parent_id, name, description, type) values(?, ?, ?, ?::tag_type) returning id", 1004, 1007);){
            if (parent.getId() == 0) {
                statement.setNull(1, 4);
            } else {
                statement.setInt(1, parent.getId());
            }
            statement.setString(2, name);
            statement.setString(3, description);
            statement.setString(4, PostgreSQLTagFunctions.tagToString(type));
            Integer id = null;
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    if (!resultSet.isFirst()) continue;
                    id = resultSet.getInt(1);
                }
            }
            if (id != null) {
                CTag cTag = new CTag(id, name, description, type, provider);
                return cTag;
            }
            throw new IllegalStateException("IE02141: Error id can not be null");
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void deleteTag(AbstractSQLProvider provider, ITreeNode<CTag> tag) throws CouldntDeleteException {
        PostgreSQLTagFunctions.checkArguments(provider, tag);
        Preconditions.checkNotNull(tag.getParent(), "IE00558: Can not delete the root tag");
        CConnection connection = provider.getConnection();
        try {
            ITreeNode<CTag> parent = tag.getParent();
            String parentId = parent.getObject().getId() == 0 ? "null" : String.valueOf(parent.getObject().getId());
            String query_1 = String.format("UPDATE %s SET parent_id = %s WHERE parent_id = ?", "bn_tags", parentId);
            try (PreparedStatement statement_1 = connection.getConnection().prepareStatement(query_1);){
                statement_1.setInt(1, tag.getObject().getId());
                statement_1.executeUpdate();
            }
            String query_2 = String.format("DELETE FROM %s WHERE id = ?", "bn_tags");
            try (PreparedStatement statement_2 = connection.getConnection().prepareStatement(query_2);){
                statement_2.setInt(1, tag.getObject().getId());
                statement_2.executeUpdate();
            }
        }
        catch (SQLException e2) {
            throw new CouldntDeleteException(e2);
        }
    }

    public static void deleteTagSubtree(AbstractSQLProvider provider, ITreeNode<CTag> tag) throws CouldntDeleteException {
        PostgreSQLTagFunctions.checkArguments(provider, tag);
        Preconditions.checkNotNull(tag.getParent(), "IE00559: Can not delete the root tag");
        CConnection connection = provider.getConnection();
        try {
            StringBuilder query = new StringBuilder(String.format("delete from %s where id = %d", "bn_tags", tag.getObject().getId()));
            ArrayList<Integer> idsToDelete = new ArrayList<Integer>();
            for (ITreeNode<CTag> child : DepthFirstSorter.getSortedList(tag)) {
                idsToDelete.add(child.getObject().getId());
                int n2 = tag.getObject().getId();
                query.append(new StringBuilder(20).append(" or id = ").append(n2).toString());
            }
            connection.executeUpdate(query.toString(), true);
        }
        catch (SQLException e2) {
            throw new CouldntDeleteException(e2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CTag insertTag(AbstractSQLProvider provider, ITreeNode<CTag> parent, String name, String description, TagType type) throws CouldntSaveDataException {
        PostgreSQLTagFunctions.checkArguments(provider, parent, type);
        Preconditions.checkNotNull(name, "IE00563: Name argument can not be null");
        Preconditions.checkNotNull(description, "IE00564: Description argument can not be null");
        CConnection connection = provider.getConnection();
        String query = String.format("update %s set parent_id = ? where parent_id = ? and id <> ?", "bn_tags");
        try (PreparedStatement statement = connection.getConnection().prepareStatement(query);){
            CTag tag = PostgreSQLTagFunctions.createTag(provider, parent.getObject(), name, description, type);
            statement.setInt(1, tag.getId());
            statement.setInt(2, parent.getObject().getId());
            statement.setInt(3, tag.getId());
            statement.executeUpdate();
            CTag cTag = tag;
            return cTag;
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void moveTag(AbstractSQLProvider provider, ITreeNode<CTag> newParentNode, ITreeNode<CTag> movedNode, TagType type) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE02083: Provider argument can not be null");
        Preconditions.checkNotNull(newParentNode, "IE02190: Parent argument can not be null");
        Preconditions.checkNotNull(movedNode, "IE02191: Child argument can not be null");
        ArrayList<Integer> childIds = new ArrayList<Integer>();
        for (ITreeNode<CTag> childChild : movedNode.getChildren()) {
            childIds.add(childChild.getObject().getId());
        }
        try {
            String string2;
            String childParentId;
            String string3 = childParentId = movedNode.getParent().getObject().getId() == 0 ? "null" : String.valueOf(movedNode.getParent().getObject().getId());
            if (!childIds.isEmpty()) {
                string2 = String.valueOf("update bn_tags set parent_id = ");
                String string4 = String.valueOf(Commafier.commafy(childIds));
                String string5 = PostgreSQLTagFunctions.tagToString(type);
                provider.getConnection().executeUpdate(new StringBuilder(29 + String.valueOf(string2).length() + String.valueOf(childParentId).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string2).append(childParentId).append(" where id in (").append(string4).append(") and type = '").append(string5).append("'").toString(), true);
            }
            string2 = String.valueOf("update bn_tags set parent_id = ");
            int n2 = newParentNode.getObject().getId();
            int n3 = movedNode.getObject().getId();
            String string6 = PostgreSQLTagFunctions.tagToString(type);
            provider.getConnection().executeUpdate(new StringBuilder(48 + String.valueOf(string2).length() + String.valueOf(string6).length()).append(string2).append(n2).append(" where id = ").append(n3).append(" and type = '").append(string6).append("'").toString(), true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void setDescription(AbstractSQLProvider provider, CTag tag, String description) throws CouldntSaveDataException {
        PostgreSQLTagFunctions.checkArguments(provider, tag);
        Preconditions.checkNotNull(description, "IE00713: Description argument can not be null");
        CConnection connection = provider.getConnection();
        String query = "update bn_tags set description = ? where id = ?";
        try (PreparedStatement statement = connection.getConnection().prepareStatement("update bn_tags set description = ? where id = ?");){
            statement.setString(1, description);
            statement.setInt(2, tag.getId());
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void setName(AbstractSQLProvider provider, CTag tag, String name) throws CouldntSaveDataException {
        PostgreSQLTagFunctions.checkArguments(provider, tag);
        Preconditions.checkNotNull(name, "IE00565: Name argument can not be null");
        CConnection connection = provider.getConnection();
        String query = "update bn_tags set name = ? where id = ?";
        try (PreparedStatement statement = connection.getConnection().prepareStatement("update bn_tags set name = ? where id = ?");){
            statement.setString(1, name);
            statement.setInt(2, tag.getId());
            statement.executeUpdate();
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static String tagToString(TagType type) {
        if (type == TagType.VIEW_TAG) {
            return "view_tag";
        }
        if (type == TagType.NODE_TAG) {
            return "node_tag";
        }
        throw new IllegalArgumentException("IE00566: Unknown tag type");
    }
}

