/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.disassembly.CommentManager;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.SectionPermission;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class PostgreSQLSectionFunctions {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int createSection(Connection connection, int moduleId, String name, Integer commentId, BigInteger startAddress, BigInteger endAddress, SectionPermission permission, byte[] data) throws CouldntSaveDataException {
        Preconditions.checkNotNull(connection, "Error: connection argument can not be null");
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be greater then zero");
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        Preconditions.checkNotNull(startAddress, "Error: startAddress argument can not be null");
        Preconditions.checkNotNull(endAddress, "Error: endAddress argument can not be null");
        Preconditions.checkNotNull(permission, "Error: permission argument can not be null");
        String query = " { ? = call create_section( ?, ?, ?, ?, ?, ?, ?) } ";
        try (CallableStatement createSectionProcedure = connection.prepareCall(" { ? = call create_section( ?, ?, ?, ?, ?, ?, ?) } ");){
            createSectionProcedure.registerOutParameter(1, 4);
            createSectionProcedure.setInt(2, moduleId);
            createSectionProcedure.setString(3, name);
            if (commentId == null) {
                createSectionProcedure.setNull(4, 4);
            } else {
                createSectionProcedure.setInt(4, (int)commentId);
            }
            createSectionProcedure.setObject(5, (Object)startAddress, -5);
            createSectionProcedure.setObject(6, (Object)endAddress, -5);
            createSectionProcedure.setObject(7, (Object)permission.name(), 1111);
            createSectionProcedure.setBytes(8, data);
            createSectionProcedure.execute();
            int sectionId = createSectionProcedure.getInt(1);
            if (createSectionProcedure.wasNull()) {
                throw new CouldntSaveDataException("Error: Got a section id of null from the database.");
            }
            int n2 = sectionId;
            return n2;
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public static void deleteSection(SQLProvider provider, Section section) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        Preconditions.checkNotNull(section, "Error: section argument can not be null");
        String query = " { call delete_section(?, ?) } ";
        try (CallableStatement procedure = provider.getConnection().getConnection().prepareCall(" { call delete_section(?, ?) } ");){
            procedure.setInt(1, section.getModule().getConfiguration().getId());
            procedure.setInt(2, section.getId());
            procedure.execute();
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public static Map<Section, Integer> loadSections(SQLProvider provider, INaviModule module) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        Preconditions.checkNotNull(module, "Error: module argument can not be null");
        HashMap<Section, Integer> sections = Maps.newHashMap();
        String query = "SELECT * FROM get_sections(?)";
        try (PreparedStatement statement = provider.getConnection().getConnection().prepareStatement("SELECT * FROM get_sections(?)");){
            statement.setInt(1, module.getConfiguration().getId());
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                int id = result.getInt("id");
                String name = result.getString("name");
                Integer commentId = result.getInt("comment_id");
                if (result.wasNull()) {
                    commentId = null;
                }
                CAddress startAddress = new CAddress(result.getLong("start_address"));
                CAddress endAddress = new CAddress(result.getLong("end_address"));
                SectionPermission permission = SectionPermission.valueOf(result.getString("permission"));
                byte[] data = result.getBytes("data");
                sections.put(new Section(id, name, CommentManager.get(provider), module, startAddress, endAddress, permission, data), commentId);
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return sections;
    }

    public static void setSectionName(Connection connection, int moduleId, int sectionId, String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(connection, "Error: connection argument can not be null");
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be greater than zero");
        Preconditions.checkArgument(sectionId >= 0, "Error: section id must be greater or equal than zero");
        Preconditions.checkNotNull(name, "Error: name argument can not be null");
        String query = " { call set_section_name(?, ?, ?) } ";
        try (CallableStatement procedure = connection.prepareCall(" { call set_section_name(?, ?, ?) } ");){
            procedure.setInt(1, moduleId);
            procedure.setInt(2, sectionId);
            procedure.setString(3, name);
            procedure.execute();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Integer appendSectionComment(SQLProvider provider, int moduleId, int sectionId, String commentText, Integer userId) throws CouldntSaveDataException {
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be greater then zero");
        Preconditions.checkArgument(sectionId >= 0, "Error: section id must be greater or equal than zero");
        Preconditions.checkNotNull(commentText, "Error: comment text argument can not be null");
        Preconditions.checkNotNull(userId, "Error: user id argument can not be null");
        CConnection connection = provider.getConnection();
        String function = " { ? = call append_section_comment(?, ?, ?, ?) } ";
        try (CallableStatement appendCommentFunction = connection.getConnection().prepareCall(" { ? = call append_section_comment(?, ?, ?, ?) } ");){
            appendCommentFunction.registerOutParameter(1, 4);
            appendCommentFunction.setInt(2, moduleId);
            appendCommentFunction.setInt(3, sectionId);
            appendCommentFunction.setInt(4, (int)userId);
            appendCommentFunction.setString(5, commentText);
            appendCommentFunction.execute();
            int commentId = appendCommentFunction.getInt(1);
            if (appendCommentFunction.wasNull()) {
                throw new CouldntSaveDataException("Error: Got an comment id of null from the database");
            }
            Integer n2 = commentId;
            return n2;
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public static void deleteSectionComment(SQLProvider provider, int moduleId, int sectionId, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be greater then zero");
        Preconditions.checkArgument(sectionId >= 0, "Error: section id must be greater or equal than zero");
        Preconditions.checkNotNull(commentId, "Error: comment text argument can not be null");
        Preconditions.checkNotNull(userId, "Error: user id argument can not be null");
        String function = " { ? = call delete_section_comment(?, ?, ?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { ? = call delete_section_comment(?, ?, ?, ?) } ");){
            deleteCommentStatement.registerOutParameter(1, 4);
            deleteCommentStatement.setInt(2, moduleId);
            deleteCommentStatement.setInt(3, sectionId);
            deleteCommentStatement.setInt(4, (int)commentId);
            deleteCommentStatement.setInt(5, (int)userId);
            deleteCommentStatement.execute();
            deleteCommentStatement.getInt(1);
            if (deleteCommentStatement.wasNull()) {
                throw new IllegalArgumentException("Error: The comment id returned from the database was null.");
            }
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public static void editSectionComment(SQLProvider provider, int moduleId, Integer commentId, Integer userId, String commentText) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "Error: provider argument can not be null");
        Preconditions.checkArgument(moduleId > 0, "Error: module id must be greater then zero");
        Preconditions.checkNotNull(commentId, "Error: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "Error: userId argument can not be null");
        Preconditions.checkNotNull(commentText, "Error: newComment argument can not be null");
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, commentText);
    }
}

