/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;
import java.sql.SQLException;

public final class PostgreSQLRawModuleFunctions {
    private PostgreSQLRawModuleFunctions() {
    }

    public static void deleteRawModule(AbstractSQLProvider provider, INaviRawModule module) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE00529: Provider argument can not be null");
        Preconditions.checkNotNull(module, "IE00530: Raw module can not be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE00531: Raw module is not part of this database");
        CConnection connection = provider.getConnection();
        NaviLogger.info("Deleting raw module %s", module.getName());
        int moduleId = module.getId();
        try {
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_address_comments", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_address_references", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_basic_block_instructions", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_basic_blocks", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_callgraph", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_control_flow_graphs", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_expression_nodes", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_expression_substitutions", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_expression_tree_nodes", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_expression_trees", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_functions", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_instructions", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_operands", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_sections", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_type_instances", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_types", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_base_types", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_expression_types", moduleId));
            PostgreSQLHelpers.deleteTable(connection, String.format("ex_%d_expression_type_instances", moduleId));
            PostgreSQLHelpers.deleteById(connection, "modules", moduleId);
        }
        catch (SQLException e2) {
            CUtilityFunctions.logException(e2);
        }
    }
}

