/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviTextNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

public final class PostgreSQLNodeFunctions {
    private PostgreSQLNodeFunctions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int appendGlobalCodeNodeComment(SQLProvider provider, INaviCodeNode codeNode, String commentText, Integer userId) throws CouldntSaveDataException {
        int n2;
        Preconditions.checkNotNull(provider, "IE02445: provider argument can not be null");
        Preconditions.checkNotNull(codeNode, "IE02446: codeNode argument can not be null");
        Preconditions.checkNotNull(commentText, "IE02447: commentText argument can not be null");
        Preconditions.checkNotNull(userId, "IE02448: userId argument can not be null");
        Connection connection = provider.getConnection().getConnection();
        Integer moduleId = null;
        int nodeId = codeNode.getId();
        BigInteger nodeAddress = codeNode.getAddress().toBigInteger();
        try {
            moduleId = codeNode.getParentFunction().getModule().getConfiguration().getId();
        }
        catch (MaybeNullException exception) {
            throw new CouldntSaveDataException("Error: Can not append global code node comments for nodes without a parent function");
        }
        String function = "{ ? = call append_global_code_node_comment( ?, ?, ?, ?, ?) }";
        CallableStatement appendCommentFunction = connection.prepareCall("{ ? = call append_global_code_node_comment( ?, ?, ?, ?, ?) }");
        try {
            appendCommentFunction.registerOutParameter(1, 4);
            appendCommentFunction.setInt(2, (int)moduleId);
            appendCommentFunction.setInt(3, nodeId);
            appendCommentFunction.setObject(4, (Object)nodeAddress, -5);
            appendCommentFunction.setInt(5, (int)userId);
            appendCommentFunction.setString(6, commentText);
            appendCommentFunction.execute();
            int commentId = appendCommentFunction.getInt(1);
            if (appendCommentFunction.wasNull()) {
                throw new CouldntSaveDataException("Error: Got an comment id of null from the database");
            }
            n2 = commentId;
        }
        catch (Throwable throwable) {
            try {
                appendCommentFunction.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new CouldntSaveDataException(exception);
            }
        }
        appendCommentFunction.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer appendGroupNodeComment(SQLProvider provider, INaviGroupNode groupNode, String commentText, Integer userId) throws CouldntSaveDataException {
        Integer n2;
        Preconditions.checkNotNull(provider, "IE02449: provider argument can not be null");
        Preconditions.checkNotNull(groupNode, "IE02450: groupNode argument can not be null");
        Preconditions.checkNotNull(commentText, "IE02451: commentText argument can not be null");
        Preconditions.checkNotNull(userId, "IE02452: userId argument can not be null");
        Preconditions.checkArgument(groupNode.getId() > 0, "Error: group node is not saved.");
        String function = " { ? = call append_group_node_comment(?, ?, ?) } ";
        CallableStatement appendCommentFunction = provider.getConnection().getConnection().prepareCall(" { ? = call append_group_node_comment(?, ?, ?) } ");
        try {
            appendCommentFunction.registerOutParameter(1, 4);
            appendCommentFunction.setInt(2, groupNode.getId());
            appendCommentFunction.setInt(3, (int)userId);
            appendCommentFunction.setString(4, commentText);
            appendCommentFunction.execute();
            Integer commentId = appendCommentFunction.getInt(1);
            if (appendCommentFunction.wasNull()) {
                throw new CouldntSaveDataException("Error: Got an comment id of null from the database");
            }
            n2 = commentId;
        }
        catch (Throwable throwable) {
            try {
                appendCommentFunction.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new CouldntSaveDataException(exception);
            }
        }
        appendCommentFunction.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int appendLocalCodeNodeComment(SQLProvider provider, INaviCodeNode codeNode, String commentText, Integer userId) throws CouldntSaveDataException {
        int n2;
        Preconditions.checkNotNull(provider, "IE02453: provider argument can not be null");
        Preconditions.checkNotNull(codeNode, "IE02454: codeNode argument can not be null");
        Preconditions.checkNotNull(commentText, "IE02455: commentText argument can not be null");
        Preconditions.checkNotNull(userId, "IE02456: userId argument can not be null");
        Connection connection = provider.getConnection().getConnection();
        String function = "{ ? = call append_local_code_node_comment( ?, ?, ?, ?) }";
        Integer moduleId = null;
        int nodeId = codeNode.getId();
        try {
            moduleId = codeNode.getParentFunction().getModule().getConfiguration().getId();
        }
        catch (MaybeNullException exception) {
            throw new CouldntSaveDataException(exception);
        }
        CallableStatement appendCommentFunction = connection.prepareCall("{ ? = call append_local_code_node_comment( ?, ?, ?, ?) }");
        try {
            appendCommentFunction.registerOutParameter(1, 4);
            appendCommentFunction.setInt(2, (int)moduleId);
            appendCommentFunction.setInt(3, nodeId);
            appendCommentFunction.setInt(4, (int)userId);
            appendCommentFunction.setString(5, commentText);
            appendCommentFunction.execute();
            int commentId = appendCommentFunction.getInt(1);
            if (appendCommentFunction.wasNull()) {
                throw new CouldntSaveDataException("E00037: ");
            }
            n2 = commentId;
        }
        catch (Throwable throwable) {
            try {
                appendCommentFunction.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new CouldntSaveDataException(exception);
            }
        }
        appendCommentFunction.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int appendLocalFunctionNodeComment(SQLProvider provider, INaviFunctionNode functionNode, String commentText, Integer userId) throws CouldntSaveDataException {
        int n2;
        Preconditions.checkNotNull(provider, "IE02457: provider argument can not be null");
        Preconditions.checkNotNull(functionNode, "IE02458: functionNode argument can not be null");
        Preconditions.checkNotNull(commentText, "IE02459: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE02460: userId argument can not be null");
        Connection connection = provider.getConnection().getConnection();
        int moduleId = functionNode.getFunction().getModule().getConfiguration().getId();
        String function = " { ? = call append_function_node_comment(?, ?, ?, ?) } ";
        CallableStatement appendCommentFunction = connection.prepareCall(" { ? = call append_function_node_comment(?, ?, ?, ?) } ");
        try {
            appendCommentFunction.registerOutParameter(1, 4);
            appendCommentFunction.setInt(2, moduleId);
            appendCommentFunction.setInt(3, functionNode.getId());
            appendCommentFunction.setInt(4, (int)userId);
            appendCommentFunction.setString(5, commentText);
            appendCommentFunction.execute();
            int commentId = appendCommentFunction.getInt(1);
            if (appendCommentFunction.wasNull()) {
                throw new CouldntSaveDataException("Error: Got an comment id of null from the database");
            }
            n2 = commentId;
        }
        catch (Throwable throwable) {
            try {
                appendCommentFunction.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new CouldntSaveDataException(exception);
            }
        }
        appendCommentFunction.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer appendTextNodeComment(SQLProvider provider, INaviTextNode textNode, String commentText, Integer userId) throws CouldntSaveDataException {
        Integer n2;
        Preconditions.checkNotNull(provider, "IE02461: provider argument can not be null");
        Preconditions.checkNotNull(textNode, "IE02462: textNode argument can not be null");
        Preconditions.checkNotNull(commentText, "IE02463: commentText argument can not be null");
        Preconditions.checkNotNull(userId, "IE02464: userId argument can not be null");
        String function = " { ? = call append_text_node_comment(?, ?, ?) } ";
        CallableStatement appendCommentFunction = provider.getConnection().getConnection().prepareCall(" { ? = call append_text_node_comment(?, ?, ?) } ");
        try {
            appendCommentFunction.registerOutParameter(1, 4);
            appendCommentFunction.setInt(2, textNode.getId());
            appendCommentFunction.setInt(3, (int)userId);
            appendCommentFunction.setString(4, commentText);
            appendCommentFunction.execute();
            Integer commentId = appendCommentFunction.getInt(1);
            if (appendCommentFunction.wasNull()) {
                throw new CouldntSaveDataException("Error: Got an comment id of null from the database");
            }
            n2 = commentId;
        }
        catch (Throwable throwable) {
            try {
                appendCommentFunction.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new CouldntSaveDataException(exception);
            }
        }
        appendCommentFunction.close();
        return n2;
    }

    public static void deleteGlobalCodeNodeComment(SQLProvider provider, INaviCodeNode codeNode, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE02465: provider argument can not be null");
        Preconditions.checkNotNull(codeNode, "IE02466: codeNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02467: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE02468: userId argument can not be null");
        String function = " { ? = call delete_global_code_node_comment(?, ?, ?, ?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { ? = call delete_global_code_node_comment(?, ?, ?, ?, ?) } ");){
            deleteCommentStatement.registerOutParameter(1, 4);
            deleteCommentStatement.setInt(2, codeNode.getParentFunction().getModule().getConfiguration().getId());
            deleteCommentStatement.setInt(3, codeNode.getId());
            deleteCommentStatement.setObject(4, (Object)codeNode.getAddress().toBigInteger(), -5);
            deleteCommentStatement.setInt(5, (int)commentId);
            deleteCommentStatement.setInt(6, (int)userId);
            deleteCommentStatement.execute();
            deleteCommentStatement.getInt(1);
            if (deleteCommentStatement.wasNull()) {
                throw new IllegalArgumentException("Error: the comment id returned by the database was null");
            }
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteGroupNodeComment(SQLProvider provider, INaviGroupNode groupNode, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE02469: provider argument can not be null");
        Preconditions.checkNotNull(groupNode, "IE02470: groupNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02471: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "IE02472: userId argument can not be null");
        String function = " { ? = call delete_group_node_comment(?, ?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { ? = call delete_group_node_comment(?, ?, ?) } ");){
            deleteCommentStatement.registerOutParameter(1, 4);
            deleteCommentStatement.setInt(2, groupNode.getId());
            deleteCommentStatement.setInt(3, (int)commentId);
            deleteCommentStatement.setInt(4, (int)userId);
            deleteCommentStatement.execute();
            deleteCommentStatement.getInt(1);
            if (deleteCommentStatement.wasNull()) {
                throw new IllegalArgumentException("Error: the comment id returned from the database was null");
            }
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public static void deleteLocalCodeNodeComment(SQLProvider provider, INaviCodeNode codeNode, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE02473: provider argument can not be null");
        Preconditions.checkNotNull(codeNode, "IE02474: codeNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02475: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE02476: userId argument can not be null");
        String function = " { ? = call delete_local_code_node_comment(?, ?, ?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { ? = call delete_local_code_node_comment(?, ?, ?, ?) } ");){
            deleteCommentStatement.registerOutParameter(1, 4);
            deleteCommentStatement.setInt(2, codeNode.getParentFunction().getModule().getConfiguration().getId());
            deleteCommentStatement.setInt(3, codeNode.getId());
            deleteCommentStatement.setInt(4, (int)commentId);
            deleteCommentStatement.setInt(5, (int)userId);
            deleteCommentStatement.execute();
            deleteCommentStatement.getInt(1);
            if (deleteCommentStatement.wasNull()) {
                throw new IllegalArgumentException("Error: the comment id returned from the database was null");
            }
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLocalFunctionNodeComment(SQLProvider provider, INaviFunctionNode functionNode, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE02477: provider argument can not be null");
        Preconditions.checkNotNull(functionNode, "IE02478: functionNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02479: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE02480: userId argument can not be null");
        String function = " { ? = call delete_function_node_comment(?, ?, ?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { ? = call delete_function_node_comment(?, ?, ?, ?) } ");){
            deleteCommentStatement.registerOutParameter(1, 4);
            deleteCommentStatement.setInt(2, functionNode.getFunction().getModule().getConfiguration().getId());
            deleteCommentStatement.setInt(3, functionNode.getId());
            deleteCommentStatement.setInt(4, (int)commentId);
            deleteCommentStatement.setInt(5, (int)userId);
            deleteCommentStatement.execute();
            deleteCommentStatement.getInt(1);
            if (deleteCommentStatement.wasNull()) {
                throw new IllegalArgumentException("Error: the comment id returned from the database was null");
            }
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTextNodeComment(SQLProvider provider, INaviTextNode textNode, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE02481: provider argument can not be null");
        Preconditions.checkNotNull(textNode, "IE02482: textNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02483: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "IE02484: userId argument can not be null");
        String function = " { ? = call delete_text_node_comment(?, ?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { ? = call delete_text_node_comment(?, ?, ?) } ");){
            deleteCommentStatement.registerOutParameter(1, 4);
            deleteCommentStatement.setInt(2, textNode.getId());
            deleteCommentStatement.setInt(3, (int)commentId);
            deleteCommentStatement.setInt(4, (int)userId);
            deleteCommentStatement.execute();
            deleteCommentStatement.getInt(1);
            if (deleteCommentStatement.wasNull()) {
                throw new IllegalArgumentException("Error: the comment id returned from the database was null");
            }
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public static void editGlobalCodeNodeComment(SQLProvider provider, INaviCodeNode codeNode, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE02485: provider argument can not be null");
        Preconditions.checkNotNull(codeNode, "IE02486: codeNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02487: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "IE02488: userId argument can not be null");
        Preconditions.checkNotNull(newComment, "IE02489: newComment argument can not be null");
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, newComment);
    }

    public static void editGroupNodeComment(SQLProvider provider, INaviGroupNode groupNode, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE02490: provider argument can not be null");
        Preconditions.checkNotNull(groupNode, "IE02491: groupNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02492: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "IE02493: userId argument can not be null");
        Preconditions.checkNotNull(newComment, "IE02494: newComment argument can not be null");
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, newComment);
    }

    public static void editLocalCodeNodeComment(SQLProvider provider, INaviCodeNode codeNode, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE02495: provider argument can not be null");
        Preconditions.checkNotNull(codeNode, "IE02496: codeNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02497: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "IE02498: userId argument can not be null");
        Preconditions.checkNotNull(newComment, "IE02499: newComment argument can not be null");
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, newComment);
    }

    public static void editLocalFunctionNodeComment(SQLProvider provider, INaviFunctionNode functionNode, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE02500: provider argument can not be null");
        Preconditions.checkNotNull(functionNode, "IE02501: functionNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02502: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "IE02503: userId argument can not be null");
        Preconditions.checkNotNull(newComment, "IE02504: newComment argument can not be null");
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, newComment);
    }

    public static void editTextNodeComment(SQLProvider provider, INaviTextNode textNode, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE02505: provider argument can not be null");
        Preconditions.checkNotNull(textNode, "IE02506: groupNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02507: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "IE02508: userId argument can not be null");
        Preconditions.checkNotNull(newComment, "IE02509: newComment argument can not be null");
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, newComment);
    }

    public static void tagNode(SQLProvider provider, INaviViewNode node, int tagId) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE01309: provider argument can not be null");
        Preconditions.checkNotNull(node, "IE01663: node argument can not be null");
        CConnection connection = provider.getConnection();
        PostgreSQLNodeFunctions.untagNode(provider, node, tagId);
        String tagQuery = String.format("INSERT INTO %s (node_id, tag_id) VALUES (%d, %d)", "bn_tagged_nodes", node.getId(), tagId);
        try {
            connection.executeUpdate(tagQuery, true);
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public static void untagNode(SQLProvider provider, INaviViewNode node, int tagId) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE01990: Provider argument can not be null");
        Preconditions.checkNotNull(node, "IE01991: Node argument can not be null");
        CConnection connection = provider.getConnection();
        try {
            connection.executeUpdate(String.format("DELETE FROM %s  WHERE node_id = %d AND tag_id = %d", "bn_tagged_nodes", node.getId(), tagId), true);
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }
}

