/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.CModuleViewFinder;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class PostgreSQLModuleFunctions {
    private PostgreSQLModuleFunctions() {
    }

    protected static void checkArguments(AbstractSQLProvider provider, INaviModule module) {
        Preconditions.checkNotNull(provider, "IE00488: Provider argument can not be null");
        Preconditions.checkNotNull(module, "IE00489: Module argument can not be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE00490: Module is not part of this database");
    }

    public static void assignDebugger(AbstractSQLProvider provider, INaviModule module, DebuggerTemplate debugger) throws CouldntSaveDataException {
        PostgreSQLModuleFunctions.checkArguments(provider, module);
        if (debugger != null && !debugger.inSameDatabase(provider)) {
            throw new IllegalArgumentException("IE00491: Debugger is not part of this database");
        }
        CConnection connection = provider.getConnection();
        try {
            String query = String.format("update %s set debugger_id = %s where id = %d", "bn_modules", debugger == null ? "NULL" : String.valueOf(debugger.getId()), module.getConfiguration().getId());
            connection.executeUpdate(query, true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
        PostgreSQLHelpers.updateModificationDate(connection, "bn_modules", module.getConfiguration().getId());
    }

    public static void deleteModule(AbstractSQLProvider provider, INaviModule module) throws CouldntDeleteException {
        PostgreSQLModuleFunctions.checkArguments(provider, module);
        NaviLogger.info("Deleting module %s", module.getConfiguration().getName());
        CConnection connection = provider.getConnection();
        try {
            String string2 = String.valueOf("DELETE FROM bn_views  WHERE id IN (SELECT view_id FROM bn_module_views WHERE module_id = ");
            int n2 = module.getConfiguration().getId();
            String moduleViewQuery = new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(n2).append(")").toString();
            connection.executeUpdate(moduleViewQuery, true);
            String string3 = String.valueOf("DELETE FROM bn_nodes  WHERE id IN  (SELECT view_id FROM bn_module_views WHERE module_id = ");
            int n3 = module.getConfiguration().getId();
            String nodeQuery = new StringBuilder(12 + String.valueOf(string3).length()).append(string3).append(n3).append(")").toString();
            connection.executeUpdate(nodeQuery, true);
            String instructionsQuery = String.format("DELETE FROM bn_instructions WHERE module_id = %d", module.getConfiguration().getId());
            connection.executeUpdate(instructionsQuery, true);
            connection.executeUpdate(String.format("delete FROM bn_expression_tree_mapping where module_id = %d", module.getConfiguration().getId()), true);
            connection.executeUpdate(String.format("delete FROM bn_expression_tree where module_id = %d", module.getConfiguration().getId()), true);
            connection.executeUpdate(String.format("delete FROM bn_expression_tree_ids where module_id = %d", module.getConfiguration().getId()), true);
            connection.executeUpdate(String.format("delete FROM bn_code_nodes where module_id = %d", module.getConfiguration().getId()), true);
            connection.executeUpdate(String.format("delete from bn_modules where id = %d", module.getConfiguration().getId()), true);
        }
        catch (SQLException e2) {
            throw new CouldntDeleteException(e2);
        }
    }

    public static Date getModificationDate(AbstractSQLProvider provider, INaviModule module) throws CouldntLoadDataException {
        PostgreSQLModuleFunctions.checkArguments(provider, module);
        return PostgreSQLHelpers.getModificationDate(provider.getConnection(), "bn_modules", module.getConfiguration().getId());
    }

    public static List<INaviView> getViewsWithAddresses(AbstractSQLProvider provider, INaviModule module, List<UnrelocatedAddress> addresses, boolean all) throws CouldntLoadDataException {
        PostgreSQLModuleFunctions.checkArguments(provider, module);
        Preconditions.checkNotNull(addresses, "IE00492: Addresses argument can not be null");
        StringBuilder queryBuilder = new StringBuilder();
        int moduleID = module.getConfiguration().getId();
        if (addresses.size() == 0) {
            return new ArrayList<INaviView>();
        }
        if (addresses.size() == 1) {
            String string2 = String.valueOf("SELECT mvt.module_id, mvt.view_id FROM bn_module_views AS mvt JOIN bn_nodes AS nt ON mvt.view_id = nt.view_id AND mvt.module_id = ");
            String string3 = String.valueOf("bn_codenode_instructions");
            String string4 = String.valueOf("bn_instructions");
            long l2 = addresses.get(0).getAddress().toLong();
            queryBuilder.append(new StringBuilder(190 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string2).append(moduleID).append(" JOIN ").append(string3).append(" AS cit ON nt.id = cit.node_id AND cit.module_id = ").append(moduleID).append(" JOIN ").append(string4).append(" AS it ON it.address = cit.address AND it.module_id = ").append(moduleID).append(" WHERE it.address = ").append(l2).toString());
        } else if (all) {
            boolean needsComma = false;
            int counter = 0;
            queryBuilder.append("select view_id from ");
            for (UnrelocatedAddress address : addresses) {
                if (needsComma) {
                    queryBuilder.append(" inner join ");
                }
                needsComma = true;
                String string5 = String.valueOf("(SELECT mvt.module_id, mvt.view_id FROM bn_module_views AS mvt JOIN bn_nodes AS nt ON mvt.view_id = nt.view_id AND mvt.module_id = ");
                String string6 = String.valueOf("bn_codenode_instructions");
                String string7 = String.valueOf("bn_instructions");
                long l3 = address.getAddress().toLong();
                int n2 = counter++;
                queryBuilder.append(new StringBuilder(207 + String.valueOf(string5).length() + String.valueOf(string6).length() + String.valueOf(string7).length()).append(string5).append(moduleID).append(" JOIN ").append(string6).append(" AS cit ON nt.id = cit.node_id AND cit.module_id = ").append(moduleID).append(" JOIN ").append(string7).append(" AS it ON it.address = cit.address AND it.module_id = ").append(moduleID).append(" WHERE it.address = ").append(l3).append(") AS t").append(n2).toString());
            }
            queryBuilder.append(" USING (view_id)");
        } else {
            String needsComma = String.valueOf("SELECT mvt.module_id, mvt.view_id FROM bn_module_views AS mvt JOIN bn_nodes AS nt ON mvt.view_id = nt.view_id AND mvt.module_id = ");
            String string8 = String.valueOf("bn_codenode_instructions");
            String string9 = String.valueOf("bn_instructions");
            queryBuilder.append(new StringBuilder(172 + String.valueOf(needsComma).length() + String.valueOf(string8).length() + String.valueOf(string9).length()).append(needsComma).append(moduleID).append(" JOIN ").append(string8).append(" AS cit ON nt.id = cit.node_id AND cit.module_id = ").append(moduleID).append(" JOIN ").append(string9).append(" AS it ON it.address = cit.address AND it.module_id = ").append(moduleID).append(" WHERE it.address IN (").toString());
            boolean needsComma2 = false;
            for (UnrelocatedAddress address : addresses) {
                if (needsComma2) {
                    queryBuilder.append(", ");
                }
                needsComma2 = true;
                queryBuilder.append(address.getAddress().toLong());
            }
            queryBuilder.append(") GROUP BY mvt.view_id, mvt.module_id");
        }
        return PostgreSQLHelpers.getViewsWithAddress(provider.getConnection(), queryBuilder.toString(), "module_id", new CModuleViewFinder(provider));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CModule readModule(CConnection connection, int moduleId, INaviRawModule rawModule, SQLProvider provider) throws CouldntLoadDataException {
        Preconditions.checkNotNull(rawModule, "IE01797: Raw module argument can not be null");
        Preconditions.checkNotNull(provider, "IE01798: Provider argument can not be null");
        String string2 = String.valueOf("SELECT id, bn_modules.name, md5, sha1,  description, import_time, modification_date, image_base, file_base, stared,  initialization_state  FROM bn_modules WHERE id = ");
        String query = new StringBuilder(23 + String.valueOf(string2).length()).append(string2).append(moduleId).append(" ORDER by id").toString();
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            if (!resultSet.next()) throw new CouldntLoadDataException("Error: No module with the given ID exists");
            String name = PostgreSQLHelpers.readString(resultSet, "name");
            String md52 = PostgreSQLHelpers.readString(resultSet, "md5");
            String sha1 = PostgreSQLHelpers.readString(resultSet, "sha1");
            String comment = PostgreSQLHelpers.readString(resultSet, "description");
            Timestamp importTime = resultSet.getTimestamp("import_time");
            Timestamp modificationDate = resultSet.getTimestamp("modification_date");
            int functionCount = rawModule.getFunctionCount();
            boolean viewCount = false;
            IAddress imageBase = PostgreSQLHelpers.loadAddress(resultSet, "image_base");
            IAddress fileBase = PostgreSQLHelpers.loadAddress(resultSet, "file_base");
            boolean isStared = resultSet.getBoolean("stared");
            int initializationState = resultSet.getInt("initialization_state");
            CModule cModule = new CModule(moduleId, name, comment, importTime, modificationDate, md52, sha1, functionCount, 0, fileBase, imageBase, null, rawModule, initializationState, isStared, provider);
            return cModule;
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    public static void setDescription(AbstractSQLProvider provider, INaviModule module, String description) throws CouldntSaveDataException {
        PostgreSQLModuleFunctions.checkArguments(provider, module);
        Preconditions.checkNotNull(description, "IE00493: Description argument can not be null");
        PostgreSQLHelpers.setDescription(provider.getConnection(), module.getConfiguration().getId(), description, "bn_modules");
    }

    public static void setFileBase(AbstractSQLProvider provider, INaviModule module, IAddress address) throws CouldntSaveDataException {
        PostgreSQLModuleFunctions.checkArguments(provider, module);
        Preconditions.checkNotNull(address, "IE00494: Address argument can not be null");
        CConnection connection = provider.getConnection();
        try {
            String query = String.format("UPDATE %s SET file_base = %s  WHERE id = %d", "bn_modules", address.toBigInteger().toString(), module.getConfiguration().getId());
            connection.executeUpdate(query, true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
        PostgreSQLHelpers.updateModificationDate(connection, "bn_modules", module.getConfiguration().getId());
    }

    public static void setImageBase(AbstractSQLProvider provider, INaviModule module, IAddress address) throws CouldntSaveDataException {
        PostgreSQLModuleFunctions.checkArguments(provider, module);
        Preconditions.checkNotNull(address, "IE00495: Address argument can not be null");
        CConnection connection = provider.getConnection();
        try {
            String query = String.format("UPDATE %s SET image_base = %s  WHERE id = %d", "bn_modules", address.toBigInteger().toString(), module.getConfiguration().getId());
            connection.executeUpdate(query, true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
        PostgreSQLHelpers.updateModificationDate(connection, "bn_modules", module.getConfiguration().getId());
    }

    public static void setName(AbstractSQLProvider provider, INaviModule module, String name) throws CouldntSaveDataException {
        PostgreSQLModuleFunctions.checkArguments(provider, module);
        Preconditions.checkNotNull(name, "IE00496: Name argument can not be null");
        PostgreSQLHelpers.setName(provider.getConnection(), module.getConfiguration().getId(), name, "bn_modules");
    }

    public static void starModule(AbstractSQLProvider provider, INaviModule module, boolean isStared) throws CouldntSaveDataException {
        String string2 = String.valueOf("UPDATE bn_modules SET stared = ");
        int n2 = module.getConfiguration().getId();
        String starModuleQuery = new StringBuilder(28 + String.valueOf(string2).length()).append(string2).append(isStared).append(" WHERE id = ").append(n2).toString();
        try {
            provider.getConnection().executeUpdate(starModuleQuery, true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }
}

