/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.CComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.COperandTree;
import com.google.security.zynamics.binnavi.disassembly.COperandTypeConverter;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.ReferenceType;
import com.google.security.zynamics.zylib.general.Convert;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PostgreSQLInstructionFunctions {
    private PostgreSQLInstructionFunctions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createExpressionTree(SQLProvider provider, Set<INaviOperandTreeNode> nodes, INaviModule module) throws SQLException {
        int moduleId = module.getConfiguration().getId();
        String string2 = String.valueOf("select max(id) + 1 AS id from bn_expression_tree_ids where module_id = ");
        int expressionTreeId = -1;
        try (ResultSet resultSet = provider.getConnection().executeQuery(new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(moduleId).toString(), true);){
            if (resultSet.next()) {
                expressionTreeId = resultSet.getInt("id");
            }
        }
        provider.getConnection().executeUpdate(String.format("insert into bn_expression_tree_ids values(%d , %d)", moduleId, expressionTreeId), true);
        for (INaviOperandTreeNode node : nodes) {
            provider.getConnection().executeUpdate(String.format("insert into bn_expression_tree_mapping values(%d, %d, %d)", moduleId, expressionTreeId, node.getId()), true);
        }
        return expressionTreeId;
    }

    private static void createOperand(SQLProvider provider, int moduleId, BigInteger address, int position, int expressionTreeId) throws SQLException {
        String query = String.format("insert into bn_operands(module_id, address, position, expression_tree_id) values(%d, %d, %d, %d)", moduleId, address, position, expressionTreeId);
        provider.getConnection().executeUpdate(query, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createOperandExpression(SQLProvider provider, INaviOperandTreeNode node, int parent) throws SQLException {
        block7: {
            if (node.getId() != -1) {
                return;
            }
            ExpressionType type = node.getType();
            String value = PostgreSQLInstructionFunctions.getValue(type, node.getValue());
            int moduleId = node.getOperand().getInstruction().getModule().getConfiguration().getId();
            int typeId = COperandTypeConverter.convert(type);
            String immediate = Convert.isDecString(value) ? value : "null";
            String symbol2 = Convert.isDecString(value) ? "null" : value;
            String parentString = parent == 0 ? "null" : String.valueOf(parent);
            String string2 = String.valueOf("select max(id)+1 AS id from bn_expression_tree where module_id = ");
            try (ResultSet resultSet = provider.getConnection().executeQuery(new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(moduleId).toString(), true);){
                if (!resultSet.next()) break block7;
                int id = resultSet.getInt("id");
                String query = String.format("insert into bn_expression_tree(module_id, id, type, symbol, immediate, position, parent_id)  values(%d, %d , %d, ?, %s, 0, %s)", moduleId, id, typeId, immediate, parentString);
                try (PreparedStatement statement = provider.getConnection().getConnection().prepareStatement(query);){
                    statement.setString(1, symbol2);
                    statement.executeUpdate();
                }
                node.setId(id);
            }
        }
    }

    private static void createOperandExpression(SQLProvider provider, INaviOperandTreeNode rootNode, int parent, Set<INaviOperandTreeNode> nodes) throws SQLException {
        PostgreSQLInstructionFunctions.createOperandExpression(provider, rootNode, parent);
        nodes.add(rootNode);
        for (INaviOperandTreeNode child : rootNode.getChildren()) {
            PostgreSQLInstructionFunctions.createOperandExpression(provider, child, rootNode.getId(), nodes);
        }
    }

    private static void createOperandTree(SQLProvider provider, COperandTree operand, int position) throws SQLException {
        HashSet<INaviOperandTreeNode> nodes = new HashSet<INaviOperandTreeNode>();
        PostgreSQLInstructionFunctions.createOperandExpression(provider, operand.getRootNode(), 0, nodes);
        int expressionTreeId = PostgreSQLInstructionFunctions.createExpressionTree(provider, nodes, operand.getInstruction().getModule());
        BigInteger address = operand.getInstruction().getAddress().toBigInteger();
        int moduleId = operand.getInstruction().getModule().getConfiguration().getId();
        PostgreSQLInstructionFunctions.createOperand(provider, moduleId, address, position, expressionTreeId);
    }

    private static String getValue(ExpressionType type, String value) {
        if (type == ExpressionType.SIZE_PREFIX) {
            if ("byte".equals(value)) {
                return "b1";
            }
            if ("word".equals(value)) {
                return "b2";
            }
            if ("dword".equals(value)) {
                return "b4";
            }
            if ("fword".equals(value)) {
                return "b6";
            }
            if ("qword".equals(value)) {
                return "b8";
            }
            if ("oword".equals(value)) {
                return "b16";
            }
            if ("b_var".equals(value)) {
                return "b_var";
            }
            String string2 = String.valueOf(value);
            throw new IllegalStateException(string2.length() != 0 ? "IE01104: Unknown size ".concat(string2) : new String("IE01104: Unknown size "));
        }
        return value;
    }

    public static void addReference(SQLProvider provider, INaviOperandTreeNode node, IAddress targetAddress, ReferenceType type) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00473: Provider argument can not be null");
        Preconditions.checkNotNull(node, "IE00474: Node argument can not be null");
        Preconditions.checkNotNull(targetAddress, "IE01548: Address argument can not be null");
        Preconditions.checkNotNull(type, "IE00475: Type argument can not be null");
        CConnection connection = provider.getConnection();
        int moduleId = node.getOperand().getInstruction().getModule().getConfiguration().getId();
        BigInteger address = node.getInstructionAddress().toBigInteger();
        int position = node.getOperandPosition();
        int expressionId = node.getId();
        String query = String.format("INSERT INTO bn_address_references(module_id, address, position, expression_id, type, target) VALUES(%d, %d, %d, %d, '%s', %s)", moduleId, address, position, expressionId, type.toString().toLowerCase(), targetAddress.toBigInteger().toString());
        try {
            connection.executeUpdate(query, true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int appendGlobalInstructionComment(SQLProvider provider, INaviInstruction instruction, String commentText, Integer userId) throws CouldntSaveDataException {
        int n2;
        Preconditions.checkNotNull(provider, "IE01648: provider argument can not be null");
        Preconditions.checkNotNull(instruction, "IE02040: instruction argument can not be null");
        Preconditions.checkNotNull(commentText, "IE02041: commentText argument can not be null");
        Preconditions.checkNotNull(userId, "IE02142: userId argument can not be null");
        CConnection connection = provider.getConnection();
        String function = "{ ? = call append_global_instruction_comment(?, ?, ?, ?) }";
        CallableStatement appendCommentFunction = connection.getConnection().prepareCall("{ ? = call append_global_instruction_comment(?, ?, ?, ?) }");
        try {
            appendCommentFunction.registerOutParameter(1, 4);
            appendCommentFunction.setInt(2, instruction.getModule().getConfiguration().getId());
            appendCommentFunction.setObject(3, (Object)instruction.getAddress().toBigInteger(), -5);
            appendCommentFunction.setInt(4, (int)userId);
            appendCommentFunction.setString(5, commentText);
            appendCommentFunction.execute();
            int commentId = appendCommentFunction.getInt(1);
            if (appendCommentFunction.wasNull()) {
                throw new CouldntSaveDataException("Error: Got an comment id of null from the database");
            }
            n2 = commentId;
        }
        catch (Throwable throwable) {
            try {
                appendCommentFunction.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new CouldntSaveDataException(exception);
            }
        }
        appendCommentFunction.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int appendLocalInstructionComment(SQLProvider provider, INaviCodeNode codeNode, INaviInstruction instruction, String commentText, Integer userId) throws CouldntSaveDataException {
        int n2;
        Preconditions.checkNotNull(provider, "IE02423: provider argument can not be null");
        Preconditions.checkNotNull(codeNode, "IE02424: codeNode argument can not be null");
        Preconditions.checkNotNull(instruction, "IE02425: instruction argument can not be null");
        Preconditions.checkNotNull(commentText, "IE02426: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE02427: userId argument can not be null");
        CConnection connection = provider.getConnection();
        String function = "{ ? = call append_local_instruction_comment( ?, ?, ?, ?, ?) }";
        CallableStatement appendCommentFunction = connection.getConnection().prepareCall("{ ? = call append_local_instruction_comment( ?, ?, ?, ?, ?) }");
        try {
            appendCommentFunction.registerOutParameter(1, 4);
            appendCommentFunction.setInt(2, instruction.getModule().getConfiguration().getId());
            appendCommentFunction.setInt(3, codeNode.getId());
            appendCommentFunction.setObject(4, (Object)instruction.getAddress().toBigInteger(), -5);
            appendCommentFunction.setInt(5, (int)userId);
            appendCommentFunction.setString(6, commentText);
            appendCommentFunction.execute();
            int commentId = appendCommentFunction.getInt(1);
            if (appendCommentFunction.wasNull()) {
                throw new CouldntSaveDataException("Error: Got an comment id of null from the database");
            }
            n2 = commentId;
        }
        catch (Throwable throwable) {
            try {
                appendCommentFunction.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new CouldntSaveDataException(exception);
            }
        }
        appendCommentFunction.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createInstructions(SQLProvider provider, Iterable<INaviInstruction> instructions) throws SQLException {
        Preconditions.checkNotNull(provider, "IE01550: Provider argument can not be null");
        Preconditions.checkNotNull(instructions, "IE01554: Instruction argument can not be null");
        String query = "INSERT INTO bn_instructions(module_id, address, mnemonic, data, native, architecture, comment_id) VALUES(?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement insertStatement = provider.getConnection().getConnection().prepareStatement("INSERT INTO bn_instructions(module_id, address, mnemonic, data, native, architecture, comment_id) VALUES(?, ?, ?, ?, ?, ?, ?)");
        ArrayList<INaviInstruction> instructionsWithUnsavedComments = new ArrayList<INaviInstruction>();
        ArrayList<List<COperandTree>> operands = new ArrayList<List<COperandTree>>();
        for (INaviInstruction iNaviInstruction : instructions) {
            Integer commentId;
            String mnemonic = iNaviInstruction.getMnemonic();
            byte[] data = iNaviInstruction.getData();
            operands.add(iNaviInstruction.getOperands());
            INaviModule module = iNaviInstruction.getModule();
            IAddress address = iNaviInstruction.getAddress();
            int moduleID = module.getConfiguration().getId();
            List<IComment> comments = iNaviInstruction.getGlobalComment();
            Integer n2 = comments == null ? null : (commentId = comments.size() == 0 ? null : Iterables.getLast(comments).getId());
            if (comments != null && comments.size() != 0 && commentId == null) {
                instructionsWithUnsavedComments.add(iNaviInstruction);
            }
            try {
                insertStatement.setInt(1, moduleID);
                insertStatement.setObject(2, (Object)address.toBigInteger(), -5);
                insertStatement.setString(3, mnemonic);
                insertStatement.setBytes(4, data);
                insertStatement.setBoolean(5, false);
                insertStatement.setObject(6, (Object)iNaviInstruction.getArchitecture(), 1111);
                if (commentId == null) {
                    insertStatement.setNull(7, 4);
                } else {
                    insertStatement.setInt(7, commentId);
                }
                insertStatement.execute();
            }
            finally {
                insertStatement.close();
            }
        }
        for (INaviInstruction iNaviInstruction : instructionsWithUnsavedComments) {
            ArrayList<IComment> instructionComments = new ArrayList<IComment>();
            for (IComment comment : iNaviInstruction.getGlobalComment()) {
                try {
                    Integer commentId = PostgreSQLInstructionFunctions.appendGlobalInstructionComment(provider, iNaviInstruction, comment.getComment(), comment.getUser().getUserId());
                    CComment newComment = new CComment(commentId, comment.getUser(), comment.getParent(), comment.getComment());
                    instructionComments.add(newComment);
                }
                catch (CouldntSaveDataException exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
            iNaviInstruction.initializeGlobalComment(instructionComments);
        }
        for (List list : operands) {
            int position = 0;
            for (COperandTree operandTree : list) {
                PostgreSQLInstructionFunctions.createOperandTree(provider, operandTree, position);
                ++position;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteGlobalInstructionComment(SQLProvider provider, INaviInstruction instruction, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE02428: provider argument can not be null");
        Preconditions.checkNotNull(instruction, "IE02429: instruction argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02430: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE02431: userId argument can not be null");
        String function = " { ? = call delete_global_instruction_comment(?, ?, ?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { ? = call delete_global_instruction_comment(?, ?, ?, ?) } ");){
            deleteCommentStatement.registerOutParameter(1, 4);
            deleteCommentStatement.setInt(2, instruction.getModule().getConfiguration().getId());
            deleteCommentStatement.setObject(3, (Object)instruction.getAddress().toBigInteger(), -5);
            deleteCommentStatement.setInt(4, (int)commentId);
            deleteCommentStatement.setInt(5, (int)userId);
            deleteCommentStatement.execute();
            deleteCommentStatement.getInt(1);
            if (deleteCommentStatement.wasNull()) {
                throw new IllegalArgumentException("Error: The comment id returned from the database was null.");
            }
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLocalInstructionComment(SQLProvider provider, INaviCodeNode codeNode, INaviInstruction instruction, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkNotNull(codeNode, "IE02432: codeNode argument can not be null");
        Preconditions.checkNotNull(provider, "IE02433: provider argument can not be null");
        Preconditions.checkNotNull(instruction, "IE02434: instruction argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02435: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE02436: userId argument can not be null");
        String function = " { ? = call delete_local_instruction_comment(?, ?, ?, ?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { ? = call delete_local_instruction_comment(?, ?, ?, ?, ?) } ");){
            deleteCommentStatement.registerOutParameter(1, 4);
            deleteCommentStatement.setInt(2, instruction.getModule().getConfiguration().getId());
            deleteCommentStatement.setInt(3, codeNode.getId());
            deleteCommentStatement.setObject(4, (Object)instruction.getAddress().toBigInteger(), -5);
            deleteCommentStatement.setInt(5, (int)commentId);
            deleteCommentStatement.setInt(6, (int)userId);
            deleteCommentStatement.execute();
            deleteCommentStatement.getInt(1);
            if (deleteCommentStatement.wasNull()) {
                throw new IllegalArgumentException("Error: the comment id returned from the database was null");
            }
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public static void deleteReference(SQLProvider provider, INaviOperandTreeNode node, IAddress address, ReferenceType type) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE00476: Provider argument can not be null");
        Preconditions.checkNotNull(node, "IE00477: Node argument can not be null");
        Preconditions.checkNotNull(address, "IE01619: Address argument can not be null");
        Preconditions.checkNotNull(type, "IE00478: Type argument can not be null");
        CConnection connection = provider.getConnection();
        BigInteger instructionAddress = node.getInstructionAddress().toBigInteger();
        int position = node.getOperandPosition();
        int expressionId = node.getId();
        BigInteger targetAddress = address.toBigInteger();
        String string2 = String.valueOf("DELETE FROM bn_address_references WHERE address = ? AND position = ? AND expression_id = ? AND type = '");
        String string3 = String.valueOf(type.toString().toLowerCase());
        String deleteQuery = new StringBuilder(16 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(string3).append("' AND target = ?").toString();
        try (PreparedStatement deleteStatement = connection.getConnection().prepareStatement(deleteQuery);){
            deleteStatement.setObject(1, (Object)instructionAddress, -5);
            deleteStatement.setInt(2, position);
            deleteStatement.setInt(3, expressionId);
            deleteStatement.setObject(4, (Object)targetAddress, -5);
            deleteStatement.execute();
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public static void editGlobalInstructionComment(SQLProvider provider, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE02437: provider argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02438: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "IE02439: userId argument can not be null");
        Preconditions.checkNotNull(newComment, "IE02440: newComment argument can not be null");
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, newComment);
    }

    public static void editLocalInstructionComment(SQLProvider provider, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE02441: provider argument can not be null");
        Preconditions.checkNotNull(commentId, "IE02442: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "IE02443: userId argument can not be null");
        Preconditions.checkNotNull(newComment, "IE02444: newComment argument can not be null");
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, newComment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGlobalReplacement(SQLProvider provider, INaviOperandTreeNode operandTreeNode, String replacement) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE01627: Provider argument can not be null");
        Preconditions.checkNotNull(operandTreeNode, "IE01629: operandTreeNode argument can not be null");
        Preconditions.checkNotNull(replacement, "IE01635: Replacement argument can not be null");
        String query = "UPDATE bn_expression_substitutions SET replacement = ? WHERE expression_id = ?";
        try (PreparedStatement statement = provider.getConnection().getConnection().prepareStatement("UPDATE bn_expression_substitutions SET replacement = ? WHERE expression_id = ?");){
            statement.setString(1, replacement);
            statement.setInt(2, operandTreeNode.getId());
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setReplacement(SQLProvider provider, INaviOperandTreeNode operandTreeNode, String replacement) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE01651: Provider argument can not be null");
        Preconditions.checkNotNull(operandTreeNode, "IE01699: Operand tree node argument cannot be null");
        Preconditions.checkNotNull(replacement, "IE01778: Replacement argument can not be null");
        try (PreparedStatement statement = provider.getConnection().getConnection().prepareStatement("UPDATE bn_expression_substitutions SET replacement = ? WHERE module_id = ? AND address = ? AND position = ? AND expression_id = ?");){
            statement.setString(1, replacement);
            statement.setInt(2, operandTreeNode.getOperand().getInstruction().getModule().getConfiguration().getId());
            statement.setObject(3, (Object)operandTreeNode.getOperand().getInstruction().getAddress().toBigInteger(), -5);
            statement.setInt(4, operandTreeNode.getOperandPosition());
            statement.setInt(5, operandTreeNode.getId());
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }
}

