/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.math.BigInteger;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public final class PostgreSQLFunctionFunctions {
    private PostgreSQLFunctionFunctions() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Integer appendGlobalFunctionComment(AbstractSQLProvider provider, INaviFunction function, String commentText, Integer userId) throws CouldntSaveDataException {
        Preconditions.checkNotNull(function, "IE01042: function argument can not be null");
        Preconditions.checkNotNull(commentText, "IE01240: commentText argument can not be null");
        Preconditions.checkNotNull(userId, "IE01241: userId argument can not be null");
        Connection connection = provider.getConnection().getConnection();
        Integer moduleId = function.getModule().getConfiguration().getId();
        String storedProcedure = " { ? = call append_function_comment( ?, ?, ?, ?) } ";
        try (CallableStatement appendCommentProcedure = connection.prepareCall(" { ? = call append_function_comment( ?, ?, ?, ?) } ");){
            appendCommentProcedure.registerOutParameter(1, 4);
            appendCommentProcedure.setInt(2, (int)moduleId);
            appendCommentProcedure.setObject(3, (Object)function.getAddress().toBigInteger(), -5);
            appendCommentProcedure.setInt(4, (int)userId);
            appendCommentProcedure.setString(5, commentText);
            appendCommentProcedure.execute();
            int commentId = appendCommentProcedure.getInt(1);
            if (appendCommentProcedure.wasNull()) {
                throw new CouldntSaveDataException("Error: Got an comment id of null from the database");
            }
            Integer n2 = commentId;
            return n2;
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public static void deleteGlobalFunctionComment(AbstractSQLProvider provider, INaviFunction function, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE01243: provider argument can not be null");
        Preconditions.checkNotNull(function, "IE01245: codeNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE01247: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE01308: userId argument can not be null");
        String deleteFunction = " { ? = call delete_function_comment(?, ?, ?, ?) } ";
        try (CallableStatement deleteCommentStatement = provider.getConnection().getConnection().prepareCall(" { ? = call delete_function_comment(?, ?, ?, ?) } ");){
            deleteCommentStatement.registerOutParameter(1, 4);
            deleteCommentStatement.setInt(2, function.getModule().getConfiguration().getId());
            deleteCommentStatement.setObject(3, (Object)function.getAddress().toBigInteger(), -5);
            deleteCommentStatement.setInt(4, (int)commentId);
            deleteCommentStatement.setInt(5, (int)userId);
            deleteCommentStatement.execute();
            deleteCommentStatement.getInt(1);
            if (deleteCommentStatement.wasNull()) {
                throw new IllegalArgumentException("Error: The comment id returned by the database was null");
            }
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public static void editGlobalFunctionComment(AbstractSQLProvider provider, INaviFunction function, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, newComment);
    }

    public static void resolveFunction(AbstractSQLProvider provider, INaviFunction source, INaviFunction target) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00444: Provider argument can not be null");
        Preconditions.checkNotNull(source, "IE00445: Source argument can not be null");
        Preconditions.checkArgument(source.inSameDatabase(provider), "IE00446: Source is not part of this database");
        if (target != null && !target.inSameDatabase(provider)) {
            throw new IllegalArgumentException("IE00447: Target is not part of this database");
        }
        Integer parentModuleId = target == null ? null : Integer.valueOf(target.getModule().getConfiguration().getId());
        BigInteger parentModuleAddress = target == null ? null : target.getAddress().toBigInteger();
        String query = "UPDATE bn_functions SET parent_module_id = ?,  parent_module_function = ? WHERE module_id = ? AND address = ?";
        try (PreparedStatement statement = provider.getConnection().getConnection().prepareStatement("UPDATE bn_functions SET parent_module_id = ?,  parent_module_function = ? WHERE module_id = ? AND address = ?");){
            if (parentModuleId != null) {
                statement.setInt(1, parentModuleId);
            } else {
                statement.setNull(1, 4);
            }
            if (parentModuleAddress != null) {
                statement.setObject(2, (Object)parentModuleAddress, -5);
            } else {
                statement.setNull(2, -5);
            }
            statement.setInt(3, source.getModule().getConfiguration().getId());
            statement.setObject(4, (Object)source.getAddress().toBigInteger().toString(), -5);
            statement.execute();
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public static void setDescription(AbstractSQLProvider provider, INaviFunction function, String description) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00448: Provider argument can not be null");
        Preconditions.checkNotNull(function, "IE00449: Function argument can not be null");
        Preconditions.checkNotNull(description, "IE00450: Comment argument can not be null");
        Preconditions.checkArgument(function.inSameDatabase(provider), "IE00451: Function is not part of this database");
        CConnection connection = provider.getConnection();
        int module = function.getModule().getConfiguration().getId();
        IAddress address = function.getAddress();
        String query = "UPDATE bn_functions SET description = ? WHERE module_id = ? AND address = ?";
        try (PreparedStatement statement = connection.getConnection().prepareStatement("UPDATE bn_functions SET description = ? WHERE module_id = ? AND address = ?");){
            statement.setString(1, description);
            statement.setInt(2, module);
            statement.setObject(3, (Object)address.toBigInteger(), -5);
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public static void setName(AbstractSQLProvider provider, INaviFunction function, String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00456: Provider argument can not be null");
        Preconditions.checkNotNull(function, "IE00457: Function argument can not be null");
        Preconditions.checkNotNull(name, "IE00458: Name argument can not be null");
        Preconditions.checkArgument(function.inSameDatabase(provider), "IE00459: Function is not part of this database");
        CConnection connection = provider.getConnection();
        int module = function.getModule().getConfiguration().getId();
        IAddress address = function.getAddress();
        String query = "UPDATE bn_functions SET name = ? WHERE module_id = ? and address = ?";
        try (PreparedStatement statement = connection.getConnection().prepareStatement("UPDATE bn_functions SET name = ? WHERE module_id = ? and address = ?");){
            statement.setString(1, name);
            statement.setInt(2, module);
            statement.setObject(3, (Object)address.toBigInteger(), -5);
            statement.executeUpdate();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }
}

