/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLCommentFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviEdge;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.algorithms.CViewNodeHelpers;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;

public final class PostgreSQLEdgeFunctions {
    private PostgreSQLEdgeFunctions() {
    }

    private static int getModuleId(INaviViewNode node) throws MaybeNullException {
        if (node instanceof INaviCodeNode) {
            return ((INaviCodeNode)node).getParentFunction().getModule().getConfiguration().getId();
        }
        if (node instanceof INaviFunctionNode) {
            return ((INaviFunctionNode)node).getFunction().getModule().getConfiguration().getId();
        }
        throw new IllegalArgumentException("IE00432: Edge's source node must be an instance of CCodeNode or CFunctionNode");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer appendGlobalEdgeComment(AbstractSQLProvider provider, INaviEdge edge, String commentText, Integer userId) throws CouldntSaveDataException {
        Integer n2;
        Preconditions.checkNotNull(provider, "IE00482: provider argument can not be null");
        Preconditions.checkNotNull(edge, "IE00483: edge argument can not be null");
        Preconditions.checkNotNull(commentText, "IE00484: commentText argument can not be null");
        Preconditions.checkNotNull(userId, "IE00485: userId argument can not be null");
        Connection connection = provider.getConnection().getConnection();
        String function = "{ ? = call append_global_edge_comment(?, ?, ?, ?, ?, ?) }";
        int sourceModuleId = PostgreSQLEdgeFunctions.getModuleId((INaviViewNode)edge.getSource());
        int destinationModuleId = PostgreSQLEdgeFunctions.getModuleId((INaviViewNode)edge.getTarget());
        IAddress sourceAddress = CViewNodeHelpers.getAddress((INaviViewNode)edge.getSource());
        IAddress destinationAddress = CViewNodeHelpers.getAddress((INaviViewNode)edge.getTarget());
        CallableStatement appendCommentFunction = connection.prepareCall("{ ? = call append_global_edge_comment(?, ?, ?, ?, ?, ?) }");
        try {
            appendCommentFunction.registerOutParameter(1, 4);
            appendCommentFunction.setInt(2, sourceModuleId);
            appendCommentFunction.setInt(3, destinationModuleId);
            appendCommentFunction.setObject(4, (Object)sourceAddress.toBigInteger(), -5);
            appendCommentFunction.setObject(5, (Object)destinationAddress.toBigInteger(), -5);
            appendCommentFunction.setInt(6, (int)userId);
            appendCommentFunction.setString(7, commentText);
            appendCommentFunction.execute();
            int commentId = appendCommentFunction.getInt(1);
            if (appendCommentFunction.wasNull()) {
                throw new CouldntSaveDataException("Error: Got an comment id of null from the database");
            }
            n2 = commentId;
        }
        catch (Throwable throwable) {
            try {
                try {
                    appendCommentFunction.close();
                    throw throwable;
                }
                catch (SQLException exception) {
                    throw new CouldntSaveDataException(exception);
                }
            }
            catch (MaybeNullException exception) {
                throw new CouldntSaveDataException(exception);
            }
        }
        appendCommentFunction.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int appendLocalEdgeComment(AbstractSQLProvider provider, INaviEdge edge, String commentText, Integer userId) throws CouldntSaveDataException {
        int n2;
        Preconditions.checkNotNull(provider, "IE00486: provider argument can not be null");
        Preconditions.checkNotNull(edge, "IE00502: edge argument can not be null");
        Preconditions.checkNotNull(commentText, "IE00503: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE00504: userId argument can not be null");
        Connection connection = provider.getConnection().getConnection();
        String function = "{ ? = call append_local_edge_comment( ?, ?, ?) }";
        CallableStatement appendCommentFunction = connection.prepareCall("{ ? = call append_local_edge_comment( ?, ?, ?) }");
        try {
            appendCommentFunction.registerOutParameter(1, 4);
            appendCommentFunction.setInt(2, edge.getId());
            appendCommentFunction.setInt(3, (int)userId);
            appendCommentFunction.setString(4, commentText);
            appendCommentFunction.execute();
            int commentId = appendCommentFunction.getInt(1);
            if (appendCommentFunction.wasNull()) {
                throw new CouldntSaveDataException("Error: Database returned null for comment id");
            }
            n2 = commentId;
        }
        catch (Throwable throwable) {
            try {
                appendCommentFunction.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new CouldntSaveDataException(exception);
            }
        }
        appendCommentFunction.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteGlobalEdgeComment(AbstractSQLProvider provider, INaviEdge edge, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE00505: provider argument can not be null");
        Preconditions.checkNotNull(edge, "IE00506: codeNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE00507: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE00508: userId argument can not be null");
        String function = " { ? = call delete_global_edge_comment(?, ?, ?, ?, ?, ?) } ";
        try (CallableStatement deleteCommentFunction = provider.getConnection().getConnection().prepareCall(" { ? = call delete_global_edge_comment(?, ?, ?, ?, ?, ?) } ");){
            deleteCommentFunction.registerOutParameter(1, 4);
            deleteCommentFunction.setInt(2, PostgreSQLEdgeFunctions.getModuleId((INaviViewNode)edge.getSource()));
            deleteCommentFunction.setInt(3, PostgreSQLEdgeFunctions.getModuleId((INaviViewNode)edge.getTarget()));
            deleteCommentFunction.setObject(4, (Object)((INaviCodeNode)edge.getSource()).getAddress().toBigInteger(), -5);
            deleteCommentFunction.setObject(5, (Object)((INaviCodeNode)edge.getTarget()).getAddress().toBigInteger(), -5);
            deleteCommentFunction.setInt(6, (int)commentId);
            deleteCommentFunction.setInt(7, (int)userId);
            deleteCommentFunction.execute();
            deleteCommentFunction.getInt(1);
            if (deleteCommentFunction.wasNull()) {
                throw new IllegalArgumentException("Error: the comment id returned from the database was null");
            }
        }
        catch (MaybeNullException | SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLocalEdgeComment(AbstractSQLProvider provider, INaviEdge edge, Integer commentId, Integer userId) throws CouldntDeleteException {
        Preconditions.checkNotNull(provider, "IE00509: provider argument can not be null");
        Preconditions.checkNotNull(edge, "IE00510: codeNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE00511: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE00512: userId argument can not be null");
        String function = " { ? = call delete_local_edge_comment(?, ?, ?) } ";
        try (CallableStatement deleteCommentFunction = provider.getConnection().getConnection().prepareCall(" { ? = call delete_local_edge_comment(?, ?, ?) } ");){
            deleteCommentFunction.registerOutParameter(1, 4);
            deleteCommentFunction.setInt(2, edge.getId());
            deleteCommentFunction.setInt(3, (int)commentId);
            deleteCommentFunction.setInt(4, (int)userId);
            deleteCommentFunction.execute();
            deleteCommentFunction.getInt(1);
            if (deleteCommentFunction.wasNull()) {
                throw new IllegalArgumentException("Error: the comment id returned from the database was null");
            }
        }
        catch (SQLException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public static void editGlobalEdgeComment(AbstractSQLProvider provider, INaviEdge edge, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00533: provider argument can not be null");
        Preconditions.checkNotNull(edge, "IE00560: codeNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE00561: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE00562: userId argument can not be null");
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, newComment);
    }

    public static void editLocalEdgeComment(AbstractSQLProvider provider, INaviEdge edge, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00856: provider argument can not be null");
        Preconditions.checkNotNull(edge, "IE00857: codeNode argument can not be null");
        Preconditions.checkNotNull(commentId, "IE00858: comment argument can not be null");
        Preconditions.checkNotNull(userId, "IE00874: userId argument can not be null");
        PostgreSQLCommentFunctions.editComment(provider, commentId, userId, newComment);
    }
}

