/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.CComment;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.Gui.Users.Interfaces.IUser;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class PostgreSQLCommentFunctions {
    private PostgreSQLCommentFunctions() {
    }

    public static void editComment(SQLProvider provider, Integer commentId, Integer userId, String newComment) throws CouldntSaveDataException {
        Preconditions.checkNotNull(provider, "IE00436: provider argument can not be null");
        Preconditions.checkNotNull(commentId, "IE00437: commentId argument can not be null");
        Preconditions.checkNotNull(userId, "IE00438: userId argument can not be null");
        Preconditions.checkNotNull(newComment, "IE00439: newComment argument can not be null");
        String function = "{ call edit_comment(?, ?, ?) }";
        try (CallableStatement editCommentFunction = provider.getConnection().getConnection().prepareCall("{ call edit_comment(?, ?, ?) }");){
            editCommentFunction.setInt(1, (int)commentId);
            editCommentFunction.setInt(2, (int)userId);
            editCommentFunction.setString(3, newComment);
            editCommentFunction.execute();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public static ArrayList<IComment> loadCommentByCommentId(SQLProvider provider, int commentRootId) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "IE00440: connection argument can not be null");
        HashMap<Integer, CComment> commentIdToComment = new HashMap<Integer, CComment>();
        ArrayList<IComment> comments = new ArrayList<IComment>();
        String commentQuery = new StringBuilder(53).append("SELECT * FROM get_all_comment_ancestors(").append(commentRootId).append(");").toString();
        try (ResultSet resultSet = provider.getConnection().executeQuery(commentQuery, true);){
            while (resultSet.next()) {
                resultSet.getInt("level");
                int commentId = resultSet.getInt("id");
                Integer parentId = resultSet.getInt("parent_id");
                if (resultSet.wasNull()) {
                    parentId = null;
                }
                int userId = resultSet.getInt("user_id");
                String commentText = resultSet.getString("comment");
                CComment comment = new CComment(commentId, CUserManager.get(provider).getUserById(userId), (IComment)commentIdToComment.get(parentId), commentText);
                commentIdToComment.put(commentId, comment);
                comments.add(comment);
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return comments;
    }

    public static HashMap<Integer, ArrayList<IComment>> loadMultipleCommentsById(SQLProvider provider, Collection<Integer> commentIds) throws CouldntLoadDataException {
        Preconditions.checkNotNull(provider, "IE00480: provider argument can not be null");
        Preconditions.checkNotNull(commentIds, "IE00481: commentIds argument can not be null");
        String query = "SELECT * FROM get_all_comment_ancestors_multiple(?)";
        HashMap<Integer, CComment> commentIdToComment = new HashMap<Integer, CComment>();
        Object[] commentIdsArray = commentIds.toArray();
        HashMap<Integer, ArrayList<IComment>> commentIdToComments = new HashMap<Integer, ArrayList<IComment>>();
        try (CallableStatement statement = provider.getConnection().getConnection().prepareCall("SELECT * FROM get_all_comment_ancestors_multiple(?)");){
            statement.setArray(1, provider.getConnection().getConnection().createArrayOf("int4", commentIdsArray));
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                int rootComment = resultSet.getInt("commentid");
                resultSet.getInt("level");
                int commentId = resultSet.getInt("id");
                int parentId = resultSet.getInt("parent_id");
                int userId = resultSet.getInt("user_id");
                String commentText = resultSet.getString("comment");
                IUser user2 = CUserManager.get(provider).getUserById(userId);
                CComment comment = new CComment(commentId, user2, (IComment)commentIdToComment.get(parentId), commentText);
                commentIdToComment.put(commentId, comment);
                if (commentIdToComments.containsKey(rootComment)) {
                    commentIdToComments.get(rootComment).add(comment);
                    continue;
                }
                commentIdToComments.put(rootComment, Lists.newArrayList(comment));
            }
        }
        catch (SQLException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return commentIdToComments;
    }
}

