/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.AbstractSQLProvider;
import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class PostgreSQLAddressSpaceFunctions {
    private PostgreSQLAddressSpaceFunctions() {
    }

    private static void checkArguments(AbstractSQLProvider provider, INaviAddressSpace addressSpace) {
        Preconditions.checkNotNull(provider, "IE00387: Provider argument can not be null");
        Preconditions.checkNotNull(addressSpace, "IE00388: Address space argument can not be null");
        Preconditions.checkArgument(addressSpace.inSameDatabase(provider), "IE00389: Address space is not part of this database");
    }

    public static void addModule(AbstractSQLProvider provider, INaviAddressSpace addressSpace, INaviModule module) throws CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.checkArguments(provider, addressSpace);
        Preconditions.checkNotNull(module, "IE01859: Module argument can not be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE01860: Module is not part of this database");
        CConnection connection = provider.getConnection();
        int addressSpaceId = addressSpace.getConfiguration().getId();
        int moduleId = module.getConfiguration().getId();
        NaviLogger.info("Adding module %s (%d) to address space %s (%d)", addressSpace.getConfiguration().getName(), addressSpaceId, module.getConfiguration().getName(), moduleId);
        String string2 = String.valueOf("INSERT INTO bn_space_modules VALUES(");
        String query = new StringBuilder(28 + String.valueOf(string2).length()).append(string2).append(moduleId).append(", ").append(addressSpaceId).append(", 0)").toString();
        try {
            connection.executeUpdate(query, true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
        PostgreSQLHelpers.updateModificationDate(connection, "bn_address_spaces", addressSpace.getConfiguration().getId());
    }

    public static void assignDebugger(AbstractSQLProvider provider, CAddressSpace addressSpace, DebuggerTemplate debugger) throws CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.checkArguments(provider, addressSpace);
        if (debugger != null && !debugger.inSameDatabase(provider)) {
            throw new IllegalArgumentException("IE00392: Debugger is not part of this database");
        }
        CConnection connection = provider.getConnection();
        try {
            String debuggerValue = debugger == null ? "NULL" : String.valueOf(debugger.getId());
            String query = String.format("UPDATE %s SET debugger_id = %s WHERE id= %d", "bn_address_spaces", debuggerValue, addressSpace.getConfiguration().getId());
            connection.executeUpdate(query, true);
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
        PostgreSQLHelpers.updateModificationDate(connection, "bn_address_spaces", addressSpace.getConfiguration().getId());
    }

    public static void deleteAddressSpace(AbstractSQLProvider provider, INaviAddressSpace addressSpace) throws CouldntDeleteException {
        PostgreSQLAddressSpaceFunctions.checkArguments(provider, addressSpace);
        NaviLogger.info("Deleting address space %s", addressSpace.getConfiguration().getName());
        PostgreSQLHelpers.deleteById(provider.getConnection(), "bn_address_spaces", addressSpace.getConfiguration().getId());
    }

    public static Date getModificationDate(AbstractSQLProvider provider, CAddressSpace addressSpace) throws CouldntLoadDataException {
        PostgreSQLAddressSpaceFunctions.checkArguments(provider, addressSpace);
        return PostgreSQLHelpers.getModificationDate(provider.getConnection(), "bn_address_spaces", addressSpace.getConfiguration().getId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Pair<IAddress, INaviModule>> loadModules(AbstractSQLProvider provider, CAddressSpace addressSpace) throws CouldntLoadDataException {
        PostgreSQLAddressSpaceFunctions.checkArguments(provider, addressSpace);
        CConnection connection = provider.getConnection();
        ArrayList<Pair<IAddress, INaviModule>> modules = new ArrayList<Pair<IAddress, INaviModule>>();
        String string2 = String.valueOf("SELECT id, name, md5, sha1, description, import_time, bn_space_modules.image_base  FROM bn_space_modules JOIN bn_modules ON id = module_id WHERE address_space_id = ");
        int n2 = addressSpace.getConfiguration().getId();
        String query = new StringBuilder(11 + String.valueOf(string2).length()).append(string2).append(n2).toString();
        try (ResultSet resultSet = connection.executeQuery(query, true);){
            while (resultSet.next()) {
                IAddress imageBase = PostgreSQLHelpers.loadAddress(resultSet, "image_base");
                INaviModule module = provider.findModule(resultSet.getInt("id"));
                modules.add(new Pair<IAddress, INaviModule>(imageBase, module));
            }
            ArrayList<Pair<IAddress, INaviModule>> arrayList = modules;
            return arrayList;
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    public static void removeModule(AbstractSQLProvider provider, INaviAddressSpace addressSpace, INaviModule module) throws CouldntDeleteException, CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.checkArguments(provider, addressSpace);
        Preconditions.checkNotNull(module, "IE00393: Module argument can not be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE00394: Module is not part of this database");
        CConnection connection = provider.getConnection();
        String string2 = String.valueOf("DELETE FROM bn_space_modules WHERE address_space_id = ");
        int n2 = addressSpace.getConfiguration().getId();
        int n3 = module.getConfiguration().getId();
        String query = new StringBuilder(39 + String.valueOf(string2).length()).append(string2).append(n2).append(" AND module_id = ").append(n3).toString();
        try {
            connection.executeUpdate(query, true);
        }
        catch (SQLException e2) {
            throw new CouldntDeleteException(e2);
        }
        PostgreSQLHelpers.updateModificationDate(connection, "bn_address_spaces", addressSpace.getConfiguration().getId());
    }

    public static void setDescription(AbstractSQLProvider provider, CAddressSpace addressSpace, String description) throws CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.checkArguments(provider, addressSpace);
        Preconditions.checkNotNull(description, "IE00395: Description argument can not be null");
        CConnection connection = provider.getConnection();
        PostgreSQLHelpers.setDescription(connection, addressSpace.getConfiguration().getId(), description, "bn_address_spaces");
        PostgreSQLHelpers.updateModificationDate(connection, "bn_address_spaces", addressSpace.getConfiguration().getId());
    }

    public static void setImageBase(AbstractSQLProvider provider, INaviAddressSpace addressSpace, INaviModule module, IAddress address) throws CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.checkArguments(provider, addressSpace);
        Preconditions.checkNotNull(module, "IE00396: Module argument can not be null");
        Preconditions.checkNotNull(address, "IE00397: Address argument can not be null");
        Preconditions.checkArgument(module.inSameDatabase(provider), "IE00398: Module is not part of this database");
        CConnection connection = provider.getConnection();
        try {
            String query = String.format("UPDATE %s SET image_base = %s  WHERE module_id = %d AND address_space_id = %d", "bn_space_modules", address.toBigInteger().toString(), module.getConfiguration().getId(), addressSpace.getConfiguration().getId());
            connection.executeUpdate(query, true);
        }
        catch (SQLException e2) {
            throw new CouldntSaveDataException(e2);
        }
        PostgreSQLHelpers.updateModificationDate(connection, "bn_address_spaces", addressSpace.getConfiguration().getId());
    }

    public static void setName(AbstractSQLProvider provider, CAddressSpace addressSpace, String name) throws CouldntSaveDataException {
        PostgreSQLAddressSpaceFunctions.checkArguments(provider, addressSpace);
        Preconditions.checkNotNull(name, "IE00399: Name argument can not be null");
        CConnection connection = provider.getConnection();
        PostgreSQLHelpers.setName(connection, addressSpace.getConfiguration().getId(), name, "bn_address_spaces");
        PostgreSQLHelpers.updateModificationDate(connection, "bn_address_spaces", addressSpace.getConfiguration().getId());
    }
}

