/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.NodeParser;

import com.google.security.zynamics.binnavi.Database.NodeParser.ICodeNodeProvider;
import com.google.security.zynamics.binnavi.Database.NodeParser.ParserException;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLHelpers;
import com.google.security.zynamics.binnavi.disassembly.CReference;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.ReferenceType;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SqlCodeNodeProvider
implements ICodeNodeProvider {
    private final ResultSet m_resultSet;

    public SqlCodeNodeProvider(ResultSet resultSet) {
        this.m_resultSet = resultSet;
    }

    @Override
    public IAddress getInstructionAddress() throws ParserException {
        try {
            return PostgreSQLHelpers.loadAddress(this.m_resultSet, "instruction_address");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public String getInstructionArchitecture() throws ParserException {
        try {
            return PostgreSQLHelpers.readString(this.m_resultSet, "architecture");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public int getBorderColor() throws ParserException {
        try {
            return this.m_resultSet.getInt("bordercolor");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public int getColor() throws ParserException {
        try {
            return this.m_resultSet.getInt("color");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public byte[] getData() throws ParserException {
        try {
            return this.m_resultSet.getBytes("instruction_data");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public int getExpressionTreeId() throws ParserException {
        try {
            return this.m_resultSet.getInt("expression_tree_id");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public int getExpressionTreeType() throws ParserException {
        try {
            return this.m_resultSet.getInt("expression_tree_type");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public IAddress getFunctionAddress() throws ParserException {
        try {
            return PostgreSQLHelpers.loadAddress(this.m_resultSet, "function_address");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public Integer getGlobalInstructionCommentId() throws ParserException {
        try {
            int instructionCommentId = this.m_resultSet.getInt("global_instruction_comment");
            if (this.m_resultSet.wasNull()) {
                return null;
            }
            return instructionCommentId;
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public Integer getLocalInstructionCommentId() throws ParserException {
        try {
            int localInstructionCommentId = this.m_resultSet.getInt("local_instruction_comment");
            if (this.m_resultSet.wasNull()) {
                return null;
            }
            return localInstructionCommentId;
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public Integer getGlobalNodeCommentId() throws ParserException {
        try {
            int globalCodeNodeCommentId = this.m_resultSet.getInt("global_code_node_comment");
            if (this.m_resultSet.wasNull()) {
                return null;
            }
            return globalCodeNodeCommentId;
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public Integer getLocalNodeCommentId() throws ParserException {
        try {
            int localCommentId = this.m_resultSet.getInt("local_code_node_comment");
            if (this.m_resultSet.wasNull()) {
                return null;
            }
            return localCommentId;
        }
        catch (SQLException exception) {
            throw new ParserException(exception);
        }
    }

    @Override
    public double getHeight() throws ParserException {
        try {
            return this.m_resultSet.getDouble("height");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public String getImmediate() throws ParserException {
        try {
            return PostgreSQLHelpers.readString(this.m_resultSet, "immediate");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public String getMnemonic() throws ParserException {
        try {
            return PostgreSQLHelpers.readString(this.m_resultSet, "mnemonic");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public int getModule() throws ParserException {
        try {
            return this.m_resultSet.getInt("module_id");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public int getNodeId() throws ParserException {
        try {
            return this.m_resultSet.getInt("node_id");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public Integer getOperandPosition() throws ParserException {
        try {
            int position = this.m_resultSet.getInt("operand_position");
            return this.m_resultSet.wasNull() ? null : Integer.valueOf(position);
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public IAddress getParentFunction() throws ParserException {
        try {
            return PostgreSQLHelpers.loadAddress(this.m_resultSet, "parent_function");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public int getParentId() throws ParserException {
        try {
            return this.m_resultSet.getInt("expression_tree_parent_id");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public CReference getReference() throws ParserException {
        try {
            IAddress address = PostgreSQLHelpers.loadAddress(this.m_resultSet, "target");
            if (address != null) {
                return new CReference(PostgreSQLHelpers.loadAddress(this.m_resultSet, "target"), ReferenceType.valueOf(this.m_resultSet.getString("address_references_type").toUpperCase()));
            }
            return null;
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public String getReplacement() throws ParserException {
        try {
            return PostgreSQLHelpers.readString(this.m_resultSet, "replacement");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public int getSubstitutionOffset() throws ParserException {
        try {
            return this.m_resultSet.getInt("expression_types_offset");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public int getSubstitutionPosition() throws ParserException {
        try {
            return this.m_resultSet.getInt("expression_types_position");
        }
        catch (SQLException exception) {
            throw new ParserException(exception);
        }
    }

    @Override
    public Integer getSubstitutionTypeId() throws ParserException {
        try {
            Integer typeId = this.m_resultSet.getInt("expression_types_type");
            if (this.m_resultSet.wasNull()) {
                return null;
            }
            return typeId;
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public String getSymbol() throws ParserException {
        try {
            return PostgreSQLHelpers.readString(this.m_resultSet, "symbol");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public Integer getTypeInstanceId() throws ParserException {
        try {
            Integer typeInstanceId = this.m_resultSet.getInt("type_instance_id");
            if (this.m_resultSet.wasNull()) {
                return null;
            }
            return typeInstanceId;
        }
        catch (SQLException exception) {
            throw new ParserException(exception);
        }
    }

    @Override
    public double getWidth() throws ParserException {
        try {
            return this.m_resultSet.getDouble("width");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public double getX() throws ParserException {
        try {
            return this.m_resultSet.getDouble("x");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public double getY() throws ParserException {
        try {
            return this.m_resultSet.getDouble("y");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public boolean isAfterLast() throws ParserException {
        try {
            return this.m_resultSet.isAfterLast();
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public boolean isSelected() throws ParserException {
        try {
            return this.m_resultSet.getBoolean("selected");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public boolean isVisible() throws ParserException {
        try {
            return this.m_resultSet.getBoolean("visible");
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public boolean next() throws ParserException {
        try {
            return this.m_resultSet.next();
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public boolean prev() throws ParserException {
        try {
            return this.m_resultSet.previous();
        }
        catch (SQLException e2) {
            throw new ParserException(e2);
        }
    }

    @Override
    public Integer[] getSubstitutionPath() throws ParserException {
        try {
            Array array = this.m_resultSet.getArray("expression_types_path");
            if (this.m_resultSet.wasNull()) {
                return new Integer[0];
            }
            return (Integer[])array.getArray();
        }
        catch (SQLException exception) {
            throw new ParserException(exception);
        }
    }
}

