/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database.NodeParser;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.CReference;
import com.google.security.zynamics.binnavi.disassembly.INaviReplacement;
import com.google.security.zynamics.binnavi.disassembly.types.RawTypeSubstitution;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IReference;
import java.util.ArrayList;
import java.util.List;

public final class OperandTreeNode {
    private final int m_id;
    private final int m_type;
    private final String m_value;
    private final Integer m_parentId;
    private final INaviReplacement m_replacement;
    private final List<CReference> m_reference;
    private final RawTypeSubstitution substitution;
    private final Integer typeInstanceId;
    private final int position;
    private final IAddress address;

    public OperandTreeNode(int operandId, int type, String value, Integer parentId, INaviReplacement replacement, List<CReference> references, RawTypeSubstitution substitution, Integer instanceId, int operandPosition, IAddress address) {
        this.m_value = Preconditions.checkNotNull(value, "IE01298: Value argument can not be null");
        this.m_id = operandId;
        this.m_type = type;
        this.m_parentId = parentId;
        this.m_replacement = replacement;
        this.m_reference = references;
        this.substitution = substitution;
        this.typeInstanceId = instanceId;
        this.position = operandPosition;
        this.address = address;
    }

    public IAddress getAddress() {
        return this.address;
    }

    public int getPosition() {
        return this.position;
    }

    public int getId() {
        return this.m_id;
    }

    public Integer getTypeInstanceId() {
        return this.typeInstanceId;
    }

    public Integer getParentId() {
        return this.m_parentId;
    }

    public List<IReference> getReferences() {
        return new ArrayList<IReference>(this.m_reference);
    }

    public INaviReplacement getReplacement() {
        return this.m_replacement;
    }

    public int getType() {
        return this.m_type;
    }

    public RawTypeSubstitution getTypeSubstitution() {
        return this.substitution;
    }

    public String getValue() {
        return this.m_value;
    }

    public String toString() {
        return this.m_value;
    }
}

