/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.zylib.general.Convert;

public final class DatabaseVersion {
    private final String version;

    public DatabaseVersion(String version2) {
        String string2 = String.valueOf(version2);
        Preconditions.checkArgument(DatabaseVersion.isValidVersionNumber(version2), string2.length() != 0 ? "IE00707: Invalid database version string: ".concat(string2) : new String("IE00707: Invalid database version string: "));
        this.version = version2;
    }

    private static boolean isValidVersionNumber(String version2) {
        if (version2 == null) {
            return false;
        }
        String[] parts = version2.split("\\.");
        if (parts.length != 3) {
            return false;
        }
        for (String part : parts) {
            if (Convert.isDecString(part)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(DatabaseVersion version2) {
        int subVersionDB;
        int mainVersionDB;
        String[] naviSplit = this.version.split("\\.");
        String[] dbSplit = version2.getString().split("\\.");
        int mainVersionNavi = Integer.parseInt(naviSplit[0]);
        if (mainVersionNavi != (mainVersionDB = Integer.parseInt(dbSplit[0]))) {
            return mainVersionNavi - mainVersionDB;
        }
        int subVersionNavi = Integer.parseInt(naviSplit[1]);
        if (subVersionNavi != (subVersionDB = Integer.parseInt(dbSplit[1]))) {
            return subVersionNavi - subVersionDB;
        }
        int buildVersionNavi = Integer.parseInt(naviSplit[2]);
        int buildVersionDB = Integer.parseInt(dbSplit[2]);
        return buildVersionNavi - buildVersionDB;
    }

    public boolean equals(Object rhs) {
        return rhs instanceof DatabaseVersion && this.version.equals(((DatabaseVersion)rhs).version);
    }

    public String getString() {
        return this.version;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean needsUpgrading(DatabaseVersion fromVersion) {
        return fromVersion.getString().equals("4.0.0") || fromVersion.getString().equals("5.0.0");
    }
}

