/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseContent;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseListener;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Tagging.CTagManager;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager;
import com.google.security.zynamics.binnavi.disassembly.CProject;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import java.util.ArrayList;
import java.util.List;

public final class CDatabaseContent
implements IDatabaseContent {
    private final SQLProvider m_provider;
    private final IDatabase m_database;
    private final ListenerProvider<IDatabaseListener> m_listeners;
    private final List<INaviProject> m_projects;
    private final List<INaviModule> m_modules;
    private final List<INaviRawModule> m_rawModules;
    private final DebuggerTemplateManager m_debuggerDescriptionManager;
    private final CTagManager m_viewTagManager;
    private final CTagManager m_nodeTagManager;

    public CDatabaseContent(SQLProvider provider, IDatabase database, ListenerProvider<IDatabaseListener> listeners, List<INaviProject> projects, List<INaviModule> modules, List<INaviRawModule> rawModules, CTagManager viewTagManager, CTagManager nodeTagManager, DebuggerTemplateManager debuggerDescriptionManager) {
        this.m_viewTagManager = Preconditions.checkNotNull(viewTagManager, "IE00051: View tag manager can not be null");
        this.m_provider = Preconditions.checkNotNull(provider, "IE00053: Database content provider can not be null");
        this.m_database = Preconditions.checkNotNull(database, "IE00390: Database can not be null");
        this.m_listeners = Preconditions.checkNotNull(listeners, "IE00391: Database listeners can not be null");
        this.m_projects = Preconditions.checkNotNull(projects, "IE00410: Projects can not be null");
        this.m_modules = Preconditions.checkNotNull(modules, "IE00412: Modules can not be null");
        this.m_rawModules = Preconditions.checkNotNull(rawModules, "IE00420: Raw modules can not be null");
        this.m_nodeTagManager = Preconditions.checkNotNull(nodeTagManager, "IE00441: Node tag manager can not be null");
        this.m_debuggerDescriptionManager = Preconditions.checkNotNull(debuggerDescriptionManager, "IE00442: Debugger descriptor manager can not be null");
    }

    private static boolean hasModule(List<INaviModule> modules, final INaviRawModule rawModule) {
        return CollectionHelpers.any(modules, new ICollectionFilter<INaviModule>(){

            @Override
            public boolean qualifies(INaviModule item) {
                return item.getConfiguration().getRawModule().getId() == rawModule.getId();
            }
        });
    }

    private CModule createModule(INaviRawModule rawModule) throws CouldntLoadDataException, CouldntSaveDataException {
        CModule newModule = this.m_provider.createModule(rawModule);
        this.m_modules.add(newModule);
        return newModule;
    }

    private void removeDeletedModuleFromNamespaces(INaviModule module) {
        for (INaviProject project : this.m_projects) {
            if (!project.isLoaded()) continue;
            for (INaviAddressSpace addressSpace : project.getContent().getAddressSpaces()) {
                if (!addressSpace.isLoaded() || !addressSpace.getContent().getModules().contains(module)) continue;
                try {
                    addressSpace.getContent().removeModule(module);
                }
                catch (CouldntDeleteException | CouldntSaveDataException exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }

    List<INaviModule> initializeRawModules(List<INaviModule> modules, List<INaviRawModule> rawModules) {
        ArrayList<INaviModule> newModules = new ArrayList<INaviModule>();
        for (INaviRawModule rawModule : rawModules) {
            if (CDatabaseContent.hasModule(modules, rawModule)) continue;
            try {
                newModules.add(this.createModule(rawModule));
            }
            catch (CouldntLoadDataException | CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
            }
        }
        return newModules;
    }

    @Override
    public INaviProject addProject(String name) throws CouldntSaveDataException {
        Preconditions.checkNotNull(name, "IE00661: Project name can not be null");
        Preconditions.checkArgument(this.m_database.isConnected(), "IE00662: Database must be connected before a project can be added");
        Preconditions.checkArgument(this.m_database.isLoaded(), "IE00663: Database must be loaded before a project can be added");
        CProject newProject = this.m_provider.createProject(name);
        this.m_projects.add(newProject);
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.addedProject(this.m_database, newProject);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        return newProject;
    }

    @Override
    public void delete(INaviModule module) throws CouldntDeleteException {
        Preconditions.checkNotNull(module, "IE00670: Module can not be null");
        Preconditions.checkArgument(this.m_database.isConnected(), "IE00671: Database must be connected before you can delete modules");
        Preconditions.checkArgument(this.m_database.isLoaded(), "IE00672: Database must be loaded before you can delete modules");
        Preconditions.checkArgument(this.m_modules.contains(module), "IE00673: Module does not belong to this database");
        this.m_provider.deleteModule(module);
        this.m_modules.remove(module);
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.deletedModule(this.m_database, module);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        this.removeDeletedModuleFromNamespaces(module);
    }

    @Override
    public void delete(INaviProject project) throws CouldntDeleteException {
        Preconditions.checkNotNull(project, "IE00674: Project can not be null");
        Preconditions.checkArgument(this.m_database.isConnected(), "IE00675: Database must be connected before you can delete projects");
        Preconditions.checkArgument(this.m_database.isLoaded(), "IE00676: Database must be loaded before you can delete projects");
        Preconditions.checkArgument(this.m_projects.contains(project), "IE00677: Project does not belong to the database");
        this.m_provider.deleteProject(project);
        this.m_projects.remove(project);
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.deletedProject(this.m_database, project);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public void delete(INaviRawModule rawModule) throws CouldntDeleteException {
        Preconditions.checkNotNull(rawModule, "IE00006: Raw module can not be null");
        Preconditions.checkArgument(this.m_database.isConnected(), "IE00031: Database must be connected before you can delete raw modules");
        Preconditions.checkArgument(this.m_database.isLoaded(), "IE00036: Database must be loaded before you can delete raw modules");
        Preconditions.checkArgument(this.m_rawModules.contains(rawModule), "IE00038: Raw module does not belong to this database");
        this.m_provider.deleteRawModule(rawModule);
        this.m_rawModules.remove(rawModule);
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.deletedRawModule(this.m_database, rawModule);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    @Override
    public DebuggerTemplateManager getDebuggerTemplateManager() {
        return this.m_debuggerDescriptionManager;
    }

    @Override
    public INaviModule getModule(int moduleId) {
        for (INaviModule module : this.m_modules) {
            if (module.getConfiguration().getId() != moduleId) continue;
            return module;
        }
        return null;
    }

    @Override
    public List<INaviModule> getModules() {
        return new ArrayList<INaviModule>(this.m_modules);
    }

    @Override
    public CTagManager getNodeTagManager() {
        return this.m_nodeTagManager;
    }

    @Override
    public List<INaviProject> getProjects() throws IllegalStateException {
        return new ArrayList<INaviProject>(this.m_projects);
    }

    @Override
    public List<INaviRawModule> getRawModules() {
        return new ArrayList<INaviRawModule>(this.m_rawModules);
    }

    @Override
    public CTagManager getViewTagManager() {
        return this.m_viewTagManager;
    }

    @Override
    public void refreshRawModules() throws CouldntLoadDataException {
        Preconditions.checkArgument(this.m_database.isConnected(), "IE00687: Not connected to the database");
        Preconditions.checkArgument(this.m_database.isLoaded(), "IE00688: Raw modules were not loaded previously");
        List<INaviRawModule> oldModules = this.m_rawModules;
        List<INaviRawModule> refreshedModules = this.m_provider.loadRawModules();
        this.m_rawModules.clear();
        this.m_rawModules.addAll(refreshedModules);
        List<INaviModule> newModules = this.initializeRawModules(this.m_modules, refreshedModules);
        for (IDatabaseListener listener : this.m_listeners) {
            try {
                listener.changedRawModules(this.m_database, oldModules, refreshedModules);
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
        for (INaviModule naviModule : newModules) {
            for (IDatabaseListener listener : this.m_listeners) {
                try {
                    listener.addedModule(this.m_database, naviModule);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

