/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.security.zynamics.binnavi.Database.CConnection;
import com.google.security.zynamics.binnavi.Database.CDatabaseConfiguration;
import com.google.security.zynamics.binnavi.Database.DatabaseVersion;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntConnectException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntInitializeDatabaseException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDriverException;
import com.google.security.zynamics.binnavi.Database.Exceptions.InvalidDatabaseException;
import com.google.security.zynamics.binnavi.Database.Exceptions.InvalidExporterDatabaseFormatException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseLoadProgressReporter;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.LoadEvents;
import com.google.security.zynamics.binnavi.Database.PostgreSQLProvider;
import com.google.security.zynamics.zylib.general.Pair;
import java.sql.SQLException;

public final class CDatabaseConnection {
    private CDatabaseConnection() {
    }

    private static void reportProgress(IDatabaseLoadProgressReporter<LoadEvents> reporter, LoadEvents event) throws LoadCancelledException {
        if (!reporter.report(event)) {
            throw new LoadCancelledException();
        }
    }

    public static Pair<CConnection, SQLProvider> connect(CDatabaseConfiguration m_databaseConfiguration, IDatabaseLoadProgressReporter<LoadEvents> reporter) throws CouldntLoadDriverException, CouldntConnectException, CouldntInitializeDatabaseException, InvalidDatabaseException, InvalidExporterDatabaseFormatException, LoadCancelledException {
        try {
            CDatabaseConnection.reportProgress(reporter, LoadEvents.CONNECTING_TO_DATABASE);
            CConnection connection = new CConnection(m_databaseConfiguration);
            PostgreSQLProvider sql = new PostgreSQLProvider(connection);
            CDatabaseConnection.reportProgress(reporter, LoadEvents.CHECKING_EXPORTER_TABLE_FORMAT);
            if (!sql.isExporterDatabaseFormatValid()) {
                throw new InvalidExporterDatabaseFormatException("E00202: Database exporter format is not compatible with BinNavi 6.1");
            }
            CDatabaseConnection.reportProgress(reporter, LoadEvents.CHECKING_INITIALIZATION_STATUS);
            DatabaseVersion databaseVersion = sql.getDatabaseVersion();
            DatabaseVersion currentVersion = new DatabaseVersion("6.0.1");
            if (databaseVersion.compareTo(currentVersion) == 0 && !sql.isInitialized()) {
                CDatabaseConnection.reportProgress(reporter, LoadEvents.INITIALIZING_DATABASE_TABLES);
                sql.initializeDatabase();
            }
            if (databaseVersion.compareTo(currentVersion) == 0 && !sql.isInitialized()) {
                throw new CouldntInitializeDatabaseException("E00052: Database could not be initialized.");
            }
            return new Pair<CConnection, SQLProvider>(connection, sql);
        }
        catch (CouldntLoadDataException e2) {
            throw new CouldntConnectException(e2, 0, "");
        }
        catch (SQLException e3) {
            throw new CouldntConnectException(e3, e3.getErrorCode(), e3.getSQLState());
        }
    }
}

