/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Database;

import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.ModuleConverter;
import com.google.security.zynamics.binnavi.Database.Interfaces.SQLProvider;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Creators.PostgreSQLModuleCreator;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Creators.PostgreSQLNativeViewCreator;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.Functions.PostgreSQLModuleFunctions;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLBorderColorizer;
import com.google.security.zynamics.binnavi.Database.PostgreSQL.PostgreSQLDataImporter;
import com.google.security.zynamics.binnavi.Gui.Users.CUserManager;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviRawModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleInitializeReporter;
import com.google.security.zynamics.binnavi.disassembly.Modules.ModuleInitializeEvents;
import java.sql.CallableStatement;
import java.sql.SQLException;

public abstract class AbstractModuleCreator
implements ModuleConverter {
    protected void colorizeNativeCodeNodeBorderColors(int moduleId) throws SQLException {
        PostgreSQLBorderColorizer.setInitialBorderColors(this.getProvider().getConnection(), moduleId);
    }

    protected void connectExpressionTrees(int moduleId, int rawModuleId) throws SQLException {
        PostgreSQLDataImporter.connectExpressionTrees(this.getProvider().getConnection(), moduleId, rawModuleId);
    }

    protected void connectInstructionsToCodeNodes(int rawModuleId, int moduleId) throws SQLException {
        PostgreSQLModuleCreator.connectInstructionsToCodeNodes(this.getProvider().getConnection(), rawModuleId, moduleId);
    }

    protected abstract void connectViewsFunctions(int var1, int var2) throws SQLException;

    protected void createNativeCallgraphEdges(int rawModuleId, int moduleId) throws SQLException {
        PostgreSQLNativeViewCreator.createNativeCallgraphEdges(this.getProvider().getConnection(), rawModuleId, moduleId);
    }

    protected abstract void createNativeCallgraphNodes(int var1, int var2) throws SQLException;

    protected abstract int createNativeCallgraphView(int var1) throws SQLException;

    protected abstract void createNativeCodeNodes(int var1, int var2) throws SQLException;

    protected abstract void createNativeFlowgraphEdges(int var1, int var2) throws SQLException;

    protected abstract int createNativeFlowgraphViews(int var1) throws SQLException;

    protected abstract int createNewModule(INaviRawModule var1) throws SQLException;

    protected abstract SQLProvider getProvider();

    protected abstract void importAddressReferences(int var1, int var2) throws SQLException;

    protected void importBaseTypes(int rawModuleId, int moduleId) throws SQLException {
        PostgreSQLDataImporter.importBaseTypes(this.getProvider().getConnection(), rawModuleId, moduleId);
    }

    protected void importExpressionSubstitutions(int rawModuleId, int moduleId) throws SQLException {
        PostgreSQLDataImporter.importExpressionSubstitutions(this.getProvider().getConnection(), rawModuleId, moduleId);
    }

    protected void importExpressionTree(int moduleId, int rawModuleId) throws SQLException {
        PostgreSQLDataImporter.importExpressionTree(this.getProvider().getConnection(), moduleId, rawModuleId);
    }

    protected void importExpressionTrees(int moduleId, int rawModuleId) throws SQLException {
        PostgreSQLDataImporter.importExpressionTrees(this.getProvider().getConnection(), moduleId, rawModuleId);
    }

    protected abstract void importFunctions(int var1, int var2) throws SQLException;

    protected void importInstructions(int rawModuleId, int moduleId) throws SQLException, CouldntLoadDataException {
        PostgreSQLDataImporter.importInstructions(this.getProvider(), rawModuleId, moduleId);
    }

    protected void importOperands(int rawModuleId, int moduleId) throws SQLException {
        PostgreSQLDataImporter.importOperands(this.getProvider().getConnection(), rawModuleId, moduleId);
    }

    protected void importTypes(int rawModuleId, int moduleId) throws SQLException {
        PostgreSQLDataImporter.importTypes(this.getProvider().getConnection(), rawModuleId, moduleId);
    }

    protected void importTypeSubstitutions(int rawModuleId, int moduleId) throws SQLException {
        PostgreSQLDataImporter.importExpressionTypes(this.getProvider().getConnection(), rawModuleId, moduleId);
    }

    protected CModule readModule(int moduleId, INaviRawModule rawModule, SQLProvider provider) throws CouldntLoadDataException {
        return PostgreSQLModuleFunctions.readModule(this.getProvider().getConnection(), moduleId, rawModule, provider);
    }

    @Override
    public CModule createModule(SQLProvider provider, INaviRawModule rawModule) throws CouldntLoadDataException, CouldntSaveDataException {
        NaviLogger.info("Starting to convert raw module %s", rawModule.getName());
        int moduleId = -1;
        try {
            NaviLogger.info("Creating a new module for raw module %s", rawModule.getName());
            moduleId = this.createNewModule(rawModule);
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
        NaviLogger.info("Loading module %d", moduleId);
        return this.readModule(moduleId, rawModule, provider);
    }

    @Override
    public void initializeModule(SQLProvider sqlProvider, INaviModule module, CModuleInitializeReporter reporter) throws CouldntSaveDataException {
        int moduleId = module.getConfiguration().getId();
        INaviRawModule rawModule = module.getConfiguration().getRawModule();
        if (!rawModule.isComplete()) {
            throw new CouldntSaveDataException("E00008: Raw module is incomplete");
        }
        try {
            reporter.report(ModuleInitializeEvents.Starting);
            String query = " { call import(?,?,?) } ";
            CallableStatement call = this.getProvider().getConnection().getConnection().prepareCall(" { call import(?,?,?) } ");
            call.setInt(1, rawModule.getId());
            call.setInt(2, moduleId);
            call.setInt(3, CUserManager.get(this.getProvider()).getCurrentActiveUser().getUserId());
            call.execute();
            module.setInitialized();
        }
        catch (SQLException exception) {
            throw new CouldntSaveDataException(exception);
        }
        finally {
            reporter.report(ModuleInitializeEvents.Finished);
        }
    }
}

