/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi;

import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.zylib.general.StackTrace;

public final class CUtilityFunctions {
    private CUtilityFunctions() {
    }

    public static String createDescription(String description, String[] causes, String[] impacts) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(description);
        stringBuilder.append('\n');
        if (causes.length != 0) {
            stringBuilder.append('\n');
            stringBuilder.append("Possible causes:\n");
            for (String cause : causes) {
                stringBuilder.append("  - ");
                stringBuilder.append(cause);
                stringBuilder.append('\n');
            }
        }
        if (impacts.length != 0) {
            stringBuilder.append('\n');
            stringBuilder.append("Problem impact:\n");
            for (String impact : impacts) {
                stringBuilder.append("  - ");
                stringBuilder.append(impact);
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public static void logException(Throwable exception) {
        String string2 = String.valueOf("Reason: ");
        String string3 = String.valueOf(exception.getLocalizedMessage());
        NaviLogger.severe(string3.length() != 0 ? string2.concat(string3) : new String(string2), new Object[0]);
        NaviLogger.severe(StackTrace.toString(exception.getStackTrace()), new Object[0]);
    }
}

