/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.reil.mono;

import com.google.security.zynamics.binnavi.API.disassembly.IGraphNode;
import com.google.security.zynamics.binnavi.API.reil.ReilInstruction;
import com.google.security.zynamics.binnavi.API.reil.mono.InstructionGraphEdge;
import java.util.ArrayList;
import java.util.List;

public final class InstructionGraphNode
implements IGraphNode<InstructionGraphNode> {
    private final ReilInstruction instruction;
    private final List<InstructionGraphEdge> outgoingEdges = new ArrayList<InstructionGraphEdge>();
    private final List<InstructionGraphEdge> incomingEdges = new ArrayList<InstructionGraphEdge>();

    public InstructionGraphNode(ReilInstruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException("Error: Instruction argument can not be null");
        }
        this.instruction = instruction;
    }

    public static void link(InstructionGraphNode source, InstructionGraphNode target, InstructionGraphEdge edge) {
        if (source == null) {
            throw new IllegalArgumentException("Error: Source argument can not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Error: Target argument can not be null");
        }
        if (edge == null) {
            throw new IllegalArgumentException("Error: Edge argument can not be null");
        }
        source.outgoingEdges.add(edge);
        target.incomingEdges.add(edge);
    }

    public static void unlink(InstructionGraphNode source, InstructionGraphNode target, InstructionGraphEdge edge) {
        source.outgoingEdges.remove(edge);
        target.incomingEdges.remove(edge);
    }

    @Override
    public List<InstructionGraphNode> getChildren() {
        ArrayList<InstructionGraphNode> children = new ArrayList<InstructionGraphNode>();
        for (InstructionGraphEdge edge : this.outgoingEdges) {
            children.add(edge.getTarget());
        }
        return children;
    }

    public List<InstructionGraphEdge> getIncomingEdges() {
        return new ArrayList<InstructionGraphEdge>(this.incomingEdges);
    }

    public ReilInstruction getInstruction() {
        return this.instruction;
    }

    public List<InstructionGraphEdge> getOutgoingEdges() {
        return new ArrayList<InstructionGraphEdge>(this.outgoingEdges);
    }

    @Override
    public List<InstructionGraphNode> getParents() {
        ArrayList<InstructionGraphNode> parents = new ArrayList<InstructionGraphNode>();
        for (InstructionGraphEdge edge : this.incomingEdges) {
            parents.add(edge.getSource());
        }
        return parents;
    }

    public String toString() {
        return this.instruction.toString();
    }
}

