/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.reil.mono;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.reil.mono.ILatticeElement;
import com.google.security.zynamics.binnavi.API.reil.mono.IStateVector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultStateVector<GraphNode, LatticeElement extends ILatticeElement<LatticeElement>>
implements IStateVector<GraphNode, LatticeElement>,
Iterable<GraphNode> {
    private final Map<GraphNode, LatticeElement> mapping = new HashMap<GraphNode, LatticeElement>();

    @Override
    public final LatticeElement getState(GraphNode node) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        return (LatticeElement)((ILatticeElement)this.mapping.get(node));
    }

    @Override
    public final boolean hasState(GraphNode node) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        return this.mapping.containsKey(node);
    }

    @Override
    public final Iterator<GraphNode> iterator() {
        return this.mapping.keySet().iterator();
    }

    @Override
    public final void setState(GraphNode node, LatticeElement element) {
        Preconditions.checkNotNull(node, "Error: node argument can not be null");
        Preconditions.checkNotNull(element, "Error: element argument can not be null");
        this.mapping.put(node, element);
    }

    @Override
    public final int size() {
        return this.mapping.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\n");
        for (Map.Entry<GraphNode, LatticeElement> entry : this.mapping.entrySet()) {
            String string2 = String.valueOf(entry.getKey());
            String string3 = String.valueOf(entry.getValue());
            stringBuilder.append(new StringBuilder(4 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" -> ").append(string3).toString());
            stringBuilder.append('\n');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

