/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.reil;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.reil.ReilOperand;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.util.HashMap;
import java.util.Map;

public final class ReilInstruction
implements ApiObject<com.google.security.zynamics.reil.ReilInstruction> {
    private final com.google.security.zynamics.reil.ReilInstruction m_instruction;
    private final ReilOperand m_firstOperand;
    private final ReilOperand m_secondOperand;
    private final ReilOperand m_thirdOperand;

    public ReilInstruction(Address address, String mnemonic, ReilOperand firstOperand, ReilOperand secondOperand, ReilOperand thirdOperand) {
        this(new com.google.security.zynamics.reil.ReilInstruction(new CAddress(ReilInstruction.check(address).toLong()), ReilInstruction.checkMnemonic(mnemonic), ReilInstruction.check1(firstOperand).getNative(), ReilInstruction.check2(secondOperand).getNative(), ReilInstruction.check3(thirdOperand).getNative()));
    }

    public ReilInstruction(com.google.security.zynamics.reil.ReilInstruction instruction) {
        this.m_instruction = instruction;
        this.m_firstOperand = new ReilOperand(instruction.getFirstOperand());
        this.m_secondOperand = new ReilOperand(instruction.getSecondOperand());
        this.m_thirdOperand = new ReilOperand(instruction.getThirdOperand());
    }

    private static Address check(Address address) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        return address;
    }

    private static ReilOperand check1(ReilOperand firstOperand) {
        Preconditions.checkNotNull(firstOperand, "Error: First operand can not be null");
        return firstOperand;
    }

    private static ReilOperand check2(ReilOperand secondOperand) {
        Preconditions.checkNotNull(secondOperand, "Error: Second operand can not be null");
        return secondOperand;
    }

    private static ReilOperand check3(ReilOperand thirdOperand) {
        Preconditions.checkNotNull(thirdOperand, "Error: Third operand can not be null");
        return thirdOperand;
    }

    private static String checkMnemonic(String mnemonic) {
        Preconditions.checkNotNull(mnemonic, "Error: mnemonic argument can not be null");
        Preconditions.checkArgument(ReilHelpers.isValidReilMnemonic(mnemonic), "Error: mnemonic argument is not a valid REIL mnemonic");
        return mnemonic;
    }

    public static ReilInstruction createAdd(Address address, ReilOperand firstOperand, ReilOperand secondOperand, ReilOperand thirdOperand) {
        return new ReilInstruction(address, "add", firstOperand, secondOperand, thirdOperand);
    }

    public static ReilInstruction createAnd(Address address, ReilOperand firstOperand, ReilOperand secondOperand, ReilOperand thirdOperand) {
        return new ReilInstruction(address, "and", firstOperand, secondOperand, thirdOperand);
    }

    public static ReilInstruction createBisz(Address address, ReilOperand inputValue, ReilOperand outputValue) {
        return new ReilInstruction(address, "bisz", inputValue, ReilOperand.EMPTY_OPERAND, outputValue);
    }

    public static ReilInstruction createBsh(Address address, ReilOperand firstOperand, ReilOperand secondOperand, ReilOperand thirdOperand) {
        return new ReilInstruction(address, "bsh", firstOperand, secondOperand, thirdOperand);
    }

    public static ReilInstruction createDiv(Address address, ReilOperand firstOperand, ReilOperand secondOperand, ReilOperand thirdOperand) {
        return new ReilInstruction(address, "div", firstOperand, secondOperand, thirdOperand);
    }

    public static ReilInstruction createJcc(Address address, ReilOperand jumpCondition, ReilOperand jumpTarget) {
        return new ReilInstruction(address, "jcc", jumpCondition, ReilOperand.EMPTY_OPERAND, jumpTarget);
    }

    public static ReilInstruction createLdm(Address address, ReilOperand loadSource, ReilOperand loadTarget) {
        return new ReilInstruction(address, "ldm", loadSource, ReilOperand.EMPTY_OPERAND, loadTarget);
    }

    public static ReilInstruction createMod(Address address, ReilOperand firstOperand, ReilOperand secondOperand, ReilOperand thirdOperand) {
        return new ReilInstruction(address, "mod", firstOperand, secondOperand, thirdOperand);
    }

    public static ReilInstruction createMul(Address address, ReilOperand firstOperand, ReilOperand secondOperand, ReilOperand thirdOperand) {
        return new ReilInstruction(address, "mul", firstOperand, secondOperand, thirdOperand);
    }

    public static ReilInstruction createNop(Address address) {
        return new ReilInstruction(address, "nop", ReilOperand.EMPTY_OPERAND, ReilOperand.EMPTY_OPERAND, ReilOperand.EMPTY_OPERAND);
    }

    public static ReilInstruction createOr(Address address, ReilOperand firstOperand, ReilOperand secondOperand, ReilOperand thirdOperand) {
        return new ReilInstruction(address, "or", firstOperand, secondOperand, thirdOperand);
    }

    public static ReilInstruction createStm(Address address, ReilOperand storeValue, ReilOperand storeTarget) {
        return new ReilInstruction(address, "stm", storeValue, ReilOperand.EMPTY_OPERAND, storeTarget);
    }

    public static ReilInstruction createStr(Address address, ReilOperand storeValue, ReilOperand storeTarget) {
        return new ReilInstruction(address, "str", storeValue, ReilOperand.EMPTY_OPERAND, storeTarget);
    }

    public static ReilInstruction createSub(Address address, ReilOperand firstOperand, ReilOperand secondOperand, ReilOperand thirdOperand) {
        return new ReilInstruction(address, "sub", firstOperand, secondOperand, thirdOperand);
    }

    public static ReilInstruction createUndef(Address address) {
        return new ReilInstruction(address, "undef", ReilOperand.EMPTY_OPERAND, ReilOperand.EMPTY_OPERAND, ReilOperand.EMPTY_OPERAND);
    }

    public static ReilInstruction createUnknown(Address address) {
        return new ReilInstruction(address, "unkn", ReilOperand.EMPTY_OPERAND, ReilOperand.EMPTY_OPERAND, ReilOperand.EMPTY_OPERAND);
    }

    public static ReilInstruction createXor(Address address, ReilOperand firstOperand, ReilOperand secondOperand, ReilOperand thirdOperand) {
        return new ReilInstruction(address, "xor", firstOperand, secondOperand, thirdOperand);
    }

    @Override
    public com.google.security.zynamics.reil.ReilInstruction getNative() {
        return this.m_instruction;
    }

    public Address getAddress() {
        return new Address(this.m_instruction.getAddress().toBigInteger());
    }

    public ReilOperand getFirstOperand() {
        return this.m_firstOperand;
    }

    public Map<String, String> getMetaData() {
        return new HashMap<String, String>(this.m_instruction.getMetaData());
    }

    public String getMnemonic() {
        return this.m_instruction.getMnemonic();
    }

    public ReilOperand getSecondOperand() {
        return this.m_secondOperand;
    }

    public ReilOperand getThirdOperand() {
        return this.m_thirdOperand;
    }

    public void setMetaData(String key, String value) {
        Preconditions.checkNotNull(key, "Error: Key argument can not be null");
        this.m_instruction.setMetaData(key, value);
    }

    public String toString() {
        return this.m_instruction.toString();
    }
}

