/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.plugins;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.DatabaseManager;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.Project;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewContainer;
import com.google.security.zynamics.binnavi.API.gui.GraphWindow;
import com.google.security.zynamics.binnavi.API.gui.MainWindow;
import com.google.security.zynamics.binnavi.API.plugins.IPluginInterfaceListener;
import com.google.security.zynamics.binnavi.API.plugins.PluginRegistry;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabaseManager;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphContainerWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphWindowListener;
import com.google.security.zynamics.binnavi.Gui.Loaders.CViewOpener;
import com.google.security.zynamics.binnavi.Gui.WindowManager.CWindowManager;
import com.google.security.zynamics.binnavi.Gui.WindowManager.IWindowManagerListener;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.Startup.CPluginLoader;
import com.google.security.zynamics.binnavi.api2.IPluginInterface;
import com.google.security.zynamics.binnavi.api2.plugins.IPlugin;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.disassembly.CProjectContainer;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleContainer;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.standardplugins.PluginLoader;
import com.google.security.zynamics.binnavi.yfileswrap.API.disassembly.View2D;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.Collection;
import java.util.List;

public final class PluginInterface
implements IPluginInterface {
    private static PluginInterface instance;
    private final String startPath;
    private final DatabaseManager manager;
    private final PluginRegistry registry;
    private MainWindow mainWindow;
    private final ListenerProvider<IPluginInterfaceListener> listeners = new ListenerProvider();

    private PluginInterface(String startPath, IDatabaseManager manager, com.google.security.zynamics.binnavi.Plugins.PluginRegistry registry) {
        Preconditions.checkNotNull(manager, "Database manager can't be null");
        this.startPath = startPath;
        this.manager = new DatabaseManager(manager);
        this.registry = new PluginRegistry(registry);
    }

    public static PluginInterface instance() {
        Preconditions.checkNotNull(instance, "Error: Plugin interface was not yet instantiated");
        return instance;
    }

    public static PluginInterface instance(String startPath, IDatabaseManager manager, com.google.security.zynamics.binnavi.Plugins.PluginRegistry registry) {
        if (instance != null) {
            throw new IllegalStateException("Error: Plugin interface can not be instantiated more than once");
        }
        instance = new PluginInterface(startPath, manager, registry);
        return instance;
    }

    private View2D show(CGraphWindow graphWindow, View view, IViewContainer container) {
        for (CGraphWindow window : CWindowManager.instance()) {
            for (IGraphPanel panel : window) {
                if (panel.getModel().getGraph().getRawView() != view.getNative()) continue;
                return panel.getModel().getView2D();
            }
        }
        WindowWaiter waiter = new WindowWaiter(view.getNative());
        CWindowManager.instance().addListener(waiter);
        List<CGraphWindow> openBefore = CWindowManager.instance().getOpenWindows();
        for (CGraphWindow window : openBefore) {
            window.addListener(waiter);
        }
        CViewOpener.showView(this.mainWindow.getFrame(), container, view.getNative(), graphWindow);
        while (waiter.getModel() == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exception) {
                CUtilityFunctions.logException(exception);
                Thread.currentThread().interrupt();
            }
        }
        CGraphModel model = waiter.getModel();
        CWindowManager.instance().removeListener(waiter);
        for (CGraphWindow window : openBefore) {
            window.removeListener(waiter);
        }
        return model.getView2D();
    }

    public void addListener(IPluginInterfaceListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public DatabaseManager getDatabaseManager() {
        return this.manager;
    }

    @Override
    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public PluginRegistry getPluginRegistry() {
        return this.registry;
    }

    public String getProgramPath() {
        return this.startPath;
    }

    public void reloadPlugins() {
        this.registry.getNative().unloadAll();
        NaviLogger.info("Loading built-in plugins...", new Object[0]);
        Collection<IPlugin<IPluginInterface>> plugins = new PluginLoader().getPlugins();
        for (IPlugin<IPluginInterface> plugin : plugins) {
            this.registry.addPlugin(plugin);
        }
        CPluginLoader.loadPlugins(this.mainWindow.getFrame(), this, this.registry.getNative(), this.startPath, ConfigManager.instance());
        for (IPluginInterfaceListener listener : this.listeners) {
            try {
                listener.loadedPlugins();
            }
            catch (Exception exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public void removeListener(IPluginInterfaceListener listener) {
        this.listeners.removeListener(listener);
    }

    public void setMainWindow(MainWindow mainWindow) {
        if (this.mainWindow != null) {
            throw new IllegalStateException("Error: Main window was already set");
        }
        this.mainWindow = mainWindow;
    }

    public View2D showInLastWindow(View view) {
        Preconditions.checkNotNull(view, "Error: View argument can not be null");
        ViewContainer container = view.getContainer();
        if (container instanceof Module) {
            Module module = (Module)container;
            return this.show(CWindowManager.instance().getLastWindow(), view, new CModuleContainer(container.getDatabase().getNative(), module.getNative()));
        }
        Project project = (Project)container;
        return this.show(CWindowManager.instance().getLastWindow(), view, new CProjectContainer(container.getDatabase().getNative(), project.getNative()));
    }

    public View2D showInNewWindow(View view) {
        Preconditions.checkNotNull(view, "Error: View argument can not be null");
        ViewContainer container = view.getContainer();
        if (container instanceof Module) {
            Module module = (Module)container;
            return this.show(null, view, new CModuleContainer(container.getDatabase().getNative(), module.getNative()));
        }
        Project project = (Project)container;
        return this.show(null, view, new CProjectContainer(container.getDatabase().getNative(), project.getNative()));
    }

    public View2D showInWindow(GraphWindow window, View view) {
        Preconditions.checkNotNull(view, "Error: View argument can not be null");
        ViewContainer container = view.getContainer();
        if (container instanceof Module) {
            Module module = (Module)container;
            return this.show(window.getNative(), view, new CModuleContainer(container.getDatabase().getNative(), module.getNative()));
        }
        Project project = (Project)container;
        return this.show(window.getNative(), view, new CProjectContainer(container.getDatabase().getNative(), project.getNative()));
    }

    public String toString() {
        return "BinNavi Plugin Interface";
    }

    private class WindowWaiter
    implements IWindowManagerListener,
    IGraphWindowListener {
        private final INaviView m_view;
        private CGraphModel m_model;

        public WindowWaiter(INaviView view) {
            this.m_view = view;
        }

        private void processPanel(IGraphPanel panel) {
            if (panel.getModel().getGraph().getRawView() == this.m_view) {
                this.m_model = panel.getModel();
            }
        }

        public CGraphModel getModel() {
            return this.m_model;
        }

        @Override
        public void graphPanelClosed() {
        }

        @Override
        public void graphPanelOpened(CGraphPanel graphPanel) {
            this.processPanel(graphPanel);
        }

        @Override
        public void windowClosed(CWindowManager windowManager, IGraphContainerWindow window) {
        }

        @Override
        public void windowOpened(CWindowManager windowManager, IGraphContainerWindow window) {
            for (IGraphPanel panel : window) {
                this.processPanel(panel);
            }
        }
    }
}

