/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.helpers;

import com.google.security.zynamics.binnavi.API.disassembly.IDirectedGraph;
import com.google.security.zynamics.binnavi.API.disassembly.IGraphNode;
import com.google.security.zynamics.binnavi.API.disassembly.ITreeNode;
import com.google.security.zynamics.binnavi.API.helpers.MalformedGraphException;
import com.google.security.zynamics.binnavi.API.helpers.Tree;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.graphs.algorithms.LengauerTarjan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public final class GraphAlgorithms {
    private GraphAlgorithms() {
    }

    public static <T extends IGraphNode<T>> HashMap<T, ArrayList<T>> getBackEdges(IDirectedGraph<T, ?> graph, T rootNode) throws MalformedGraphException {
        try {
            return com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms.getBackEdges(graph, rootNode);
        }
        catch (com.google.security.zynamics.zylib.types.graphs.algorithms.MalformedGraphException e2) {
            throw new MalformedGraphException(e2);
        }
    }

    public static <T extends IGraphNode<T>> Tree<T> getDominatorTree(IDirectedGraph<T, ?> graph, T rootNode, HashMap<T, ITreeNode<T>> mapping) throws MalformedGraphException {
        try {
            Pair<com.google.security.zynamics.zylib.types.trees.Tree<T>, HashMap<T, com.google.security.zynamics.zylib.types.trees.ITreeNode<T>>> resultPair = LengauerTarjan.calculate(graph, rootNode);
            if (mapping != null) {
                for (IGraphNode t2 : resultPair.second().keySet()) {
                    mapping.put(t2, (ITreeNode)resultPair.second().get(t2));
                }
            }
            return new Tree<T>(resultPair.first());
        }
        catch (com.google.security.zynamics.zylib.types.graphs.algorithms.MalformedGraphException e2) {
            throw new MalformedGraphException(e2);
        }
    }

    public static <T extends IGraphNode<T>> ArrayList<Set<T>> getGraphLoops(IDirectedGraph<T, ?> graph) throws MalformedGraphException {
        try {
            return com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms.getGraphLoops(graph);
        }
        catch (com.google.security.zynamics.zylib.types.graphs.algorithms.MalformedGraphException e2) {
            throw new MalformedGraphException(e2);
        }
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getLoopNodes(NodeType srcNode, NodeType dstNode) {
        return new HashSet<NodeType>(com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms.getLoopNodes(srcNode, dstNode));
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getPredecessors(NodeType node) {
        return new HashSet(com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms.getPredecessors(node));
    }

    public static <NodeType extends IGraphNode<NodeType>> Set<NodeType> getSuccessors(NodeType node) {
        return new HashSet(com.google.security.zynamics.zylib.types.graphs.GraphAlgorithms.getSuccessors(node));
    }
}

